#!/bin/sh

printf "\\n=== Begin of system information block ===\\n"

# get eth0 information
set -- $(ifconfig eth0 | grep "HWaddr")
ETH0_HWADDR=$(printf "%s\\n" "$5")
set -- $(ifconfig eth0 | grep "inet addr")
ETH0_IPADDR=$(printf "%s\\n" "$2" | cut -d':' -f2)
ETH0_NETMASK=$(printf "%s\\n" "$4" | cut -d':' -f2)

# get wlan0 information
set -- $(ifconfig wlan0 | grep "HWaddr")
WLAN0_HWADDR=$(printf "%s\\n" "$5")
set -- $(ifconfig wlan0 | grep "inet addr")
WLAN0_IPADDR=$(printf "%s\\n" "$2" | cut -d':' -f2)
WLAN0_NETMASK=$(printf "%s\\n" "$4" | cut -d':' -f2)

[ -r "/opt/extparam/ipmodule_id" ]                  && printf "ipmodule_id                  : %s\\n" "$(cat /opt/extparam/ipmodule_id)"
[ -r "/opt/extparam/ipmodule_version" ]             && printf "ipmodule_version             : %s\\n" "$(cat /opt/extparam/ipmodule_version)"
[ -r "/opt/extparam/ipmodule_revision" ]            && printf "ipmodule_revision            : %s\\n" "$(cat /opt/extparam/ipmodule_revision)"
[ -r "/opt/extparam/extmodule_id" ]                 && printf "extmodule_id                 : %s\\n" "$(cat /opt/extparam/extmodule_id)"
[ -r "/opt/extparam/extmodule_version" ]            && printf "extmodule_version            : %s\\n" "$(cat /opt/extparam/extmodule_version)"
[ -r "/opt/extparam/extmodule_revision" ]           && printf "extmodule_revision           : %s\\n" "$(cat /opt/extparam/extmodule_revision)"
[ -r "/opt/extparam/manufacturer_id" ]              && printf "manufacturer_id              : %s\\n" "$(cat /opt/extparam/manufacturer_id)"
[ -r "/opt/extparam/device_id" ]                    && printf "device_id                    : %s\\n" "$(cat /opt/extparam/device_id)"
[ -r "/opt/extparam/device_uid" ]                   && printf "device_uid                   : %s\\n" "$(cat /opt/extparam/device_uid)"
[ -r "/opt/extparam/device_guid" ]                  && printf "device_guid                  : %s\\n" "$(cat /opt/extparam/device_guid)"
[ -r "/opt/extparam/device_version" ]               && printf "device_version               : %s\\n" "$(cat /opt/extparam/device_version)"
[ -r "/opt/extparam/serial_number" ]                && printf "serial_number                : %s\\n" "$(cat /opt/extparam/serial_number)"
[ -r "/opt/extparam/hostname" ]                     && printf "hostname                     : %s\\n" "$(cat /opt/extparam/hostname)"
[ -r "/opt/extparam/knx_serialnumber_0" ]           && printf "knx_serialnumber_0           : %s\\n" "$(cat /opt/extparam/knx_serialnumber_0)"
[ -r "/opt/extparam/knx_serialnumber_1" ]           && printf "knx_serialnumber_1           : %s\\n" "$(cat /opt/extparam/knx_serialnumber_1)"
[ -r "/opt/extparam/knx_serialnumber_2" ]           && printf "knx_serialnumber_2           : %s\\n" "$(cat /opt/extparam/knx_serialnumber_2)"
[ -r "/opt/extparam/knx_serialnumber_3" ]           && printf "knx_serialnumber_3           : %s\\n" "$(cat /opt/extparam/knx_serialnumber_3)"
[ -r "/opt/extparam/mac_address_0" ]                && printf "mac_address_0                : %s\\n" "$(cat /opt/extparam/mac_address_0)"
[ -r "/opt/extparam/mac_address_1" ]                && printf "mac_address_1                : %s\\n" "$(cat /opt/extparam/mac_address_1)"
[ -r "/opt/extparam/mac_address_2" ]                && printf "mac_address_2                : %s\\n" "$(cat /opt/extparam/mac_address_2)"
[ -r "/opt/extparam/mac_address_3" ]                && printf "mac_address_3                : %s\\n" "$(cat /opt/extparam/mac_address_3)"
[ -r "/opt/extparam/supported_systems" ]            && printf "supported_systems            : %s\\n" "$(cat /opt/extparam/supported_systems)"
[ -r "/opt/extparam/booted_system" ]                && printf "booted_system                : %s\\n" "$(cat /opt/extparam/booted_system)"
[ -r "/opt/extparam/offline_system" ]               && printf "offline_system               : %s\\n" "$(cat /opt/extparam/offline_system)"
[ -r "/opt/extparam/system_A_application_version" ] && printf "system_A_application_version : %s\\n" "$(cat /opt/extparam/system_A_application_version)"
[ -r "/opt/extparam/system_A_boot_counter" ]        && printf "system_A_boot_counter        : %s\\n" "$(cat /opt/extparam/system_A_boot_counter)"
[ -r "/opt/extparam/system_A_firmware_version" ]    && printf "system_A_firmware_version    : %s\\n" "$(cat /opt/extparam/system_A_firmware_version)"
[ -r "/opt/extparam/system_A_root_blkdev" ]         && printf "system_A_root_blkdev         : %s\\n" "$(cat /opt/extparam/system_A_root_blkdev)"
[ -r "/opt/extparam/system_A_system_version" ]      && printf "system_A_system_version      : %s\\n" "$(cat /opt/extparam/system_A_system_version)"
[ -r "/opt/extparam/system_B_application_version" ] && printf "system_B_application_version : %s\\n" "$(cat /opt/extparam/system_B_application_version)"
[ -r "/opt/extparam/system_B_boot_counter" ]        && printf "system_B_boot_counter        : %s\\n" "$(cat /opt/extparam/system_B_boot_counter)"
[ -r "/opt/extparam/system_B_firmware_version" ]    && printf "system_B_firmware_version    : %s\\n" "$(cat /opt/extparam/system_B_firmware_version)"
[ -r "/opt/extparam/system_B_root_blkdev" ]         && printf "system_B_root_blkdev         : %s\\n" "$(cat /opt/extparam/system_B_root_blkdev)"
[ -r "/opt/extparam/system_B_system_version" ]      && printf "system_B_system_version      : %s\\n" "$(cat /opt/extparam/system_B_system_version)"
[ -r "/opt/extparam/userdata_root_blkdev" ]         && printf "userdata_root_blkdev         : %s\\n" "$(cat /opt/extparam/userdata_root_blkdev)"
[ -r "/opt/extparam/bootloader_version" ]           && printf "bootloader_version           : %s\\n" "$(cat /opt/extparam/bootloader_version)"
[ -r "/opt/extparam/bootscript_version" ]           && printf "bootscript_version           : %s\\n" "$(cat /opt/extparam/bootscript_version)"
[ -r "/opt/extparam/bootstrap_version" ]            && printf "bootstrap_version            : %s\\n" "$(cat /opt/extparam/bootstrap_version)"
                                                       printf "eth0_hwaddr                  : %s\\n" "${ETH0_HWADDR}"
                                                       printf "eth0_ipaddr                  : %s\\n" "${ETH0_IPADDR}"
                                                       printf "eth0_netmask                 : %s\\n" "${ETH0_NETMASK}"
                                                       printf "wlan0_hwaddr                 : %s\\n" "${WLAN0_HWADDR}"
                                                       printf "wlan0_ipaddr                 : %s\\n" "${WLAN0_IPADDR}"
                                                       printf "wlan0_netmask                : %s\\n" "${WLAN0_NETMASK}"
[ -r "/sys/bus/mmc/devices/mmc0:0001/name" ]        && printf "mmc0_name                    : %s\\n" "$(cat /sys/bus/mmc/devices/mmc0:0001/name)"
printf "=== End of system information block   ===\\n\\n"
