#!/bin/sh

me="[factory-reset.sh]"
printf "%s Enter.\\n" "${me}"

source /opt/gira/share/devicestack/ipmodule-vars

for reset_file in "${EMERGENCY_FACTORY_RESET_FILE}" "${FACTORY_RESET_FILE}"
do
  if [ -f "$reset_file" ]
  then
    # cat file and remove spaces, newlines, cariagereturns and tabs if any.
    FACTORY_RESET_CONDITION=`cat ${reset_file} | tr -d '\040\011\012\015'`
    if [ "enabled" = "${FACTORY_RESET_CONDITION}" ]
    then
      printf "%s Factory reset found enabled. Cleaning userdata partition.\\n" "${me}"
      printf "%s Reformatting %s.\\n" "${me}" "${UD_BLOCKDEV}"
      /sbin/mkfs.ext3 -F ${UD_BLOCKDEV}
      sync
      printf "%s Removing file: %s\\n" "${me}" "${reset_file}"
      rm -f ${reset_file}
      printf "%s Done.\\n" "${me}"
      exit 0
    fi
  fi
done

printf "%s Nothing to do.\\n" "${me}"
exit 0

