#!/bin/sh

printf "[extparam.sh] Enter.\\n"

# Load ipmodule variables
. /opt/gira/share/devicestack/ipmodule-vars

# This is meant as workaround for the yocto sd-card image.
# Should be removed as soon as it is not used anymore.
if ! [ -f /opt/gira/etc/devicestack/device.config ] && [ -f /opt/gira/etc/devicestack/emulation.config ]
then
	if ! [ -f "${COMMISSIONED_FILE}" ]
	then
		touch "${COMMISSIONED_FILE}"
	fi
fi

case "$1" in
  start)
    # Parse kernel commandline options.
    #
    root=""
    for o in `cat /proc/cmdline`
    do
      case $o in
        root=*)
        root=${o#root=}
        ;;
      esac
    done

    if [ -z $root ]
    then
      printf "[extparam.sh] Failed to detect booted root block device.\\n"
    fi

    printf "%s\\n" "$root" > /var/run/root_blkdev

    SUPPORTED_SYSTEMS=$(cat ${EXTPARAM}/supported_systems)

# If we have /dev/ram0 as root device we are in commissioning mode.
	if ! [ "${root}" = "/dev/ram0" ]
	then
		for s in `cat ${EXTPARAM}/supported_systems`
		do
		  case $root in `cat ${EXTPARAM}/system_${s}_root_blkdev`)
		      BOOTED_SYSTEM=${s}
		      printf "%s\\n" "${BOOTED_SYSTEM}" > ${BOOTED_SYSTEM_FILE}
		      if [ "${BOOTED_SYSTEM}" = "A" ]
		      then
		        OFFLINE_SYSTEM="B"
		      else
		        OFFLINE_SYSTEM="A"
		      fi
		      printf "%s\\n" "${OFFLINE_SYSTEM}" > /var/run/offline_system
		      ;;
		  esac
		done
	else
		BOOTED_SYSTEM="A"
		printf "A\\n" > ${BOOTED_SYSTEM_FILE}
		OFFLINE_SYSTEM="B"
		printf "B\\n" > /var/run/offline_system
	fi

    cd /var/run

    ln -sf ${EXTPARAM}/system_${BOOTED_SYSTEM}_firmware_version booted_firmware_version
    ln -sf ${EXTPARAM}/system_${BOOTED_SYSTEM}_application_version booted_application_version
    ln -sf ${EXTPARAM}/system_${BOOTED_SYSTEM}_system_version booted_system_version
    ln -sf ${EXTPARAM}/system_${BOOTED_SYSTEM}_root_blkdev booted_root_blkdev
    ln -sf ${EXTPARAM}/system_${BOOTED_SYSTEM}_kernel_blkdev booted_kernel_blkdev
    ln -sf system_${BOOTED_SYSTEM}_boot_counter booted_boot_counter
    ln -sf ${EXTPARAM}/system_${OFFLINE_SYSTEM}_firmware_version offline_firmware_version
    ln -sf ${EXTPARAM}/system_${OFFLINE_SYSTEM}_application_version offline_application_version
    ln -sf ${EXTPARAM}/system_${OFFLINE_SYSTEM}_system_version offline_system_version
    ln -sf ${EXTPARAM}/system_${OFFLINE_SYSTEM}_root_blkdev offline_root_blkdev
    ln -sf ${EXTPARAM}/system_${OFFLINE_SYSTEM}_kernel_blkdev offline_kernel_blkdev
    ln -sf system_${OFFLINE_SYSTEM}_boot_counter offline_boot_counter

    cd ${EXTPARAM}
    [ -h booted_application_version ] || ln -sf /var/run/booted_application_version
    [ -h booted_system_version ] || ln -sf /var/run/booted_system_version
    [ -h booted_firmware_version ] || ln -sf /var/run/booted_firmware_version
    [ -h booted_boot_counter ] || ln -sf /var/run/booted_boot_counter
    [ -h booted_root_blkdev ] || ln -sf /var/run/booted_root_blkdev
    [ -h booted_system ] || ln -sf ${BOOTED_SYSTEM_FILE}
    [ -h offline_application_version ] || ln -sf /var/run/offline_application_version
    [ -h offline_system_version ] || ln -sf /var/run/offline_system_version
    [ -h offline_firmware_version ] || ln -sf /var/run/offline_firmware_version
    [ -h offline_boot_counter ] || ln -sf /var/run/offline_boot_counter
    [ -h offline_root_blkdev ] || ln -sf /var/run/offline_root_blkdev
    [ -h offline_system ] || ln -sf /var/run/offline_system
    [ -h system_A_boot_counter ] || ln -sf /var/run/system_A_boot_counter
    [ -h system_B_boot_counter ] || ln -sf /var/run/system_B_boot_counter
# As the hostname will be set earlier in rcS the hostname file is already created
# within hostname.sh.
#    [ -h hostname ] || ln -sf /var/run/hostname

    # Read boot counter.
    fw_printenv bcA | cut -d "=" -f 2 > /var/run/system_A_boot_counter
    fw_printenv bcB | cut -d "=" -f 2 > /var/run/system_B_boot_counter

    MANUFACTURER_ID=""
    [ -f "${EXTPARAM}/manufacturer_id" ] && MANUFACTURER_ID=$(cat "${EXTPARAM}/manufacturer_id")

    DEVICE_ID=""
    [ -f "${EXTPARAM}/device_id" ] && DEVICE_ID=$(cat "${EXTPARAM}/device_id")

    if [ -f "${EXTPARAM}/mac_address_0" ]
    then
      MAC0_WITHOUT_COLONS=$(head -n 1 /opt/extparam/mac_address_0 | tr -d ':' | tr '[:lower:]' '[:upper:]')
      LAST_SIX_OF_MAC0=${MAC0_WITHOUT_COLONS:6:6}
      SN="${MANUFACTURER_ID}${DEVICE_ID}${LAST_SIX_OF_MAC0}"
      if [ -f "${EXTPARAM}/serial_number" ]
      then
        SN_EXT=$(head -n 1 "${EXTPARAM}/serial_number")
        if [ "${SN}" = "${SN_EXT}" ]
        then
          printf "[extparam.sh] serial_number is OK.\\n"
        else
          printf "[extparam.sh] serial_number is not OK. Will now update serial_number file.\\n"
          printf "%s\\n" "${SN}" > "${EXTPARAM}/serial_number"
        fi
      else
        printf "[extparam.sh] serial_number is not OK. Will now create serial_number file.\\n"
        printf "%s\\n" "${SN}" > "${EXTPARAM}/serial_number"
      fi
    else
      printf "[extparam.sh] serial_number is missing, but this is OK, if the device is not yet commissioned.\\n"
    fi
    
    if [ -e ${GIRA_BIN}/sync-eth0-mac-address.sh ]
    then
      ${GIRA_BIN}/sync-eth0-mac-address.sh
    fi
    if [ -e ${GIRA_BIN}/sync-uid.sh ]
    then
      ${GIRA_BIN}/sync-uid.sh
    fi
    if [ -e ${GIRA_BIN}/sync-wlan0-mac-address.sh ]
    then
      ${GIRA_BIN}/sync-wlan0-mac-address.sh
    fi
    ;;
  stop)
    ;;
  *)
    printf "Usage: %s (start|stop)\\n" "$0"
    exit 1
esac

printf "[extparam.sh] Exit.\\n"

exit 0
