#!/bin/sh

export_gpios()
{
  if [ ! -d /sys/class/gpio/gpio38 ]; then
    printf "exporting GPIO38 (PHY_RSTn)\\n"
    printf "38\\n" > /sys/class/gpio/export
  fi

  if [ ! -d /sys/class/gpio/gpio39 ]; then
    printf "exporting GPIO39 (PHY_INT)\\n"
    printf "39\\n" > /sys/class/gpio/export
  fi
}

unexport_gpios()
{

  if [ -d /sys/class/gpio/gpio38 ]; then
    printf "unexporting GPIO38 (PHY_RSTn)\\n"
    printf "38\\n" > /sys/class/gpio/unexport
  fi

  if [ -d /sys/class/gpio/gpio39 ]; then
    printf "unexporting GPIO39 (PHY_INT)\\n"
    printf "39\\n" > /sys/class/gpio/unexport
  fi
}

trap "{ unexport_gpios; }" EXIT

enable_ethernet()
{
  export_gpios
  printf "enable ethernet\\n"
  printf "out\\n" > /sys/class/gpio/gpio38/direction
  printf "0\\n" > /sys/class/gpio/gpio38/value
  printf "out\\n" > /sys/class/gpio/gpio39/direction
  printf "1\\n" > /sys/class/gpio/gpio39/value
  printf "1\\n" > /sys/class/gpio/gpio38/value
  ifconfig eth0 up
}

disable_ethernet()
{
  ifconfig eth0 down
  export_gpios
  printf "disable ethernet\\n"
  printf "out\\n" > /sys/class/gpio/gpio38/direction
  printf "1\\n" > /sys/class/gpio/gpio38/value
  printf "out\\n" > /sys/class/gpio/gpio39/direction
  printf "0\\n" > /sys/class/gpio/gpio39/value
}

command=$1
case ${command} in
enable)
 enable_ethernet
 ;;
disable)
 disable_ethernet
 ;;
reenable)
 disable_ethernet
 unexport_gpios
 enable_ethernet
 ;;
*)
 printf "usage: %s enable|disable|reenable\\n" "$(basename $0)"
 exit 1
 ;;
esac

exit 0
