#!/bin/sh

print_usage()
{
  printf "Usage:\\n"
  printf "exchange-bootloader.sh device bootloaderfile\\n"
  printf "e.g. : exchange-bootloader.sh /dev/mmcblk0 u-boot-imx6sgc4.imx\\n"
}

target_device="$1"
bootloader_file="$2"

if [ "$target_device" = "" ] || [ "$bootloader_file" = "" ]
then
  printf "Not enough arguments!\\n"
  print_usage
  exit 1
fi

if [ ! -e "$target_device" ]
then
  printf "Target device does not exist!\\n"
  exit 1
fi

if [ ! "`ls -lLa \"${target_device}\"| cut -b 0-1`" = "b" ]
then
  printf "Target device is no block device!\\n"
  exit 1
fi

if [ ! "`printf \"${target_device}\\n\"| cut -b 0-4`" = "/dev" ]
then
  echo "target device is not in /dev"
  exit 1
fi

if [ ! -e "$bootloader_file" ]
then
  printf "Bootloader file does not exist!\\n"
  exit 1
fi

filesize=`ls -l $bootloader_file | awk '{ print $5 }'`
installed_checksum=`dd if="$target_device"  bs=1 count="$filesize"  skip=1024 | md5sum | cut -d " " -f1`
bootloader_checksum=`md5sum "$bootloader_file" | cut -d " " -f1`

printf "Installed bootloader checksum: %s\\n" "$installed_checksum"
printf "Devicepackage's bootloader checksum: %s\\n" "$bootloader_checksum"

if [ "$installed_checksum" = "$bootloader_checksum" ]
then
  printf "Do not exchange bootloader\\n"
else
  printf "Exchanging bootloader...\\n"
  dd if=$bootloader_file bs=1K seek=1 of=$target_device
  if [ "$?" -ne 0 ]
  then
    printf "Exchanging the bootloader failed!\\n"
    exit 1
  fi
  printf "Bootloader successfully exchanged!\\n"
fi

exit 0
