﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <div>
    <xsl:variable name="detailId">detail-<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
    <xsl:call-template name="channel_detail_description_row"/>
      <div class="detail">
        <xsl:attribute name="id">
          <xsl:copy-of select="$detailId" />
        </xsl:attribute>
        <xsl:attribute name="data-trigger-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='Trigger']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-status-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='State']/@Id"/>
        </xsl:attribute>
        <div class="trigger-container">
          <div>
            <xsl:attribute name="class">
              <xsl:text>trigger-button sprites {{detail-button}} </xsl:text>
              <xsl:if test="Channel/StatusLed/@Enable = 'false'">shadow-trigger</xsl:if>
            </xsl:attribute>   
            <xsl:if test="Channel/StatusTexts/@Enable = 'true'">
              <span class="trigger-text-off t1sg">
                <xsl:value-of select="Channel/StatusTexts/Off" />
              </span>
              <span class="trigger-text-on t1sg">
                <xsl:value-of select="Channel/StatusTexts/On" />
              </span>
            </xsl:if>
          </div>
          <xsl:if test="Channel/StatusLed/@Enable = 'true'">
            <div>
              <xsl:attribute name="class">
                <xsl:text>trigger-ring ring1 sprites {{statusring-</xsl:text>
                <xsl:value-of select="Channel/StatusLed/@On"/>
                <xsl:text>}}</xsl:text>
              </xsl:attribute>
            </div>
            <div>
              <xsl:attribute name="class">
                <xsl:text>trigger-ring ring2 sprites {{statusring-</xsl:text>
                <xsl:value-of select="Channel/StatusLed/@Off"/>
                <xsl:text>}}</xsl:text>
              </xsl:attribute>
            </div>
          </xsl:if>
        </div>
      </div>
      <script type="text/javascript">
        (function(){
        var detailId = '#<xsl:copy-of select="$detailId" />';
        var dataset = document.getElementById('<xsl:copy-of select="$detailId" />').dataset;
        eventsOnTrigger(detailId, dataset.triggerId);

        <xsl:if test="Channel/StatusTexts/@Enable = 'true' or Channel/StatusLed/@Enable = 'true'">
          temporaryCaseSets.push(new CaseSet(dataset.statusId, CaseSetType.CONTENT)
          .addCase(new Case().setExpectedValue(1).setNewValue(true))
          .addCase(new Case().setExpectedValue(0).setNewValue(false))
          .setOnValueFunction(function(value) {
          changeTriggerButtonState(value, detailId);
          })
          );
          if($(detailId).data('init') !== true){
          initTriggerButtonState(parseInt(ComClient.getTagValue(dataset.statusId),10), detailId);
          $(detailId).data('init', true);
          };
        </xsl:if>
        })();
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>

