﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">

    .timer-description-row {
    position: relative;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-description-row']/width" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-description-row']/height" />px;
    background-color: rgb( 225, 225, 225);
    -webkit-transform: translateZ(0);
    }

    .timer-description-row .timer-description-row-text {
    padding-top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-description-row-text']/padding-top" />px;
    padding-left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-description-row-text']/padding-left" />px;
    position: relative;
    }

    .timer-controls {
    position: relative;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-controls']/height" />px;
    border: none;
    border-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #FFFFFF;
    border-bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #c8c8c8;
    -webkit-transform: translateZ(0);
    }

    .timer-controls #delete, .timer-controls .add-timer{
    opacity: 1;
    }

    .timer-controls #delete{
    pointer-events: none;
    position: absolute;
    }

    .timer-fadeout
    {
    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba(245,245,245,1)), color-stop(100%,rgba(245,245,245,0)));
    }

    .timer-overview {
    position: absolute;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-overview']/width" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-overview']/height" />px;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-overview']/top" />px;
    }

    .timer-header {
    }

    .timer-overview-controls {
    }

    .timer-active-control {
    }

    .timer-list {
    -webkit-backface-visibility: hidden;
    backface-visibility:hidden;
    -webkit-transform: translateZ(0);
    }

    .timer-row {
    border: none;
    border-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #FFFFFF;
    border-bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #c8c8c8;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row']/width" />px;
    position: relative;
    -webkit-backface-visibility: hidden;
    backface-visibility:hidden;
    -webkit-transform: translateZ(0);
    }

    .timer-row.down{
    background-color: #505050;
    }

    .timer-row.down span{
    color: #ffffff;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/text-shadow-z" />px rgba(0, 0, 0, 0.35);
    }

    .timer-element{
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-element']/height" />px;
    }
    .timer-row.disabled span{
    color: #c8c8c8 !important;
    }

    .timer-row .timer-days{
    position: absolute;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-days']/top" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-days']/left" />px;
    max-width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-days']/max-width" />;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
    }

    .timer-row .timer-time{
    position: absolute;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-time']/top" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-time']/left" />px;
    max-width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-time']/max-width" />;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
    }

    .timer-row .timer-action{
    position: absolute;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-action']/top" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-action']/left" />px;
    max-width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-action']/max-width" />;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
    }

    .timer-row .timer-clock{
    position: absolute;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-clock']/top" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-clock']/left" />px;
    -webkit-box-shadow:0px 1px 0px 0px #ffffff;
    border-radius: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-clock']/border-radius" />px;
  }

  .timer-row .timer-clock.down{
  -webkit-box-shadow:0px -1px 0px 0px rgba(0,0,0, 0.35);
  }

  .timer-row .timer-clock .minutes, .timer-row .timer-clock .hours {
  position: absolute;
  }

  .timer-row .timer-arrow{
  position: absolute;
  top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-arrow']/top" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-row-arrow']/left" />px;
    }

    .timer-toggle {
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-toggle']/height" />px;
    border-bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #c8c8c8;
    border-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #ffffff;
    }

    .timer-toggle .timer-toggle-text{
    position: relative;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-toggle-text']/top" />px;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-text']/left" />px;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-text']/max-width" />px;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
    }

    .timer-toggle.disabled .timer-toggle-text{
    color: #c8c8c8 !important;
    }

    .timer-toggle .timer-toggle-button {
    position: relative;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-toggle-button']/left" />px;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-toggle-button']/top" />px;
    }

    .timer-swiper-container {
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-swiper-container']/width" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-swiper-container']/height" />px;
    }

    #timer-view .container{
    overflow: hidden;
    position: relative;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-view-container']/width" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-view-container']/height" />px;
    }

    #timer-view .timer-view-scrollbar {
    position: absolute;
    bottom: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-view-scrollbar']/bottom" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-view-scrollbar']/height" />px;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-view-scrollbar']/width" />px;
    right: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-view-scrollbar']/right" />px;
    -ms-touch-action: none;
    background-color: #FFFFFF;
    display: block !important;
    }

    #timer-view::-webkit-scrollbar {
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.scrollbar']/width" />px;
    -webkit-appearance: none;
    }

    #timer-view::-webkit-scrollbar-track {

    }

    .white-timer-divider {
      width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-view-container']/width" />px;
      border-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #FFFFFF;
    }

    #timer-view::-webkit-scrollbar-thumb {
    background: #C2C2C2;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.scrollbar.thumb']/height" />px;
    }

    #timer-view::-webkit-scrollbar-thumb:window-inactive {
    background: #C2C2C2;
    }

    .add-timer {
    position: absolute;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-add-timer']/top" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-add-timer']/left" />px;
    /* add timer button is not clickable by default; change it to pointer-events: auto to make it clickable */
    /* pointer-events: none; */
    }

    #timer-list-view{
    position: absolute;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-list-view']/left" />px;
    background-color: #F5F5F5;
    -webkit-transform: translateZ(0);
    }

    #timer-edit-view{
    position: absolute;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-edit-view']/left" />px;
    display: none;
    background-color: #F5F5F5;
    }

    .timer-selection{
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-selection']/width" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-selection']/height" />px;
    }

    .timer-selection-headline{
    position: absolute;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-selection-headline']/top" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-selection-headline']/left" />px;
    }

    .timer-day-selection{
    position: relative;
    margin-right:<xsl:value-of select="/metrics/timer/metric[@key = 'timer-day-selection']/margin-right" />px;
    margin-left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-day-selection']/margin-left" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-day-selection']/height" />px;
    }

    .day-selection-button{
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-day-selection-button']/width" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-day-selection-button']/height" />px;
    -webkit-box-shadow:0px 1px 0px 0px #ffffff;
    -webkit-border-radius:50%;
    font-family: UniversNextMedium;
    font-size: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-day-selection-button']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-day-selection-button']/line-height" />px;
    text-decoration:none;
    text-align:center;
    background-color: rgb(220,220,220);
    color: rgb(60,60,60);
    text-shadow:0px 1px 0px #fff;
    margin-right: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-day-selection-button']/margin-right" />px; 
    margin-left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-day-selection-button']/margin-left" />px;
    float: left;
    }

    .day-selection-button.active{
    -webkit-box-shadow:0px 0px 0px 0px, 0px 1px 0px 0px rgba(0,0,0, 0.35) inset;
    -webkit-border-radius:50%;
    background-color: rgb(190,220,0);
    color: rgb(255,255,255);
    text-shadow:0px -1px 0px rgba(0,0,0,0.35);
    }

    .timer-time-selection{
    position: relative;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection']/height" />px;
    width: 100%;
    }

    .timer-time-selection .sw-frame{
    width: inherit;
    right: inherit;
    }

    .timer-time-selection .sw-slots{
    padding-top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection.sw-slots']/padding" />px;
    right: inherit;
    width: inherit;
    }

    .timer-time-selection .sw-slots ul{
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection.sw-slots.ul']/top" />px;
    }

    .timer-time-selection .sw-slots li{
    padding: 0 <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection.sw-slots.li']/padding" />px !important;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection.sw-slots.li']/height" />px;
    }

    #timer-view .flow-top{
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.flow-top']/height" />px;
      width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.flow-top']/width" />px;
      background: -webkit-linear-gradient(top, #141414 0%,#505050 100%);
      visibility: hidden;
      position: fixed;
      left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-view.flow-top']/left" />;
    }

    .timer-time-selection .slot-machine{
    position: absolute;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-slot-machine']/left" />px;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-slot-machine']/width" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-slot-machine']/height" />px;
    top: 16px;
    }

    .timer-time-selection .gradient-top{
    position: absolute;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-gradient']/left" />px;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-gradient']/top" />px;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-gradient']/width" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-gradient']/height" />px;
    }

    .timer-time-selection .gradient-bottom{
    position: absolute;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-gradient']/left" />px;
    top: initial;
    bottom: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-gradient']/bottom" />px !important;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-gradient']/width" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-selection-gradient']/height" />px;
    }

    .timer-time-vline {
      position: absolute;
      width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-vline']/width" />px;
      height: inherit;
      left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-time-vline']/left" />px;
      background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba(200,200,200,0)),
      color-stop(50%,rgba(200,200,200,1)), color-stop(100%,rgba(200,200,200,0)));
    }

    .timer-action-gridline {
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-gridline']/width" />px;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-gridline']/height" />px;
    margin-right: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-gridline']/margin" />px;
    margin-left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-gridline']/margin" />px;
    }

    .timer-action-row{
    position: relative;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row']/width" />px;
    height:<xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row']/height" />px;
    padding-right: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row']/margin" />px;
    padding-left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row']/margin" />px;
    }

    .timer-action-row.down{
    background-color: #505050;
    }

    .timer-action-row span{
    position: absolute;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row-span']/top" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row-span']/left" />px;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
    max-width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row-span']/width" />px;
    display: inline-block;
    }

    .timer-action-row.down span{
    color: #ffffff;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/text-shadow-z" />px rgba(0, 0, 0, 0.35);
    }

    .timer-headline{
    position: relative;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-headline']/height" />px;
    width: 100%;
    border-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #FFFFFF;
    }

    .timer-headline-sub{
    position: relative;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-headline-sub']/height" />px;
    width: 100%;
    }

    .timer-headline span{
    position: absolute;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-headline-span']/top" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-headline-span']/left" />px;
    }

    .timer-headline-sub span{
    position: absolute;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-headline-span']/top" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-headline-span']/left" />px;
    }

    .timer-action-row .settings-row-radiobutton{
    position: absolute;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer.radiobutton']/top" />px;
    right: <xsl:value-of select="/metrics/timer/metric[@key = 'timer.radiobutton']/right" />px;
    }

    .checkbox-wrapper{
    position: absolute !important;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-checkbox']/left" />px;
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-checkbox']/top - /metrics/layout/metric[@key = 'click-margin']/with-border" />px;
    height:<xsl:value-of select="/metrics/layout/metric[@key = 'layout.checkbox']/height + 2 * /metrics/layout/metric[@key = 'click-margin']/with-border" />px;
    width:<xsl:value-of select="/metrics/layout/metric[@key = 'layout.checkbox']/width + 2 * /metrics/layout/metric[@key = 'click-margin']/with-border" />px;
    -webkit-border-radius:50%;
    }

    .checkbox {
    position: relative;
    margin: <xsl:value-of select="/metrics/layout/metric[@key = 'click-margin']/no-border" />;
    height:<xsl:value-of select="/metrics/layout/metric[@key = 'layout.checkbox']/height" />px;
    width:<xsl:value-of select="/metrics/layout/metric[@key = 'layout.checkbox']/width" />px;
    -webkit-border-radius:50%;
    border: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid rgb(180,180,180);
    -webkit-box-shadow:0px 1px 0px 0px #ffffff, 0px 1px 0px 0px rgb(255,255,255) inset;
    background-color:transparent;
    display:inline-block;
    opacity: 0;
    }

    .checkbox[checked='checked'] {
    border: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid rgb(220,60,60) !important;
    }

    .checkbox div {
    opacity: 0;
    positon: absolute;
    left: -<xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px;
    right: -<xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px;
    }

    .checkbox[checked='checked'] div{
    opacity: 1;
    }

    .timerControlTransition {
      opacity: 0;
      -webkit-transition: opacity 250ms ease-in-out;
      -moz-transition: opacity 250ms ease-in-out;
      -o-transition: opacity 250ms ease-in-out;
      transition: opacity 250ms ease-in-out;
      position: absolute;
    }


    .timerFadeIn {
    opacity: 1 !important;
    -webkit-animation-fill-mode: forwards;
    -webkit-animation: timerOpacityIn 500ms linear;
    }

    .timerFadeIn250 {
    opacity: 1 !important;
    -webkit-animation-fill-mode: forwards;
    -webkit-animation: timerOpacityIn250 250ms linear;
    }

    .timerFadeOut {
    opacity: 0 !important;
    -webkit-animation-fill-mode: both;
    -webkit-animation: timerOpacityOut 500ms linear;
    }

    .timerFadeOut250 {
    opacity: 0;
    -webkit-animation-fill-mode: forwards;
    -webkit-animation: timerOpacityOut 250ms linear;
    }

    @-webkit-keyframes timerOpacityIn {
    0% { opacity: 0; }
    100% { opacity: 1; }
    }

    @-webkit-keyframes timerOpacityIn250 {
    0% { opacity: 0; }
    100% { opacity: 1; }
    }

    @-webkit-keyframes timerOpacityOut {
    0% { opacity: 1; }
    100% { opacity: 0; }
    }

    .timer-box {
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-box']/top" />;
    position: absolute !important;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-box']/height" />px;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-box']/width" />px;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-box']/left" />px;
    max-width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-box']/max-width" />px;
    }

    .timer-box.edit-mode{
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row']/slideposition" />px;
    max-width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-box-edit-mode']/max-width" />px;
    }

    .timer-box.timerSlideIn {
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row']/slideposition" />px;
    -webkit-animation: timerMoveRight 1s;
    max-width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-box-edit-mode']/max-width" />px;
    }

    .timer-box.timerSlideOut {
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-box.timerSlideOut']/left" />px;
    -webkit-animation: timerMoveLeft 1s;
    max-width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-box-edit-mode']/max-width" />px;
    }

    @-webkit-keyframes timerMoveRight
    {
    0%   { left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row']/slideposition-left" />px; }
    100% { left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row']/slideposition" />px; }
    }

    @-webkit-keyframes timerMoveLeft
    {
    0%   { left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row']/slideposition" />px; }
    100% { left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-action-row']/slideposition-left" />px; }
    }

    .timer-double-line.top{
    top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-double-line']/top" />px;
    }

    .timer-double-line.bottom{
    bottom: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-double-line']/bottom" />px;
    }

    .timer-double-line{
    position: absolute;
    left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-double-line']/left" />px;
    border:none;
    border-top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-double-line']/border" />px solid #c8c8c8;
    border-bottom: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-double-line']/border" />px solid #ffffff;
    width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-double-line']/width" />px;
  }

  .timer-colon{
  position: absolute;
  left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-colon']/left" />px;
  top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-colon']/top" />px;
  width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-colon']/width" />px;
  }

  .timer-css-dot{
  position: relative;
  margin-bottom: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-css-dot']/margin-bottom" />px;
  width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-css-dot']/width" />px;
  height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-css-dot']/height" />px;
  background-color: rgb(60,60,60);
  -webkit-box-shadow:0px <xsl:value-of select="/metrics/timer/metric[@key = 'timer-css-dot']/shadow" />px 0px 0px #ffffff;
  display:inline-block;
  }

  .timer-double-line.full{
  width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-double-line.full']/width" />px;
  left: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-double-line.full']/left" />px;
  }

  .timer-double-line.full.bottoms{
 margin-top: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-double-line.full.bottoms']/margin-top" />px;
  
  }

  .blindpuffer{
  height: <xsl:value-of select="/metrics/timer/metric[@key = 'blindpuffer']/height" />px;
  width: <xsl:value-of select="/metrics/timer/metric[@key = 'blindpuffer']/width" />px;
  position: relative;
  top: <xsl:value-of select="/metrics/timer/metric[@key = 'blindpuffer']/top" />px;
    }

  .checkbox.edit-mode {
    opacity: 1;
  }

  </xsl:template>
</xsl:stylesheet>