﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:gira="urn:gira">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:import href="tile_structure.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>

  <xsl:template match="/">
    <!-- set tileId variable -->
    <xsl:variable name="tileId">
      <xsl:call-template name="tileId"/>
    </xsl:variable>
    <xsl:variable name="id">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>
    <div class="tile tile-small">
      <xsl:attribute name="id">
        <xsl:copy-of select="$tileId" />
      </xsl:attribute>
      <!-- generate tile structure-->
      <xsl:call-template name="tileContent">
        <xsl:with-param name="controlElements">
          <div class="buttongroup" data-bind="template: {{name: 'gira-upDown-buttons-template'}}">
            <xsl:attribute name="id">
              <xsl:value-of select="$id" />
            </xsl:attribute>
          </div>
        </xsl:with-param>
        <xsl:with-param name="tileHeader"></xsl:with-param>
      </xsl:call-template>
      <script type="text/javascript">
        (function(){
          var tileId = '<xsl:value-of select="$tileId"/>';

          setTimeout(function () {
            eventsOnTile(tileId);
          }, 100);

          <!-- ######################### set tile click action ######################### -->
          $('#' + tileId).on('tileAction',function(){
            NavbarController.getInstance().openDetailElement(this);
          });

          $('#'+tileId).attr('data-bind', "css: (areAllButtonsUp() ? '' : 'tile-control-down' )");
          <xsl:call-template name="shutterRelativeConfiguration"></xsl:call-template>
          var model = new window.ShutterRelativeModel(config, tsx);
          ko.applyBindings(model, $('#'+tileId)[0]);
        })();
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>