﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:import href="tile_structure.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <!-- set tileId variable -->
    <xsl:variable name="tileId">
      <xsl:call-template name="tileId"/>
    </xsl:variable>
    <!-- generate tile structure-->
    <div class="tile tile-small">
      <xsl:attribute name="id">
        <xsl:copy-of select="$tileId" />
      </xsl:attribute>
      <xsl:attribute name="data-datapoint-Id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SceneNo']/@Id"/>
      </xsl:attribute>
      <xsl:call-template name="tileContent">
        <xsl:with-param name="controlElements">
          <xsl:call-template name="tileTriggerButton">
            <xsl:with-param name="Index" select="Channel/@Index" />
          </xsl:call-template>
        </xsl:with-param>
        <xsl:with-param name="tileHeader"></xsl:with-param>
      </xsl:call-template>
      <script type="text/javascript">
        (function(){
        var tileId = '<xsl:value-of select="$tileId"/>';
        var dataset = document.getElementById(tileId).dataset;
        var ledOn = '{{statusled-2}}';
        var ledOff = '{{statusled-0}}';

        eventsOnTile(tileId);
        registerSceneTriggerTile(tileId, dataset.datapointId, ledOn, ledOff);

        <!-- ######################### set tile click action ######################### -->
        $('#' + tileId).on('tileAction',function(){
        NavbarController.getInstance().openDetailElement(this);
        });
        })();
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>
