﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:gira="urn:gira" exclude-result-prefixes="msxsl">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:output omit-xml-declaration="yes" />
    <xsl:output indent="yes"/>
  <xsl:variable name="pageId">
    <xsl:value-of select="menu/@id" />
  </xsl:variable>
  <xsl:variable name="id-swiper">
    <xsl:value-of select="gira:getGUID()"></xsl:value-of>
  </xsl:variable>
  <xsl:variable name="id-swiper-scrollbar">
    <xsl:value-of select="gira:getGUID()"></xsl:value-of>
  </xsl:variable>
  <xsl:variable name="menuText">
    <xsl:text>settings-row-text sub-menu-text t2sg</xsl:text>
  </xsl:variable>
  <xsl:variable name="containerclass">
    <xsl:choose>
      <xsl:when test="menu/@type">
        <xsl:choose>
          <xsl:when test="menu/@type = 'fullForm'">
            <xsl:text>settings-swiper-container fullForm</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>settings-swiper-container form</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>settings-swiper-container white</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
    
  <!--
    Basic template for TastsensorX menu generation
    this templates operates on a single menu and creates one menu page
    -->
  <xsl:template match="/">

    <div class="menuPage" style="left: 0px; position: absolute;">
      <xsl:attribute name="id">
        <xsl:value-of select="menu/@id" />
      </xsl:attribute>
      <div class="container settings-container">
          <xsl:if test="menu/@type='form' or menu/@dynamic='templatedMenu' or menu/@dynamic='withSubMenu'">
            <xsl:call-template name="menuHeadline">
              <xsl:with-param name="title">
                <xsl:value-of select="menu/@title" />
              </xsl:with-param>
              <xsl:with-param name="subTitle">
                <xsl:value-of select="menu/@subTitle" />
              </xsl:with-param>
              <xsl:with-param name="whiteHeader">false</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="menu/@type='form'">
            <div id="settings-form">
              <!-- menu items -->
              <xsl:call-template name="menuItemOkCancelButton">
                <!-- form event handlers -->
                <xsl:with-param name="cancelBtn">
                  <xsl:value-of select="menu/@cancelBtn"/>
                </xsl:with-param>
                <xsl:with-param name="submit">
                  <xsl:value-of select="menu/@onsubmit"/>
                </xsl:with-param>
                <xsl:with-param name="cancel">
                  <xsl:value-of select="menu/@oncancel"/>
                </xsl:with-param>
              </xsl:call-template>
            </div>
            <div class="white-timer-divider"></div>
          </xsl:if>
        <xsl:apply-templates select="menu/menuStaticItem"/>
        <!--
        <div class="settings-swiper-container">
        -->
        <div>          
          <xsl:choose>
                 <xsl:when test="menu/@classId">
                     <xsl:attribute name="class">
                        <xsl:value-of select="$containerclass" /><xsl:text> </xsl:text> <xsl:value-of select=" menu/@classId" />
                     </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">
                       <xsl:value-of select="$containerclass" />
                    </xsl:attribute>
      
                </xsl:otherwise>
         </xsl:choose>       
		
          <div class="swiper-wrapper">
            <div class="swiper-slide">
                <xsl:if test="not(menu/@type='form' or menu/@dynamic='templatedMenu' or menu/@dynamic='withSubMenu')">
                  <xsl:call-template name="menuHeadline">
                    <xsl:with-param name="title">
                      <xsl:value-of select="menu/@title" />
                    </xsl:with-param>
                    <xsl:with-param name="subTitle">
                      <xsl:value-of select="menu/@subTitle" />
                    </xsl:with-param>
                    <xsl:with-param name="whiteHeader">false</xsl:with-param>
                  </xsl:call-template>
                </xsl:if>
              <!-- Create Menu page headline-->
              <xsl:apply-templates select="menu/*[self::menu or self::menuItem or self::menuHeadline]"/>
            </div>

          </div>
        </div>
        <div>
          <xsl:attribute name="class">settings-swiper-scrollbar</xsl:attribute>
        </div>
      </div>

    <script type="text/javascript">
      $(function(){

      var container = "#<xsl:value-of select="menu/@id" />  .settings-swiper-container";
      var scrollbar = "#<xsl:value-of select="menu/@id" />  .settings-swiper-scrollbar";
      var menuId = '#<xsl:value-of select="menu/@id" />';

      $(scrollbar).css('height', $(container).css('height') );

      createMenuSwiperV(container, scrollbar, menuId, '.settings-row');
      // add caseSets
      var viewId = '#<xsl:value-of select="menu/@id" />';
      $(viewId).data('caseSets', temporaryCaseSets);
      temporaryCaseSets = [];
      var menuId = '#<xsl:value-of select="menu/@id" />';
      window.menuId = menuId;
      var $menu =  $(menuId);

      <xsl:if test="menu/@identify = 'wifi'">
        tsx.WifiSettings.connectedIcon = '{{settings_wifi_icon_connected}}';
        tsx.WifiSettings.disconnectedIcon = '{{settings_wifi_icon_disconnected}}';
        tsx.WifiSettings.securityIcon = '{{gc4_listicon_lock}}';
        tsx.WifiSettings.signalStrength0Icon = '{{settings_wifi_icon_wlan_stat0}}';
        tsx.WifiSettings.signalStrength25Icon = '{{settings_wifi_icon_wlan_stat25}}';
        tsx.WifiSettings.signalStrength50Icon = '{{settings_wifi_icon_wlan_stat50}}';
        tsx.WifiSettings.signalStrength75Icon = '{{settings_wifi_icon_wlan_stat75}}';
        tsx.WifiSettings.signalStrength100Icon = '{{settings_wifi_icon_wlan_stat100}}';
      </xsl:if>
      
      <xsl:if test="menu/@model">
        var viewModel = <xsl:value-of select="menu/@model"/>;
        window.viewModel = viewModel;
        ko.applyBindings(viewModel, $menu[0]);
      </xsl:if>
      <xsl:if test="menu/@onload">
        <xsl:value-of select="menu/@onload"/>;
      </xsl:if>
      <xsl:if test="menu/@onEnter">       
          $menu.data('onEnter', function(){<xsl:value-of select="menu/@onEnter"/>;});       
      </xsl:if>
      <xsl:if test="menu/@onBack">
          $menu.data('onBack', function(){<xsl:value-of select="menu/@onBack"/>;});
      </xsl:if>
      });
    </script>
    </div>

  </xsl:template>


    <!--
    Template to generate a knockout applyBindings call into the current menu page
    the binding is done on the current menu page
    -->
    <xsl:template name="kockoutBinding" match ="menuItem[@type ='kockoutBinding']">
        <xsl:if test="current()/@model">
            <script type="text/javascript">
              ko.applyBindings(<xsl:value-of select="current()/@model"/>, $('#<xsl:value-of select="$pageId"/>')[0]);
            </script>
        </xsl:if>
    </xsl:template>

    <!-- 
    Template for button  
    -->
  <xsl:template name="menuItemButton" match="menuItem[@type = 'button']">
    <div class="settings-row">
      <xsl:variable name="id">
        <xsl:value-of select="gira:getGUID()"></xsl:value-of>
      </xsl:variable>
      <xsl:attribute name="id">
        <xsl:value-of select="$id"></xsl:value-of>
      </xsl:attribute>
      <div class="flow-top"></div>
      <div>
        <xsl:attribute name="class">
          <xsl:value-of select="$menuText"/>
        </xsl:attribute>
        <xsl:value-of select=" current()/@title"/>
      </div>

      <xsl:if test="current()/@action">
        <script type="text/javascript">
          eventsOnSettingsEntry('<xsl:value-of select="$id"/>');
          $('#<xsl:value-of select="$id"/>').on('settingsEntryAction', function(){<xsl:value-of select="current()/@action"/>;});
        </script>
      </xsl:if>
    </div>
  </xsl:template>

  <!-- 
    Template for wlan  
    -->
  <xsl:template name="menuItemWlanConnection" match="menuItem[@type = 'wlanConnection']">
    <xsl:variable name="id">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>
    <div>
      <xsl:attribute name="class"><xsl:value-of select="current()/@mode"/></xsl:attribute>
      <xsl:attribute name="data-bind">foreach: { data: <xsl:value-of select="current()/@mode"/>, afterRender: registerEvents}</xsl:attribute>
      <div class="settings-row">
        <xsl:attribute name="id">
          <xsl:value-of select="$id"></xsl:value-of>
        </xsl:attribute>
        <div class="flow-top"></div>
        <div class="currentConnection t2sg">
          <div data-bind="if: ssid">
            <div class="ssid settings-row-text sub-menu-text" data-bind="text: ssid, css: ssidCss"></div>
          </div>
          <div data-bind="ifnot: ssid">
            <div class="settings-row-text sub-menu-text disabled">{{wifiSettingsNotConfigured}}</div>
          </div>
          <div class="wifiicons">
            <div class="signalStrength sprites" data-bind="css: signalStrength"></div>
            <div class="security sprites" data-bind="css: security"></div>
            <xsl:if test="current()/@mode = 'connectedNetwork'">
              <div class="connected sprites" data-bind="css: connected"></div>
            </xsl:if>
          </div>
        </div>
      </div>
    </div>
  </xsl:template>
  
   <!-- 
    Template for ok cancel button  
    -->
  <xsl:template name="menuItemOkCancelButton" match="menuItem[@type = 'okCancelButton']">
    <xsl:param name="cancelBtn"/>
    <xsl:param name="submit" />
    <xsl:param name="cancel" />
    <div class="settings-row">
      <xsl:variable name="id">
        <xsl:value-of select="gira:getGUID()"></xsl:value-of>
      </xsl:variable>
      <xsl:attribute name="id">
        <xsl:value-of select="$id"></xsl:value-of>
      </xsl:attribute>

      <xsl:if test="$cancelBtn != 'false'">
        <div class="cssButton158 left" id="cancel">{{menuConfigCancel}}</div>
      </xsl:if>
           <div class="cssButton158 right" id="ok"><xsl:if test="menu/@model"><xsl:attribute name="data-bind"><xsl:text>css: {disabled: typeof(isValid) !== 'undefined' ? !isValid() : false}</xsl:text></xsl:attribute></xsl:if>{{menuConfigOk}}</div>
      <script type="text/javascript">
        (function(){
        var okBtn = $('#<xsl:value-of select="$id"/> <xsl:text disable-output-escaping="yes">  &gt; </xsl:text> #ok');
        var cancelBtn = $('#<xsl:value-of select="$id"/> <xsl:text disable-output-escaping="yes">  &gt; </xsl:text> #cancel');
        var navigation = NavbarController.getInstance();
        registerEventsForPressButton( okBtn,
        function(){ if (okBtn.hasClass('disabled')) return; okBtn.addClass('down')},
        function(){ okBtn.removeClass('down')},
        function(){
        if (okBtn.hasClass('disabled')) return;
          try{
            <xsl:copy-of select="$submit"/>
            <xsl:if test="menu/@model">
              var ret = viewModel.ok();
              if (ret === false) {
                return;
              }
            </xsl:if>
        }catch(e){console.log(e)}
        <xsl:choose>
          <xsl:when test="menu/@ignoreok"> 
          <!-- ignore attribute-->
          </xsl:when>
          <xsl:otherwise>
            navigation.back();
          </xsl:otherwise>
        </xsl:choose>
        });
        <xsl:if test="$cancelBtn != 'false'">
        registerEventsForPressButton( cancelBtn,
        function(){ cancelBtn.addClass('down')},
        function(){ cancelBtn.removeClass('down')},
        function(){
        try{
            <xsl:copy-of select="$cancel"/>
            <xsl:if test="menu/@model">
              var ret = viewModel.cancel();
              if (ret === false) {
                return;
              }
            </xsl:if>
         }catch(e){console.log(e)}
         navigation.back();
        });
        </xsl:if>
        })();
      </script>
    </div>
  </xsl:template>


<!--
    Template for RadioButtons
-->
  <xsl:template name="menuItemRadiobutton" match="menuItem[@type = 'radiobutton']">
    <xsl:variable name="id">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>

    <div class="settings-row">
      <xsl:attribute name="id">
        <xsl:value-of select="$id"></xsl:value-of>
      </xsl:attribute>
      <div class="flow-top"></div>
      <div>
        <xsl:attribute name="class">
          <xsl:value-of select="$menuText"/>
        </xsl:attribute>
        <xsl:value-of select=" current()"/>
      </div>
      <xsl:call-template name="radioButtonElement">
        <xsl:with-param name="name">
          <xsl:value-of select="current()/@name"/>
        </xsl:with-param>
        <xsl:with-param name="id">
          <xsl:value-of select="current()/@value"/>
        </xsl:with-param>
      </xsl:call-template>

      <script type="text/javascript">
        eventsOnSettingsEntry('<xsl:value-of select="$id"/>');
        $('#<xsl:value-of select="$id"/>').on('settingsEntryAction',function(){
        $("input", this).prop("checked", true);
        });
      </script>

    </div>
  </xsl:template>

  <!--
    Template for ToggleButtons
    -->
  <xsl:template name="menuItemToggleButton" match="menuItem[@type = 'toggleButton']">
    <xsl:variable name="switchid">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>
    <div class="settings-row">
      <xsl:variable name="id">
        <xsl:value-of select="gira:getGUID()"></xsl:value-of>
      </xsl:variable>
      <xsl:attribute name="id">
        <xsl:value-of select="$id"></xsl:value-of>
      </xsl:attribute>
      <div class="flow-top"></div>
      <div>
        <xsl:attribute name="class">
          <xsl:value-of select="$menuText"/>
         <xsl:text> long</xsl:text>
        </xsl:attribute>
        <xsl:value-of select="current()/@title"/>
      </div>
      
      <!-- start -->
      <div class="settings-togglebutton">
         <xsl:call-template name="toggleSwitchButton">
              <xsl:with-param name="Id">
                <xsl:text>onoffswitch-</xsl:text><xsl:value-of select="$switchid"/>
              </xsl:with-param>
              <xsl:with-param name="ColorIdLeft" select="current()/@ledcolor-left"/>
              <xsl:with-param name="ColorIdRight" select="current()/@ledcolor-right" />
              <xsl:with-param name="ColorPicker" select="false" />
            </xsl:call-template>
      </div>
      <!-- end -->

      <!-- js for DP toggle button -->
      <xsl:if test="current()/tagId">
        <script type="text/javascript">
          (function(){
          var switchDatapoint = parseInt('<xsl:value-of select="current()/tagId"/>');
          var statusDatapoint = parseInt('<xsl:value-of select="current()/tagId"/>');
          var rowId = '<xsl:value-of select="$id"/>';
          var onoffswitchId = '<xsl:text>onoffswitch-</xsl:text><xsl:value-of select="$switchid"/>';
          
          registerToggleSwitchButton(statusDatapoint, onoffswitchId, rowId, switchDatapoint);
          })();
        </script>
      </xsl:if>
      
      <!-- js for toggle button handled by settingsController.js -->
      <xsl:if test="current()/@settingId">
        <script type="text/javascript">
          registerSettingsInput('<xsl:value-of select="current()/@settingId"/>','<xsl:text>onoffswitch-</xsl:text><xsl:value-of select="$switchid"/>');
          registerSliderButtonRow('<xsl:value-of select="$id"/>'); 
        </script>
      </xsl:if>
    </div>
  </xsl:template>


  <!--
    Template for value items
    value items have a lable and a dynamic value ( js getter function)
    both strings are concated and displayed
    -->
  <xsl:template name="menuItemValue" match="menuItem[@type = 'value']">

    <xsl:variable name="id">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>

    <div class="settings-row">

      <div>
        <xsl:attribute name="class">
          <xsl:value-of select="$menuText"/>
          <xsl:text> disabled</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="id">
          <xsl:value-of select="$id"></xsl:value-of>
        </xsl:attribute>

        <xsl:value-of select=" current()/@lable"/>
      </div>

      <xsl:if test="current()/action/@type['getValue']">
        <script type="text/javascript">
          $('#<xsl:value-of select="$id"/>').append(<xsl:value-of select="current()/action"/> );
        </script>
      </xsl:if>

    </div>
  </xsl:template>

  <!--
    Template for value items
    value items have a lable and a dynamic value ( js getter function)
    both strings are concated and displayed
    -->
  <xsl:template name="menuItemRadiobuttonWithIcon" match="menuItem[@type = 'radiobuttonWithIcon']">
    <xsl:variable name="id">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>

    <div class="settings-row">
      <xsl:attribute name="id">
        <xsl:value-of select="$id"></xsl:value-of>
      </xsl:attribute>
      <div class="flow-top"></div>
      <div class="settings-row-icon">
        <div class="sprites">
          <xsl:attribute name="class">
            <xsl:text>center-vertical sprites </xsl:text>
              <xsl:value-of select="current()/@icon"/>
          </xsl:attribute>
        </div>
      </div>
      <div>
        <xsl:attribute name="class">
          <xsl:value-of select="$menuText"/>
          <xsl:text> radiobutton-with-icon</xsl:text>
        </xsl:attribute>
        <xsl:value-of select=" current()"/>
      </div>
      <xsl:call-template name="radioButtonElement">
        <xsl:with-param name="name">selectPf</xsl:with-param>
        <xsl:with-param name="id">
          <xsl:text>primary_function_</xsl:text>
          <xsl:value-of select="current()/@channelId"/>
        </xsl:with-param>
      </xsl:call-template>
     
      <script type="text/javascript">
        eventsOnSettingsEntry('<xsl:value-of select="$id"/>');
        $('#<xsl:value-of select="$id"/>').on('settingsEntryAction',function(){
            $("input", this).prop("checked", true);
        });
      </script>

    </div>
  </xsl:template>

  <!--
    Generates a list of channels which can be marked as favorites.
    -->
  <xsl:template name="menuItemFavoriteList" match="menuItem[@type = 'favoriteList']">
    <xsl:variable name="id">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>

    <div class="favorite-selection" data-bind="template: {{ name: 'favoriteChannelSelection', foreach: channels, as: 'channel',  afterRender: registerEvents }}"></div>

    <script type="text/html" id="favoriteChannelSelection">
      <div class="settings-row" data-bind="attr: {{'id': 'channel-' + channel.index}}">
        
        <div class="flow-top"></div>
        <div class="settings-row-icon">
            <div class="center-vertical sprites" data-bind="css: icon"></div>
        </div>
        <div data-bind="text: unescape(name)">
          <xsl:attribute name="class">
            <xsl:value-of select="$menuText"/>
            <xsl:text> radiobutton-with-icon</xsl:text>
          </xsl:attribute>
        </div>
        <xsl:call-template name="checkBoxElement">
        </xsl:call-template>
      </div>
    </script>
  </xsl:template>

  <!--
    Generates a list of channels wehich can be marked as favorites.
    -->
  <xsl:template name="menuItemChannelSortList" match="menuItem[@type = 'chanelSortList']">

    <div class="channel-sort" data-bind="template: {{ name: 'channelSort', foreach: channels, as: 'channel',  afterRender: registerEvents, templateOptions: {{ parentList: channels}} }}, sortableList: channels"></div>

    <xsl:call-template name="channelSortTemplate"/>
  </xsl:template>

  <xsl:template name="channelSortTemplate">
    <script type="text/html" id="channelSort">
      <div class="settings-row" data-bind="css: channel.containerId ? '':'ignorerowevent', attr: {{'id': 'channel-' + channel.index}}, sortableItem: {{ item: $data, parentList: $item.parentList}} ">
        <div class="flow-top"></div>
        <div class="settings-row-sortindicator ignorerowevent noSwipingV">
          <div class="ignorerowevent noSwipingV sprites {{{{sort_icon}}}}"></div>
        </div>
          <div class="settings-row-sortable-icon">
              <div class="center-vertical sprites" data-bind="css: icon"></div>
          </div>
        <div data-bind="text: name">
          <xsl:attribute name="class">
            <xsl:value-of select="$menuText"/>
            <xsl:text> radiobutton-with-icon short</xsl:text>
          </xsl:attribute>
        </div>
        <div class="settings-arrow sprites {{{{tile-arrow-right}}}}" data-bind="visible: channel.containerId"></div>
      </div>
    </script>
  </xsl:template>

  <!--
    Generates a list of wps networks.
    -->
  <xsl:template name="menuItemWpsServiceSelection" match="menuItem[@type = 'wpsServiceSelection']">
    <xsl:variable name="id">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>

    <div class="wps-network-selection" data-bind="template: {{ name: 'wpsServiceSelection', foreach: wpsNetworks, as: 'wpsNetwork', afterRender: registerEvents}}"></div>

    <script type="text/html" id="wpsServiceSelection">
      <div class="settings-row" data-bind="attr: {{'id': identifier}}">

        <div class="flow-top"></div>
        <div data-bind="text: unescape(name)">
          <xsl:attribute name="class">
            <xsl:value-of select="$menuText"/>
          </xsl:attribute>
        </div>
        <xsl:call-template name="radioButtonElement">
        </xsl:call-template>
      </div>
    </script>
  </xsl:template>


  <!--
    Template for value items
    value items have a label and a dragsort indicator
    -->
  <xsl:template name="menuItemRadiobuttonWithSortIcon" match="menuItem[@type = 'sortableradiobutton']">
    <xsl:variable name="id">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>

    <div class="settings-row">
      <xsl:attribute name="id">
        <xsl:value-of select="$id"></xsl:value-of>
      </xsl:attribute>      
      <div class="flow-top"></div>
      <div class="settings-row-sortindicator ignorerowevent noSwipingV sprites {{{{sort_icon}}}}"></div>
      <div>
        <xsl:attribute name="class">
          <xsl:value-of select="$menuText"/>
        </xsl:attribute>
        <xsl:value-of select=" current()"/>
      </div>
      <xsl:call-template name="radioButtonElement">
        <xsl:with-param name="name">
          <xsl:value-of select="current()/@name"/>
        </xsl:with-param>
        <xsl:with-param name="id">
          <xsl:value-of select="current()/@value"/>
        </xsl:with-param>
      </xsl:call-template>

      <script type="text/javascript">
        eventsOnSettingsEntry('<xsl:value-of select="$id"/>');
        $('#<xsl:value-of select="$id"/>').on('settingsEntryAction',function(){
        $("input", this).prop("checked", true);
        });
      </script>

    </div>
  </xsl:template>

  <!-- 
    Template for menu items that link to sub menus
    -->
  <xsl:template name="menu" match="menu[not(@dynamic)]">
    <div>
      <xsl:attribute name="class">
        <xsl:text>settings-row</xsl:text>
        <xsl:if test="current()/@hidden = 'true'">
          <xsl:text> hidden-row</xsl:text>
        </xsl:if>
      </xsl:attribute>
      <xsl:attribute name="subMenuId">
        <xsl:choose>
          <xsl:when test="current()/@showSubMenuId">
            <xsl:value-of select="current()/@id"/>
          </xsl:when>
        </xsl:choose>
      </xsl:attribute>
      <xsl:variable name="id">
        <xsl:value-of select="gira:getGUID()"></xsl:value-of>
      </xsl:variable>

      <xsl:attribute name="id">
        <xsl:value-of select="$id"></xsl:value-of>
      </xsl:attribute>
      <xsl:attribute name="menuId">
        <xsl:value-of select="current()/@menuId"></xsl:value-of>
      </xsl:attribute>
  
       <div class="flow-top"></div>
      <div>
        <xsl:attribute name="class">
          <xsl:value-of select="$menuText"/>
        </xsl:attribute>
        <xsl:value-of select="current()/@title"/>
      </div>
      <div class="settings-arrow sprites {{{{tile-arrow-right}}}}"></div>
      <script type="text/javascript">
        eventsOnSettingsEntry('<xsl:value-of select="$id"/>');
        $('#<xsl:value-of select="$id"/>').on('settingsEntryAction',function(){
        openSettingsElement('<xsl:value-of select="$pageId"/>','<xsl:value-of select="current()/@id" />');
        });
        <xsl:if test="current()/@identify = 'wifi'">
          if(!globals.wifi.available)
          $('#<xsl:value-of select="$id"/>').remove();
        </xsl:if>
      </script>
    </div>
  </xsl:template>

  <!-- 
    Template for menu items that link to sub menus
    -->
  <xsl:template name="dynamicMenuFavoriteList" match="menu[@dynamic = 'favoriteList']">
    
    <div class="favorite-selection-rooms" data-bind="template: {{ name: 'favoriteSelectionRooms', foreach: containers, as: 'container',  afterRender: registerContainerEvents }}">
      <xsl:attribute name="menu">
        <xsl:value-of select="$pageId"/>
      </xsl:attribute>
      <xsl:attribute name="submenu">
        <xsl:value-of select="current()/@id" />
      </xsl:attribute>
    </div>

    <script type="text/html" id="favoriteSelectionRooms">
      <div class="settings-row" data-bind="attr: {{'id': 'container-' + container.index}}">
        <div class="flow-top"></div>
          <div class="settings-row-icon">
              <div class="center-vertical sprites" data-bind="css: icon"></div>
          </div>
        <div data-bind="text: unescape(name)">
          <xsl:attribute name="class">
            <xsl:value-of select="$menuText"/>
            <xsl:text> radiobutton-with-icon long</xsl:text>
          </xsl:attribute>
        </div>
        <div class="settings-arrow sprites {{{{tile-arrow-right}}}}"></div>
      </div>
    </script>
  </xsl:template>
  
  <!-- 
    Template for menu items that link to sub menus
    -->
  <xsl:template name="dynamicMenuWithContent" match="menu[@dynamic = 'content']">
    <div class="settings-row big">

      <xsl:variable name="id">
        <xsl:value-of select="gira:getGUID()"></xsl:value-of>
      </xsl:variable>
      
      <xsl:attribute name="settingId">
        <xsl:value-of select="current()/@settingId"></xsl:value-of>
      </xsl:attribute>

      <div class="settings-row-inputField-lable t3lsg">
        <xsl:value-of select="current()/@lable"/>
      </div>
      <div class="settings-row-select">
        <xsl:attribute name="id">
          <xsl:value-of select="$id"></xsl:value-of>
        </xsl:attribute>
      <div class="flow-top"></div>
      <div>
        <xsl:attribute name="class">
          <xsl:value-of select="$menuText"/>
        </xsl:attribute>
        <xsl:value-of select=" current()/@content"/>
      </div>
      <div class="settings-arrow sprites {{{{tile-arrow-right}}}}"></div>
      </div>
      <script type="text/javascript">
        eventsOnSettingsEntry('<xsl:value-of select="$id"/>');
        $('#<xsl:value-of select="$id"/>').on('settingsEntryAction',function(){
        openSettingsElement('<xsl:value-of select="$pageId"/>','<xsl:value-of select="current()/@id" />');
        });
      </script>
    </div>
  </xsl:template>
  
  <!-- 
    Template for menu items that link to sub menus
    -->
  <xsl:template name="dynamicMenuSortList" match="menu[@dynamic = 'sortList']">

    <div class="channel-sort" data-bind="template: {{ name: 'channelSort', foreach: topView, as: 'channel',  afterRender: registerEvents, templateOptions: {{ parentList: channels}} }}, sortableList: channels">
      <xsl:attribute name="menu">
        <xsl:value-of select="$pageId"/>
      </xsl:attribute>
      <xsl:attribute name="submenu">
        <xsl:value-of select="current()/@id" />
      </xsl:attribute>
    </div>
    
    <xsl:call-template name="channelSortTemplate"/>
  </xsl:template>

  <!--
    Create a headline inside a menu page
    param title: the headline's text
    param whiteHeader: optional, set to 'true' if you want a white area before the headline
    -->
  <xsl:template name="menuHeadline" match="menuHeadline">
    <xsl:param name="title" />
    <xsl:param name="subTitle" />
    <xsl:param name="whiteHeader" select="'true'" />
    <xsl:param name="identifier" select="menu/@identify" />
    <xsl:if test="$whiteHeader='true'">
        <div class="settings-row-white"></div>
    </xsl:if>

    <xsl:choose>

      <xsl:when test="not($identifier='dateTimeFormat')">
        <div class="settings-description-row">
          <div class="settings-description-row-text">
            <div class="settings-title t3sg">
              <xsl:value-of select="@title"/>
              <xsl:value-of select="$title"/>
            </div>
            <div class="spacer">
            </div>
            <div class="settings-subtitle t3lsg">
              <xsl:value-of select="@subTitle"/>
              <xsl:value-of select="$subTitle"/>
            </div>
          </div>
        </div>
      </xsl:when>

      <xsl:otherwise>

        <div class="settings-description-row">
          <div class="settings-description-row-text">
            <div class="settings-title t3sg">
              {{menuConfigDateSettingTitle}}
            </div>
            <div class="spacer">
            </div>
          </div>
        </div>

      </xsl:otherwise>

    </xsl:choose>

  </xsl:template>

  <!--
    Dummy Template for Input Field
    -->
  <xsl:template name="menuItemInput" match="menuItem[@type = 'input']">
    <div class="settings-row">
      <div class="flow-top"></div>
      <div>
        <xsl:attribute name="class">
          <xsl:value-of select="$menuText"/>
        </xsl:attribute>
          <input id="inputId" class="input" name="username" type="text" placeholder="Username..." onselect="this.value=this.value;">
              <xsl:call-template name="addDataBindAttribute"></xsl:call-template>
          </input>
      </div>
    </div>
  </xsl:template>
  <!--
		Template for Input With Label Field Noser
	-->
  <xsl:template name="inputWithLabelN" match="menuItem[@type = 'inputWithLabelN']">
    <xsl:variable name="id">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>
      <div class="settings-row inputField">
        <xsl:attribute name="id">
          <xsl:value-of select="$id"></xsl:value-of>
        </xsl:attribute>
        <xsl:attribute name="settingId">
          <xsl:value-of select="current()/@settingId"/>
        </xsl:attribute>
        <div class="settings-row-inputField-lable t3lsg">
          <xsl:value-of select="current()/@lable"/>
        </div>

        <div>
          <input id="inputWithLabelN" class="input font inputform" xsl:use-attribute-sets="inputWithLabelAttributesN" onselect="this.value=this.value;">
            <xsl:attribute name="oninput">
              showDeleteInputX('#<xsl:value-of select="$id"/>', '#inputWithLabelN');
            </xsl:attribute>
            <xsl:attribute name="onfocusout">
              showDeleteInputX('#<xsl:value-of select="$id"/>', '#inputWithLabelN', false);
            </xsl:attribute>
            <xsl:call-template name="addDataBindAttribute"></xsl:call-template>
          </input>
          <div class="settings-x-icon sprites {{{{x_icon}}}}"></div>
        </div>
        <script type="text/javascript">
          $('#<xsl:value-of select="$id"/> .settings-x-icon').on('mousedown',function(){
          $('#<xsl:value-of select="$id"/> .settings-x-icon').css('display', 'none');
          event.stopPropagation();
          event.preventDefault();
          $('#<xsl:value-of select="$id"/> .input').val("");
          });
        </script>
      </div>
  </xsl:template>
  
  <!--
		Template for Password Input With Label and Checkbox Field Noser
	-->
  <xsl:template name="inputWithLabelCheckboxN" match="menuItem[@type = 'inputWithLabelCheckboxN']">
    <xsl:variable name="id">
      <xsl:value-of select="gira:getGUID()"></xsl:value-of>
    </xsl:variable>
      <div class="settings-row inputField bigger">
        <xsl:attribute name="id">
          <xsl:value-of select="$id"></xsl:value-of>
        </xsl:attribute>
        <div class="settings-row-inputField-lable t3lsg">
          <xsl:value-of select="current()/@lable"/>
        </div>

        <div>
          <input id="inputWithLabelCheckboxN" class="input font inputform" xsl:use-attribute-sets="inputWithLabelAttributesN" onselect="this.value=this.value;">
            <xsl:attribute name="oninput">
              showDeleteInputX('#<xsl:value-of select="$id"/>', '#inputWithLabelCheckboxN');
            </xsl:attribute>
            <xsl:attribute name="onfocusout">
              showDeleteInputX('#<xsl:value-of select="$id"/>', '#inputWithLabelCheckboxN', false);
            </xsl:attribute>
            <xsl:call-template name="addDataBindAttribute"></xsl:call-template>
          </input>
          <div class="settings-x-icon sprites {{{{x_icon}}}}"></div>
          <script type="text/javascript">
            $('#<xsl:value-of select="$id"/> .settings-x-icon').on('mousedown',function(){
            $('#<xsl:value-of select="$id"/> .settings-x-icon').css('display', 'none');
            event.stopPropagation();
            event.preventDefault();
            $('#<xsl:value-of select="$id"/> .input').val("");
            });
          </script>
          <xsl:call-template name="checkBoxElementWithLabel">
              <xsl:with-param name="parentId">
                <xsl:value-of select="$id"></xsl:value-of>
              </xsl:with-param>
              <xsl:with-param name="textfieldId">inputWithLabelCheckboxN</xsl:with-param>
              <xsl:with-param name="label">
                {{menuConfigShowPasswort}}
              </xsl:with-param>
            </xsl:call-template>
        </div>
      </div>
  </xsl:template>

  <xsl:attribute-set name="inputWithLabelAttributesN">

    <xsl:attribute name="placeholder">
      <xsl:value-of select="current()/@placeholder"/>
    </xsl:attribute>

    <xsl:attribute name="type">
      <xsl:choose>
        <xsl:when test="current()/@isPassword='true'">password</xsl:when>
        <xsl:otherwise>text</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>

  </xsl:attribute-set>
  
	<xsl:template  name="menuItem" match="menuItem[@type = 'templated']">
		<xsl:variable name="id">
			<xsl:value-of select="gira:getGUID()"></xsl:value-of>
		</xsl:variable>
		<div>
			<xsl:attribute name="id"><xsl:value-of select="$id"></xsl:value-of></xsl:attribute>
			<xsl:attribute name="data-bind">template: { name: '<xsl:value-of select="current()/@koTemplateId"/>', data: <xsl:value-of select="current()/@koTemplateData"/> }</xsl:attribute>
			 <xsl:if test="current()/@koModel">
				<script type="text/javascript">
          ko.applyBindings(<xsl:value-of select="current()/@koModel"/>, $('#<xsl:value-of select="$id"/>')[0]);
        </script>
		</xsl:if>
		</div>
	</xsl:template>
	
	<xsl:attribute-set name="errorValidationAttributes">
		<xsl:attribute name="data-bind">{visible: !<xsl:value-of select="current()/@isvalid"/>()}</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="errorValidationAttributesSpan">
		<xsl:attribute name="data-bind">{text: <xsl:value-of select="current()/@validationhint"/>}</xsl:attribute>
	</xsl:attribute-set>
  
  <!--
    Radio button element with custom layout
    -->
  <xsl:template name="radioButtonElement">
    <xsl:param name="name"/>
    <xsl:param name="id"/>
    <div class="settings-row-radiobutton">
      <input class="radio-input" type="radio">
        <xsl:attribute name="name">
          <xsl:value-of select="$name"/>
        </xsl:attribute>
        <xsl:attribute name="id">
          <xsl:value-of select="$id"/>
        </xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="$id"/>
        </xsl:attribute>

        <xsl:call-template name="addDataBindAttribute"></xsl:call-template>

      </input>
      <label class="custom-radio-label">
        <xsl:attribute name="for">
          <xsl:value-of select="$id"/>
        </xsl:attribute>
        <div class="custom-radio"></div>
      </label>
    </div>
  </xsl:template>

  <!--
    Checkbox element with custom layout
    -->
  <xsl:template name="checkBoxElement">
    <xsl:param name="name"/>
    <xsl:param name="id"/>
    <div class="settings-row-checkbox">
      <input class="checkbox-input" type="checkbox">
        <xsl:attribute name="name">
          <xsl:value-of select="$name"/>
        </xsl:attribute>
        <xsl:attribute name="id">
          <xsl:value-of select="$id"/>
        </xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="$id"/>
        </xsl:attribute>

        <xsl:call-template name="addDataBindAttribute"></xsl:call-template>

      </input>
      <label class="custom-checkbox-label">
        <xsl:attribute name="for">
          <xsl:value-of select="$id"/>
        </xsl:attribute>
        <xsl:call-template name="addDataBindAttribute"></xsl:call-template>
        <div class="custom-checkbox">
          <div class="noDownEffect sprites {{{{gc4_cssicon_selected}}}}"></div>
        </div>
      </label>
    </div>
  </xsl:template>


<!--
    Input element for IP and subnetMask input
-->
<xsl:template name="menuItemIPInput" match="menuItem[@type = 'inputIP']">
  <div class="settings-row inputField">
      <xsl:variable name="id">
          <xsl:value-of select="gira:getGUID()"></xsl:value-of>
      </xsl:variable>
      
      <xsl:attribute name="id">
          <xsl:value-of select="$id"/>
      </xsl:attribute>
      
      <div class="settings-row-inputField-lable t3lsg">
        <xsl:value-of select="current()/@lable"/>
      </div>
        <input class="input inputform font" type="text" placeholder="..." onselect="this.value=this.value;"
          required="required" pattern="\b((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\.){{3}}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\b">
          <xsl:attribute name="settingId">
            <xsl:value-of select="current()/@settingId"/>
          </xsl:attribute>
          <xsl:attribute name="oninput">
            showDeleteInputX('#<xsl:value-of select="$id"/>', '.inputform');
          </xsl:attribute>
          <xsl:attribute name="onfocusout">
            showDeleteInputX('#<xsl:value-of select="$id"/>', '.inputform', false);
          </xsl:attribute>
          <div class="settings-x-icon sprites {{{{x_icon}}}}">
            <xsl:attribute name="rowid">
              <xsl:value-of select="$id"/>
            </xsl:attribute>
          </div>
        </input>
        <xsl:call-template name="addDataBindAttribute"></xsl:call-template>
        <script type="text/javascript">
          $('#<xsl:value-of select="$id"/> .settings-x-icon').on('mousedown',function(){
            $('#<xsl:value-of select="$id"/> .settings-x-icon').css('display', 'none');
            event.stopPropagation();
            event.preventDefault();
            $('#<xsl:value-of select="$id"/> .input').val("");
          });
        </script>
  </div>
</xsl:template>

  <!--
     Input element for viewing MAC address
 -->
  <xsl:template name="menuItemMACView" match="menuItem[@type = 'viewMAC']">
    <div class="settings-row inputField">
      <xsl:variable name="id">
        <xsl:value-of select="gira:getGUID()"></xsl:value-of>
      </xsl:variable>

      <xsl:attribute name="id">
        <xsl:value-of select="$id"/>
      </xsl:attribute>

      <div class="settings-row-inputField-lable t3lsg inactive">
        <xsl:value-of select="current()/@lable"/>
      </div>
      <div class="disabled-input settings-row-text sub-menu-text t2sg disabled" type="text" disabled="disabled">
        <xsl:attribute name="rowid">
          <xsl:value-of select="current()/@settingId"/>
        </xsl:attribute>
      </div>
      <xsl:call-template name="addDataBindAttribute"></xsl:call-template>
      <script type="text/javascript">
        $('#<xsl:value-of select="$id"/> .settings-x-icon').on('mousedown',function(){
        $('#<xsl:value-of select="$id"/> .settings-x-icon').css('display', 'none');
        event.stopPropagation();
        event.preventDefault();
        });
      </script>
    </div>
  </xsl:template>

  <!-- 
    Template for Detail Rtc Calibration
    -->
  <xsl:template name="menuItemDetailRtc" match="menuItem[@type = 'detailRtcCalibration']">
    <xsl:variable name="detailId">settingsMenuRtcCalibration</xsl:variable>
    <xsl:variable name="spinnWheelId">spinnWheel-rtc-calibration</xsl:variable>
    <div class="detail">
      <xsl:attribute name="id">
        <xsl:copy-of select="$detailId"/>
      </xsl:attribute>
      <div class="white-timer-divider"></div>
      <div class="textBox t3lsg">Bitte geben Sie nachfolgend den gemessenen Raumtemperaturwert ein.</div>
      <div class="textBox2 t3lsg">Es wurde kein Raumtemperaturfühler gefunden.</div>
        <xsl:call-template name="slotmachine">
          <xsl:with-param name="spinnWheelId" select="$spinnWheelId"/>
          <xsl:with-param name="isShowStatusValue">false</xsl:with-param>
          <xsl:with-param name="isShowUnitEnabled">true</xsl:with-param>
          <xsl:with-param name="showUnits" select="Channel/ShowUnits"/>
          <xsl:with-param name="statusValueId"><xsl:value-of select="$detailId"/>_statusValue</xsl:with-param>
          <xsl:with-param name="readFromDataPoint" select="current()/temperature/DataPoint[@Name='InternalTemperature' or @Name='ExternalTemperature']/@Id"/>
          <xsl:with-param name="precision">1</xsl:with-param>
        
        </xsl:call-template>
        <div class="valuator">
          <div class="gradient-top CSS8a"></div>
          <div class="line upper"></div>
          <div class="line lower"></div>
          <div class="gradient-bottom CSS8b"></div>
          <div class="t2gg unitLabel">°C
          </div>
        </div>
      <script type="text/javascript">
        var temperatureTag = '<xsl:value-of select="current()/temperature/DataPoint[@Name='InternalTemperature' or @Name='ExternalTemperature']/@Id"/>';
        var spinnWheelId = '<xsl:value-of select="$spinnWheelId"/>';
        initRtcCalibration(temperatureTag, spinnWheelId);
      </script>
    </div>
  </xsl:template>
    
    
   <!--
   Template for multi line description text 
    -->
    <xsl:template name="descriptionText" match="menuItem[@type = 'descriptiontext']">
      <div class = "settings-description-text-item t3lsg">
          <xsl:value-of select="current()"></xsl:value-of>
      </div>  
  </xsl:template>

  <!--
    Checkbox element for the password field
   -->
  <xsl:template name="checkBoxElementWithLabel">
    <xsl:param name="parentId"/>
    <xsl:param name="textfieldId"/>
    <xsl:param name="label"/>
    <xsl:variable name="id"><xsl:value-of select="$parentId"/>-checkbox</xsl:variable>
    <div class="checkbox-with-label">
      <xsl:attribute name="onclick">togglePasswordCheckbox('#<xsl:value-of select="$parentId"/>', '#<xsl:value-of select="$textfieldId"/>', '#<xsl:value-of select="$id"/>')</xsl:attribute>
      <input class="checkbox-input" type="checkbox">
        <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
      </input>
      <label class="custom-checkbox-label">
        <xsl:attribute name="for"><xsl:value-of select="$parentId"/></xsl:attribute>
        <div class="custom-checkbox">
          <div class="noDownEffect sprites {{{{gc4_cssicon_selected}}}}"></div>
        </div>
      </label>
      
    </div>
    <div class="checkbox-label t3lsg">
      <xsl:value-of select="$label"/>
    </div>
  </xsl:template>
  
  <xsl:template name="dynamicMenu" match="menu[@dynamic = 'withSubMenu']">
	<xsl:variable name="id">
		<xsl:value-of select="gira:getGUID()"></xsl:value-of>
	</xsl:variable>
    <div>
		<xsl:attribute name="id"><xsl:value-of select="$id"></xsl:value-of></xsl:attribute>
        <xsl:attribute name="menu">
            <xsl:value-of select="$pageId"/>
        </xsl:attribute>
        <xsl:attribute name="submenu">
            <xsl:value-of select="current()/@id" />
        </xsl:attribute>
		<xsl:call-template name="menuItem"></xsl:call-template>
    </div>
</xsl:template>


  <!-- 
    Template for button  
    -->
  <xsl:template name="menuItemButtonWithIcon" match="menuItem[@type = 'buttonWithIcon']">
    <div class="settings-row">
      <xsl:variable name="id">
        <xsl:value-of select="gira:getGUID()"></xsl:value-of>
      </xsl:variable>
      <xsl:attribute name="id">
        <xsl:value-of select="$id"></xsl:value-of>
      </xsl:attribute>
      <div class="flow-top"></div>
      <div>
        <xsl:attribute name="class">
          <xsl:value-of select="$menuText"/>
        </xsl:attribute>
        <xsl:value-of select=" current()/@title"/>
      </div>
      <div class="settings-refresh-icon sprites {{{{listicon_refresh}}}}"></div>
      <xsl:if test="current()/@action">
        <script type="text/javascript">
          eventsOnSettingsEntry('<xsl:value-of select="$id"/>');
          $('#<xsl:value-of select="$id"/>').on('settingsEntryAction', function(){<xsl:value-of select="current()/@action"/>;});
        </script>
      </xsl:if>
    </div>
  </xsl:template>

  <!-- 
    Template for loaded text
    -->
  <xsl:template name="loadedText" match="menuItem[@type = 'text']">
    <div class="loadedText">
      <xsl:if test="current()/@action">
        <script type="text/javascript">
         <xsl:value-of select="current()/@action"/>
        </script>
      </xsl:if>
      </div>
    <div class="blindpuffer"></div>
  </xsl:template>
</xsl:stylesheet>