<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="html"/>
    <xsl:template match="/">
        <div id="settings-overlay" class="slideOutFromBottom-animation">
           <div id="settings-view">
             <div id="mainMenu">
                 <div class="menuPage" style="left: 0px; position: absolute;" id="menuPage_pin">
                     <xsl:comment>ko template: {name: 'pin-protection'}</xsl:comment>
                     <xsl:comment>/ko</xsl:comment>
                 </div>
             </div>
            </div>
        <script type="text/javascript">
            var obj = window.Gira.settingsSecurity;
            obj.init();

            $('#hidden-content .menuPage').remove();

            obj.ok = function () {
                var ret = obj._ok();
                if(ret === true) {
                    openSettingsElement('menuPage_pin','menuPage_0', undefined, false);
                }
                return function () { };
            }

            obj.cancel = function () {
                var navbarController = NavbarController.getInstance();
                obj._cancel();
                NavbarSettingsButton.toggleSettings();
            }

            if (obj.isProtected() === true) {
                var pinMenu = $('#menuPage_pin');
                ko.applyBindings(obj, pinMenu[0])

                var container = "#menuPage_pin  .settings-swiper-container";
                var scrollbar = "#menuPage_pin  .settings-swiper-scrollbar";
                var menuId = '#menuPage_pin';

                $(scrollbar).css('height', $(container).css('height') );

                createMenuSwiperV(container, scrollbar, menuId, '.settings-row');
                window.menuId = menuId;

                pinMenu.data("settingsSwiper").reInit();
            } else {
                preloadContainer('templates/settings/menuPage_0.xhtml');

                $('#mainMenu').replaceWith($('#menuPage_0'));
                $('#menuPage_0').data("settingsSwiper").reInit();
            }

        </script>
      </div>
    </xsl:template>
</xsl:stylesheet>
