<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">  
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output indent="yes" method="html"/> 
  <!-- key to select all details on the same container -->
  <xsl:key name="details-by-container" match="Filename[@id]" use="@id" />
  <xsl:template match="/">
    <xsl:variable name="viewId">
      <xsl:text>detail-view-</xsl:text>
      <xsl:value-of select="Container/@Index"/>
    </xsl:variable>
    <div class="view-container">
      <xsl:attribute name="id">
        <xsl:copy-of select="$viewId" />
      </xsl:attribute>
    <div id="breadcrumb-detail">
      <div class="t3sw" id="room"><xsl:value-of select="Container/Description/Language[@Index = 0]"/></div>     
    </div>
    <div id="detail-view">
      <div class="description-row-container">
        <div id="description-row" class="description-row active"></div>
        <div id="description-row-next" class="description-row next"></div>
        <div id="description-row-prev" class="description-row prev"></div>
      </div>
      <div class="container">
	      <div class="swiper-container-detail-view">
          <div class="swiper-wrapper">
        <xsl:variable name="container-list" select="Container/DetailView[not(@id=following::DetailView/@id)]" />

        <xsl:for-each select="$container-list">
          <xsl:variable name="container-id" select="position()-1" />
          <div id="slide-container-{$container-id}" class="swiper-slide">
            <detailViewElement>
              <xsl:value-of select="@Filename" />
            </detailViewElement>
          </div>
          </xsl:for-each>
	    </div>
       </div>
        <xsl:call-template name="bulletbar">
          <xsl:with-param name="srcElements" select="Container/DetailView[not(@id=following::DetailView/@id)]"/>
        </xsl:call-template>
      </div>  
    </div>
                    
    <script type="text/javascript">
      (function(){
        var isNotTopContainerIndex = <xsl:value-of select="not(Container/@Index = 'top')"/>;
        var viewId = '#<xsl:value-of select="$viewId"/>';

        <xsl:text disable-output-escaping="yes"><![CDATA[         
            var detailviewSwiper;

            $(viewId).data('caseSets', temporaryCaseSets);
            temporaryCaseSets = [];

            //initialize swiper container
            //detailviewSwiper = $(viewId + '> #detail-view > .container > .swiper-container-detail-view').swiper({

           detailviewSwiper = createSwiperH(viewId, '.swiper-container-detail-view', '{{bullets-active}}', '{{bullets-inactive}}', viewTypes.DETAIL);
           if(isNotTopContainerIndex){
              $(viewId + ' #description-row .room-name').css("display", "none");
           }
          ]]></xsl:text>
        })();
      </script>
    </div>

  </xsl:template>

</xsl:stylesheet>
