/*jslint browser: true*/
/*global ko, $, _*/
(function (ns) {
    "use strict";
    var Weather = window.Gira.Weather,
        SettingsKey = "weather.settings";

    function WeatherSettingsConnectionListener(viewModel) {
        var self = this;

        self.onOpen = function () {
            if (viewModel.onOpen) {
                viewModel.onOpen();
            }
        };

        self.onClose = function () {
            return undefined;
        };

        self.onError = function () {
            return undefined;
        };

        self.onMessage = function (obj) {
            var request;
            if (obj.event) {
                return;
            }
            if (obj.response && obj.response.request && obj.response.request.command === "GetAppValue" && obj.response.value) {
                request = obj.response.request;
                if (request.command === "GetAppValue" && request.key === SettingsKey) {
                    viewModel.applyData(JSON.parse(obj.response.value));
                }
            }
        };
    }

    function Settings(gdsConnection, config) {
        var self = this,
            connection = gdsConnection,
            currentSettings = { acceptedLicense: false, weatherStations: [] };

        function applyData(data) {
            if (data && data.acceptedLicense !== undefined) {
                currentSettings = data;
                self.weathers.applyData(data);
            } else {
                currentSettings = { acceptedLicense: false, weatherStations: [] };
            }
        }

        function addNewWeatherStationCallback(data) {
            currentSettings.weatherStations.push(data);
            connection.sendMessage(Settings.createSetAppValue(connection.getApplicationId(), SettingsKey, JSON.stringify(currentSettings)));
            applyData(currentSettings);
        }

        function deleteWeatherStationCallback(data) {
            var forDelete,
                index;

            data.forEach(function (itemForDelete) {
                forDelete = _.find(currentSettings.weatherStations, function (item) {
                    if (item.weatherStationId === itemForDelete.weatherStationId) {
                        return true;
                    }
                    return false;
                });

                if (forDelete) {
                    index = currentSettings.weatherStations.indexOf(forDelete);
                    if (index >= 0) {
                        currentSettings.weatherStations.splice(index, 1);
                    }
                }
            });

            connection.sendMessage(Settings.createSetAppValue(connection.getApplicationId(), SettingsKey, JSON.stringify(currentSettings)));
            applyData(currentSettings);
        }

        function sortWeatherStationCallback(dataItems) {
            currentSettings.weatherStations = [];
            currentSettings.weatherStations = dataItems;
            connection.sendMessage(Settings.createSetAppValue(connection.getApplicationId(), SettingsKey, JSON.stringify(currentSettings)));
            applyData(currentSettings);
        }

        function eulaAcceptedCallback() {
            currentSettings.acceptedLicense = true;
            connection.sendMessage(Settings.createSetAppValue(connection.getApplicationId(), SettingsKey, JSON.stringify(currentSettings)));
            applyData(currentSettings);
        }

        function initSettings() {
            connection.sendMessage(Settings.createGetAppValue(connection.getApplicationId(), SettingsKey));
        }

        function setDataService(dataService) {
            self.weathers.setDataService(dataService);
        }

        self.weathers = new Weather.WeatherStationSetting(addNewWeatherStationCallback, deleteWeatherStationCallback, sortWeatherStationCallback, eulaAcceptedCallback, config);

        return {
            getCurrentSettings: function () {
                return currentSettings;
            },
            weathers: self.weathers,
            init: initSettings,
            applyData: applyData,
            onOpen: initSettings,
            apply: function () {
                self.weathers.apply();
                return undefined;
            },
            ok: function () {
                return undefined;
            },
            cancel: function () {
                return undefined;
            },
            label: config.text.weatherStationMenuTitle,
            setDataService: setDataService
        };
    }

    Settings.createGetAppValue = function (appName, key) {
        return {
            request: {
                command: "GetAppValue",
                appName: appName,
                key: key
            }
        };
    };

    Settings.createSetAppValue = function (appName, key, value) {
        return {
            request: {
                command: "SetAppValue",
                appName: appName,
                key: key,
                value: value
            }
        };
    };

    ns.WeatherSettingsConnectionListener = WeatherSettingsConnectionListener;
    ns.Settings = Settings;
}(window.Gira.Weather));

//# sourceURL=weather.settings.js