﻿/*global $, gds$, NavbarSettingsButton, globals, ComClient, parseInt, tsxGdsUtility$*/
/*jslint browser: true*/

/**
*
*   this module handles startup actions for the gira G1 
*
*/
window.tsx.startup = new (function () {
    var module = {};
    var gdsAppName = 'gira-app';

    /**
    * open the settings menu if required
    */
    function openSettingsAfterWizard() {
        var gdsStartupParameter = 'startupParameter';

        gds$.getAppValue(gdsAppName, gdsStartupParameter, function (response) {
            if (response.value === "true") {
                NavbarSettingsButton.toggleSettings();
                setTimeout(function () { $(".settings-row[menuid*='system']").trigger('settingsEntryAction'); }, 1000);
                gds$.setAppValue(gdsAppName, gdsStartupParameter, 'false');
            }
        });
    }

    /**
    * Checks if Wifi is available and return true or false. 
    */
    function checkConnectionTypeWifi() {
        gds$.updateDeviceConfiguration(true, function(deviceConfig) {
            globals.wifi.available = deviceConfig.NetworkTechnologies_wifi_Powered === 'true';
        });
    }

    /**
    *   Do setup during system startup that require a GDS Connection
    */
    module.onGDSConnection = function () {
        var callback = function () {
            ComClient.unregisterEventHandler(ComClient.connectionEvents.CONNECTED, callback);

            gds$.getAppValue(gdsAppName, "resetTimers", function (response) {
                if (!response.value) {return;}
                var timerConfig = JSON.parse(response.value);
                if (timerConfig.timersEnabled === "false") {
                    tsxGdsUtility$.deleteAllTimers(globals.timer.rfcClockStartId, 125);
                    gds$.setAppValue(gdsAppName, "resetTimers", "false");
                } else {
                    if (timerConfig.channels && timerConfig.channels.length > 0) {
                        timerConfig.channels.forEach(function (channel) {
                            var timerId = parseInt(globals.timer.rfcClockStartId + (parseInt(channel.count) * globals.timer.rfcClockOffset));
                            tsxGdsUtility$.deleteTimers(timerId, [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9]);
                            tsxGdsUtility$.setTimerState(timerId, false);
                        });
                        gds$.setAppValue(gdsAppName, "resetTimers", JSON.stringify({channels: [], timersEnabled: "true"}));
                    }
                }
            });
            gds$.getAppValue(gdsAppName, "resetRtcTimers", function (response) {
                if (response.value === 'true') {
                    tsxGdsUtility$.deleteRtcTimers();
                    gds$.setAppValue(gdsAppName, "resetRtcTimers", "false");
                }
            });
            gds$.getAppValue(window.Gira.dateTimeFormatsModel.getApplicationId(), window.Gira.dateTimeFormatsModel.getDateTimeFormatsKey(), window.Gira.dateTimeFormatsModel.init());
            checkConnectionTypeWifi();
        };
        ComClient.registerOnConnectedEX(callback);
    };

    /**
    * Perform the last startup steps after the whole document has been loaded
    */
    module.onAppReady = function () {
        //Close System's overlay after GDS connection is established
        setTimeout(function () {
            ComClient.registerOnConnectedEX(tsxGdsUtility$.removeSplashScreen);
        }, globals.startup.delaySpashScreenRemoval);

        //open settings if first startup
        setTimeout(function(){
            openSettingsAfterWizard();
        }, globals.startup.delaySettingsMenu);
    };

    return module;

});
//# sourceURL= startup.js