var jsKeyboard = {
    keyboard: '',
    longPressTimer: '',
    longPressInterval: '',
    visible: false,
    locked: false,
    /**
    * Returns true if the element should have a keyboard (only text and password inputs have a keyboard)
    */
    shouldHaveKeyboard: function (element)
    {
        var typeAttribute = element.prop('type');
        return element.is(':input') && (typeAttribute === 'text' || typeAttribute === 'password');
    },
    /**
     * Returns true if the element should have a numeric keyboard
     */
    shouldHaveGiraNummericKeyboard: function (element)
    {
        var nummericAttribute = element.attr('nummeric');
        return (nummericAttribute === 'true');
    },
    /**
    * Initilizes the keyboard controller and registers events for showing and hiding the keyboard.
    */
    init: function (elem)
    {
        jsKeyboard.keyboard = elem;
        jsKeyboard.locked = false;

        // register for focus event to automatically show keyboard
        document.body.addEventListener('focus', function (event)
        {
            if( jsKeyboard.shouldHaveKeyboard($(event.target)) )
            {
                jsKeyboard.currentElement = $(event.target);
                jsKeyboard.attachOnInputCallback();
                jsKeyboard.currentElementCursorPosition = $(event.target).getCursorPosition();
                fsm.API.Keyboard.Open();
                if( jsKeyboard.shouldHaveGiraNummericKeyboard($(event.target)) ) {
                    jsKeyboard.changeToGiraNumericKeypad();
                }
                jsKeyboard.triggerEvent('input'); // trigger , if has the focus
                jsKeyboard.setSwiperOffset(jsKeyboard.getTopOffset());
            }
        }, true);

        // register for blur event to automatically hide keyboard
        document.body.addEventListener('blur', function (event)
        {
            if( jsKeyboard.shouldHaveKeyboard($(event.target)) )
            {
                setTimeout(function ()
                {
                    if (!$(':focus').is(':input') && !jsKeyboard.locked)
                    {
                        fsm.API.Keyboard.Close();
                        //jsKeyboard.hide();
                    }
                }, 200);
            }

        }, true);

    },

    lockKeyboard: function(truefalse) {
        jsKeyboard.locked = truefalse === true ? true : false;
        if (truefalse === false) {
            if (jsKeyboard.currentElement != null) {
                jsKeyboard.currentElement[0].focus();
            }
        }
    },

    // trigger an event with name, we need the input event,yet
    triggerEvent: function(name)
    {        
        if( jsKeyboard.currentElement ) 
        {            
            var event = new Event(name);
            jsKeyboard.currentElement[0].dispatchEvent(event);
        }
    },

    currentElement: null,

    

    attachOnInputCallback: function ()
    {
        if( jsKeyboard.currentElement )
        {
            
            jsKeyboard.currentElement.oninput = function()
            {
                // trigger all input event's
                jsKeyboard.triggerEvent('input');
            };
        }
    },

    // remove the input and trigger the input event
    clear: function()
    {
        if( jsKeyboard.currentElement )
        {
            jsKeyboard.currentElement.val('');
            jsKeyboard.triggerEvent('input');
        }
    },

    /**
    * Registers event handlers for the down-state handling of all keyboard buttons.
    */
    addKeyDownEvent: function () {
        var buttons = $("#giraKeyboardNumericKeypad > div.button, #keyboardSmallLetter > div.button, #keyboardCapitalLetter > div.button, #keyboardSmallLetter > div.button, #keyboardSmallNumber > div.button, #keyboardCapitalNumber > div.button, #keyboardSymbols > div.button");
        $.each(buttons, function (index, button) {
            var element = $(button);
            var downFunction = function() {
                $(element).addClass("buttonDown");
                spriteDown(this);
            };
            var upFunction = function() {
                $(element).removeClass("buttonDown");
            };
            var clickAction = function() {
                var func = $(element).attr('func');
                eval(func);
            };

            registerEventsBase(element, downFunction, upFunction, clickAction, { stopPropagation: false, ignoreY: true, callUpFunction4TouchMove: false, callClickAction4TouchEnd: true, clickDelay: 0 });
            
        });
    },
    /**
    * Shows the small letter layout.
    */
    changeToSmallLetter: function() {
        $("#keyboardCapitalLetter,#keyboardSmallNumber,#keyboardCapitalNumber,#keyboardSymbols, #giraKeyboardNumericKeypad").css("display", "none");
        $("#keyboardSmallLetter").css("display", "block");
    },
    /**
    * Shows the capital letter layout.
    */
    changeToCapitalLetter: function() {
        $("#keyboardCapitalLetter").css("display", "block");
        $("#keyboardSmallLetter,#keyboardSmallNumber,#keyboardCapitalNumber,#keyboardSymbols, #giraKeyboardNumericKeypad").css("display", "none");
    },
    /**
    * Shows the small number layout.
    */
    changeToSmallNumber: function() {
        $("#keyboardSmallNumber").css("display", "block");
        $("#keyboardSymbols,#keyboardCapitalLetter,#keyboardCapitalNumber,#keyboardSmallLetter, #giraKeyboardNumericKeypad").css("display", "none");
    },
    /**
    * Shows the capital number layout.
    */
    changeToCapitalNumber: function() {
        $("#keyboardCapitalNumber").css("display", "block");
        $("#keyboardSymbols,#keyboardCapitalLetter,#keyboardSmallNumber,#keyboardSmallLetter, #giraKeyboardNumericKeypad").css("display", "none");
    },
    /**
     * Shows the Gira capital big-number layout.
     */
    changeToGiraNumericKeypad: function() {
        $("#giraKeyboardNumericKeypad").css("display", "block");
        $("#keyboardSymbols,#keyboardCapitalLetter,#keyboardSmallNumber,#keyboardCapitalNumber,#keyboardSmallLetter").css("display", "none");
    },
    /**
    * Shows the symbol layout.
    */
    changeToSymbols: function() {
        $("#keyboardCapitalLetter,#keyboardSmallNumber,#keyboardCapitalNumber,#keyboardSmallLetter, #giraKeyboardNumericKeypad").css("display", "none");
        $("#keyboardSymbols").css("display", "block");

    },
    /**
    * Sets the cursor position of the input element to the cursor position stored in the keyboard controller.
    */
    updateCursor: function() {
        //input cursor focus and position during typing
        jsKeyboard.currentElement.setCursorPosition(jsKeyboard.currentElementCursorPosition);
    },
    /**
    * Inserts a character at the current cursor position.
    * @param {int} m Charcode of the new character
    */
    write: function (m)
    {
        var a = jsKeyboard.currentElement.val(),
            b = String.fromCharCode(m),
            pos = jsKeyboard.currentElement.getCursorPosition(),
            output = [a.slice(0, pos), b, a.slice(pos)].join('');

        jsKeyboard.currentElement.val(output);
        jsKeyboard.currentElementCursorPosition = pos + 1;
        jsKeyboard.updateCursor();
        jsKeyboard.triggerEvent('input');
    },
    /**
    * Deletes the character before the current cursor position.
    */
    del: function ()
    {
        var a = jsKeyboard.currentElement.val(),
            pos = jsKeyboard.currentElement.getCursorPosition(),
            output = [a.slice(0, pos - 1), a.slice(pos)].join('');
        if (pos === 0) return;
        jsKeyboard.currentElement.val(output);
        jsKeyboard.currentElementCursorPosition = pos - 1;
        jsKeyboard.updateCursor();
        jsKeyboard.triggerEvent('input');
    },

    checkLongPress: function (elem)
    {
        if ($(elem).hasClass("button_enter"))
            return;

        if ($(elem).hasClass("button_capitalletterleft"))
            return;

        if ($(elem).hasClass("button_numberleft"))
            return;

        if ($(elem).hasClass("buttonHide"))
            return;

        if ($(elem).hasClass("button_smallletter"))
            return;

        if ($(elem).hasClass("button_specialchars"))
            return;

        var that = this;
        jsKeyboard.longPressTimer = setTimeout(function ()
        {
            var onclick = $(elem).attr("onclick");
            eval(onclick);
            onclick = onclick.split(".");
            onclick = onclick[1];
            jsKeyboard.longPressInterval = setInterval("jsKeyboard." + onclick, 150);
        }, 550);
    },

    cancelLongPress: function ()
    {
        if (jsKeyboard.longPressTimer != undefined)
            clearTimeout(jsKeyboard.longPressTimer);

        if (jsKeyboard.longPressInterval != undefined)
            clearInterval(jsKeyboard.longPressInterval);
    },

    /**
    * Hides the keyboard.
    */
    enter: function ()
    {
        jsKeyboard.hide();
    },
    /**
    * Inserts a character at the current cursor position.
    * @param {int} m Charcode of the new character
    */
    writeSpecial: function(m) {
        var a = jsKeyboard.currentElement.val(),
            b = String.fromCharCode(m),
            pos = jsKeyboard.currentElement.getCursorPosition();
        output = [a.slice(0, pos), b, a.slice(pos)].join('');
        jsKeyboard.currentElement.val(output);
        jsKeyboard.currentElementCursorPosition = pos + 1;
        jsKeyboard.updateCursor();        
        jsKeyboard.triggerEvent('input');
    },
    /**
    * Loads and initializes the keyboard layout if it is currently not attached to the DOM tree. Also triggers the
    * open animation.
    */
    show: function() {
        var that = this;
        var $keyboard = $("#" + this.keyboard);
        var en = getHTTPGetParameters('locale') === 'en-US';
        var keyboardlayout = 'templates/keyboard/keyboard_de.xhtml';
        if (en) {
            keyboardlayout = 'templates/keyboard/keyboard_en.xhtml';
        }


        if ($keyboard.length === 0) {
            $.ajax({
                url: keyboardlayout,
                data: {},
                cache: false,
                async: false,
                success: function(data) {
                    $("body").append($(data));
                    jsKeyboard.addKeyDownEvent();
                    $keyboard = $("#" + jsKeyboard.keyboard);
                    $keyboard.on('mousedown', function(e) {
                        e.stopPropagation();
                        e.preventDefault();
                    });

                    /*
                    // AB: unwanted feature, so disable it
                    $($keyboard).find(".button").mousedown(function(){
                        that.checkLongPress($(this));
                    });

                    $($keyboard).find(".button").mouseup(function(){
                        that.cancelLongPress();
                    });
                    */
                },
                dataType: 'html'
            });
        } else {
            jsKeyboard.changeToSmallLetter();
        }

        jsKeyboard.attachOnInputCallback();
        
        if (jsKeyboard.visible) {
            jsKeyboard.setSwiperOffset(jsKeyboard.getTopOffset());
        } else {
            jsKeyboard.visible = true;
            $keyboard.on('transitionend webkitTransitionEnd', function(e) {

                jsKeyboard.setSwiperOffset(jsKeyboard.getTopOffset());
                $keyboard.unbind('transitionend webkitTransitionEnd');
            });
        }

        setTimeout(function() {
            $keyboard.removeClass('slideOutFromBottom-keyboardAnimation').addClass('slideInFromBottom-keyboardAnimation');
            //  $keyboard.unbind('transitionend webkitTransitionEnd');
        }, 0);

    },

    /*
     	get the swiper from the DOM
	*/
    getSwiper: function() {

        if (jsKeyboard.currentElement == null || jsKeyboard.currentElement == undefined)
            return null;

        var elem = jsKeyboard.currentElement;

        while (elem !== undefined && elem[0] !== undefined)
        {
            var classID = $(elem).attr('class');
            if (classID != undefined)
            {
                if (classID.indexOf('menuPage') != -1)
                {
                    return elem.data("settingsSwiper");
                }
            }
            elem = elem.parent();
        }
        return null;

    },

    /* get the parent div  */
    getParentRow: function ()
    {
        if (jsKeyboard.currentElement == null || jsKeyboard.currentElement == undefined)
            return null;

        var elem = jsKeyboard.currentElement;

        while (elem != undefined)
        {
            var classID = $(elem).attr('class');
            if (classID != undefined)
            {
                if (classID.indexOf('settings-row inputField') != -1)
                {
                    return $(elem);
                }
            }
            elem = elem.parent();
        }
        return null;
    },


    /* calculate the scoll offset */
    getTopOffset: function ()
    {
        var keyb = $("#virtualKeyboard");
        if (jsKeyboard.currentElement == undefined || keyb == undefined)
            return 0;

        var offs = keyb.offset();

        if (offs == undefined)
            return 0;
        var key_top = offs.top;

        var currentElem = jsKeyboard.getParentRow();
        var differenz = 0;
        if (currentElem == null) // parent div ?
        {
            currentElem = jsKeyboard.currentElement;
            differenz = 30; // 30 pixel extra
        } else if (currentElem.hasClass("keyboardAddSpace") === true) {
            differenz = 30;
        }
        var elem_top = currentElem.offset().top;
        var height = currentElem.height();
        var elem_bottom = elem_top + height;

        var swiper = jsKeyboard.getSwiper();
        var swiper_offs = swiper.getWrapperTranslate();
        if (swiper_offs < 0) {
            elem_bottom += -swiper_offs;
        }
        if (elem_bottom >= key_top) {
            var d = (elem_bottom - key_top); // + 30;
            if (differenz)
                d += differenz; // 30 pixel extra
            return -d;
        }
        return 0;
    },


    /*
       set the top position for the input field ~ scroll the container

    */
    setSwiperOffset: function (offs)
    {

        if (jsKeyboard.currentElement != null && jsKeyboard.currentElement != undefined) {

            var swiper = jsKeyboard.getSwiper();
            jsKeyboard.resetSwiper(false, offs);

        }
    },

    /*
       lock reset / or reset the scrollbox and set the top position to zero  

    */
    resetSwiper: function (e, anchorPos)
    {
        var swiper = jsKeyboard.getSwiper();
        if (swiper != null) // reset the swiper , if e = true , set the top offset to 0
        {
            swiper.canReset(e);
            swiper.setAnchorPosition(anchorPos);
        }
    },


/**
    * Triggers the close animation and removes the keyboard from the DOM tree if the translation was not interrupted 
    * by another call to show.
    */
    hide: function () {
        if (jsKeyboard.locked)
            return;

        if (jsKeyboard.currentElement) {
            jsKeyboard.currentElement.blur(); // remove focus
        }
        var $keyboard = $("#virtualKeyboard");
        jsKeyboard.visible = false;
        jsKeyboard.resetSwiper(true, 0);

        $keyboard.addClass('slideOutFromBottom-keyboardAnimation');
        $keyboard.removeClass('slideInFromBottom-keyboardAnimation');
        //$keyboard.unbind('transitionend webkitTransitionEnd');


        /*
        show / hide conflict, we don't use it now
        Frank H.
        */
        $keyboard.bind('transitionend webkitTransitionEnd', function () {
            $keyboard.unbind('transitionend webkitTransitionEnd');
            /*  var matrix = new WebKitCSSMatrix($keyboard.css("-webkit-transform"));
            if( matrix.m41 === 0 )
                $keyboard.remove();*/
        });
        /**/
    }
};
(function(){
    fsm.API.Keyboard.Init(function () { jsKeyboard.show(); }, function () { jsKeyboard.hide(); }, function () { jsKeyboard.lockKeyboard(true); }, function () { jsKeyboard.lockKeyboard(false); });
})();

/**
* GET CURSOR POSITION
*/
jQuery.fn.getCursorPosition = function ()
{
    if (this.length == 0) return -1;
    return $(this).getSelectionStart();
}

/**
* GET selection start
*/
jQuery.fn.getSelectionStart = function ()
{
    if (this.length == 0) return -1;
    return this[0].selectionStart;
}

/**
* SET CURSOR POSITION
*/
jQuery.fn.setCursorPosition = function (pos)
{
    this.each(function (index, elem) {
        elem.focus();
        if (elem.setSelectionRange)
        {
            elem.setSelectionRange(pos, pos);
        } else if (elem.createTextRange)
        {
            var range = elem.createTextRange();
            range.collapse(true);
            range.moveEnd('character', pos);
            range.moveStart('character', pos);
            range.select();
        }
        elem.scrollLeft = 99999;
    });
    return this;
};