﻿(function () {

    var destroySwiper = function (element) {
        var swiper = $(element).data("settingsSwiper");
        if (swiper) {
            swiper.destroy();
        }
    };

    var customCleanUp = function (elements) {
        // Each function from underscore.js 
        _.each(elements, function (element) {
            destroySwiper(element);
            _.each($(element).find('*'), destroySwiper);
            ko.cleanNode(element);
        });
    };

    // Store original jQuery remove method
    var jQueryRemove = jQuery.fn.remove;

    // Override remove function
    jQuery.fn.remove = function (args) {
        customCleanUp(this);
        // Call original jQuery remove method
        return jQueryRemove.call(this, args);
    }
})();