/*global ko, globals, $*/
/*jslint browser:true*/
(function (ns) {
    "use strict";
    ns.ShutterRelativeModel = function (config, tsx) {
        var stepId = config.stepId,
            moveId = config.moveId,
            stepMoveThreshold = config.stepMoveThreshold,
            slatThreshold = config.slatThreshold,
            connection = config.connection,
            isInMove = false,
            Button = function (stepValue) {
                var isUp = ko.observable(true),
                    moveTimeoutId,
                    slatTimeoutId;
                return {
                    down: function () {
                        isUp(false);
                        connection.setValue(stepId, stepValue);
                        moveTimeoutId = setTimeout(function () {
                            connection.setValue(moveId, stepValue);
                            isInMove = true;
                            slatTimeoutId = setTimeout(function () {
                                isInMove = false;
                            }, slatThreshold);
                        }, stepMoveThreshold);
                    },
                    up: function () {
                        clearTimeout(moveTimeoutId);
                        clearTimeout(slatTimeoutId);

                        if (isInMove) {
                            isInMove = false;
                            connection.setValue(stepId, stepValue);
                        }
                        isUp(true);

                    },
                    isUp: isUp
                };
            },
            buttonUp = new Button(0),
            buttonDown = new Button(1);

        function registerTimer() {
            var timerFunctions;
            if (config.timerEnabled) {
                timerFunctions = [{ name: "move", datapoint: moveId, values: [0, 1]}];
                tsx.timer.registerTimer(config.detailId, 'blindShutterRelative', config.count, timerFunctions);
            }
        }

        registerTimer();

        return {
            buttonUp: buttonUp,
            buttonDown: buttonDown,
            areAllButtonsUp: ko.computed(function () {
                return buttonUp.isUp() && buttonDown.isUp();
            })
        };
    };
}(window));
