/*global ko, window, $*/
(function (ns) {
    "use strict";

    function DateTimeFormats(translate, gds, config) {
        var Globals = window.Gira.Globals,
            data = JSON.parse(config),
            gds$ = gds,
            dateTimeFormats = data,
            defaultDateFormat = dateTimeFormats.dateFormats[0],
            timeFormat12h = dateTimeFormats.timeFormats.h12,
            timeFormat24h = dateTimeFormats.timeFormats.h24,
            allDateFormats = dateTimeFormats.dateFormats,
            selectedDateFormat = ko.observable(defaultDateFormat),
            selectedTimeFormat = ko.observable(timeFormat24h),
            chosenDateFormat = ko.observable(defaultDateFormat),
            applicationId = Globals.ApplicationName,
            dateTimeFormatsKey = "dateTimeFormats",
            checked = ko.observable(false);

        function saveToDevice() {
            var messageToBeSend = JSON.stringify({dateFormat: chosenDateFormat(), timeFormat: selectedTimeFormat()});
            gds$.setAppValue(applicationId, dateTimeFormatsKey, messageToBeSend);
        }

        function saveDateToDevice() {
            chosenDateFormat(selectedDateFormat());
            saveToDevice();
        }

        checked.subscribe(function () {
            if (checked()) {
                selectedTimeFormat(timeFormat12h);
            } else {
                selectedTimeFormat(timeFormat24h);
            }
            saveToDevice();
        });

        function getApplicationId() {
            return applicationId;
        }

        function getDateTimeFormatsKey() {
            return dateTimeFormatsKey;
        }

        function getValueFromDevice(data) {
            var respondedValue;

            if (data && data.value) {
                respondedValue = JSON.parse(data.value);
                selectedDateFormat(respondedValue.dateFormat);
                chosenDateFormat(respondedValue.dateFormat);

                checked(respondedValue.timeFormat === timeFormat12h);

                selectedTimeFormat(respondedValue.timeFormat);
            }
        }

        function initSettings() {
            gds$.getAppValue(applicationId, dateTimeFormatsKey, getValueFromDevice);
        }

        function getTimeFormat() {
            return selectedTimeFormat();
        }

        function getDateFormat() {
            return chosenDateFormat();
        }

        return {
            date: {
                formats: allDateFormats,
                ok: saveDateToDevice,
                cancel: function () {
                    return undefined;
                },
                label: translate.menuConfigSetDateFormat
            },
            changeTimeFormat: {
                checked: checked,
                label: translate.menuConfig12timeFormat,
                isVisible: true
            },
            selectedDateFormat: selectedDateFormat,
            selectedTimeFormat: selectedTimeFormat,
            chosenDateFormat: chosenDateFormat,
            init: initSettings,
            getApplicationId: getApplicationId,
            getDateTimeFormatsKey: getDateTimeFormatsKey,
            getTimeFormat: getTimeFormat,
            getDateFormat: getDateFormat,
            i18nTexts: translate
        };
    }

    ns.DateTimeFormats = DateTimeFormats;

}(window.Gira));
//# sourceURL=gira.dateTimeFormats.js