/*global $, registerEventsForSwipeableElement, ComClient*/
/*jslint browser: true*/

/**
 * Change sprite_XYZ class of element to sprite_XYZ_down
 * for key down image
 * 
 * @param {type} element element to change
 * @returns {undefined}
 */
function spriteTriggerDown(element) {
    if (element !== undefined && element !== null) {
        var cName = element.className;
        var sprite = cName.match(/\bsprite_(\w|[-])*/i);
        if (sprite !== null && sprite[0].match("_down") === null) {
            var spriteNew = sprite[0] + "_down";
            element.className = cName.replace(sprite[0], spriteNew);
        }
        if ($(element).hasClass('shadow-trigger')) {
            $(element).addClass('shadow-trigger-active');
            $(element).removeClass('shadow-trigger');
        }
    }
}

/**  
 * Change sprite_XYZ_down class of element to sprite_XYZ
 * for key up image
 * 
 * @param {type} element element to change
 * @returns {undefined}
 */
function spriteTriggerUp(element) {
    if (element !== undefined) {
        var cName = element.className;
        var sprite = cName.match(/\bsprite_(\w|[-])*_down/i);
        if (sprite !== null) {
            var spriteNew = sprite[0].replace("_down", "");
            element.className = cName.replace(sprite[0], spriteNew);
        }
        if ($(element).hasClass('shadow-trigger-active')) {
            $(element).removeClass('shadow-trigger-active');
            $(element).addClass('shadow-trigger');
        }
    }
}

/**
 * Called when trigger button is clicked down
 * 
 * @param {type} triggerJQuery jQuery call of element
 * @returns {undefined}
 */
function onTriggerDown(triggerJQuery) {
    var triggerButton = triggerJQuery;
    if (triggerButton.length > 0) {
        spriteTriggerDown(triggerButton[0]);
    }
}

/**
 * Called when trigger button is released
 * 
 * @param {type} triggerJQuery jQuery call of element
 * @returns {undefined}
 */
function onTriggerUp(triggerJQuery) {
    var triggerButton = triggerJQuery;
    if (triggerButton.length > 0) {
        spriteTriggerUp(triggerButton[0]);
    }
}

/**
 * Eventlistener for trigger buttons
 * mouse and touch events 
 * 
 * @param {type} id id of button
 * @returns {undefined}
 */
function eventsOnTrigger(id, tag) {
    var triggerJQuery = $(id).find('.trigger-button');
    var checkbox = $(id).find('input[type="checkbox"]');

    registerEventsForSwipeableElement(triggerJQuery,
        function () {
            onTriggerDown(triggerJQuery);
        },
        function () {
            onTriggerUp(triggerJQuery);
        },
        function () {
            if (!triggerJQuery.find('.trigger-text-off').is(':animated')) {
                checkbox.prop("checked", !checkbox.prop("checked"));
                ComClient.sendTagValue(tag, 1);
            }
        }
    );

}

/**
 * Changes trigger button ring state and text value
 * animation
 * 
 * @param {type} value true or false, for on and off state
 * @param {type} btn id of the trigger button
 * @returns {undefined}
 */
function changeTriggerButtonState(value, id) {
    var $id = $(id);
    var ring1 = $id.find('.ring1');
    var ring2 = $id.find('.ring2');
    var textOn = $id.find('.trigger-text-on');
    var textOff = $id.find('.trigger-text-off');

    ring1.clearQueue();
    ring2.clearQueue();
    textOn.clearQueue();
    textOff.clearQueue();

    if (value === true) {
        ring1.animate({ opacity: 1 }, 500);
        ring2.animate({ opacity: 0 }, 500);
        textOff.animate({ opacity: 0 }, 500);
        textOn.animate({ opacity: 1 }, 500);
    } else {
        ring2.animate({ opacity: 1 }, 500);
        ring1.animate({ opacity: 0 }, 500);
        textOn.animate({ opacity: 0 }, 500);
        textOff.animate({ opacity: 1 }, 500);
    }
}

function initTriggerButtonState(value, id) {
    var $id = $(id);
    var ring1 = $id.find('.ring1');
    var ring2 = $id.find('.ring2');
    var textOn = $id.find('.trigger-text-on');
    var textOff = $id.find('.trigger-text-off');

    if (value === 1) {
        ring1.css("opacity", "1");
        ring2.css("opacity", "0");
        textOff.css("opacity", "0");
        textOn.css("opacity", "1");
    } else {
        ring2.css("opacity", "1");
        ring1.css("opacity", "0");
        textOn.css("opacity", "0");
        textOff.css("opacity", "1");
    }
}



