/*global $, ComClient, registerEventsForSwipeableElement, _findElement*/
/*jslint browser: true*/

/**
 * Change sprite_XYZ class of element to sprite_XYZ_down
 * for key down image and set shadow
 * 
 * @param {type} element element to change
 * @returns {undefined}
 */
function switchDown(element) {
    var cName = element.className;
    var sprite = cName.match(/\bsprite_\S*/i);
    if (sprite !== null && sprite[0].match("_down") === null) {
        var spriteNew = sprite[0] + "_down";
        element.className = cName.replace(sprite[0], spriteNew);
    }
    var parentDiv = $(element).parent();
    if (parentDiv.hasClass('shadow')) {
        var top = parentDiv.find('.switch-button-top');
        var bottom = parentDiv.find('.switch-button-bottom');
        shadow = true;
        parentDiv.removeClass('shadow');
        if (cName.match(/switch-button-top/i)) {
            bottom.addClass('shadow');
        } else if (cName.match(/^switch-button-bottom/i)) {
            top.addClass('shadow');
        }
    }
}

/**  
 * Change sprite_XYZ_down class of element to sprite_XYZ 
 * for key up image and set shadow
 * 
 * @param {type} element element to change
 * @returns {undefined}
 */
function switchUp(element) {
    var cName = element.className;
    var sprite = cName.match(/\bsprite_\S*_down/i);
    if (sprite !== null) {
        var spriteNew = sprite[0].replace("_down", "");
        element.className = cName.replace(sprite[0], spriteNew);
    }
    var parentDiv = $(element).parent();
    if (shadow === true) {
        var top = parentDiv.find('.switch-button-top');
        var bottom = parentDiv.find('.switch-button-bottom');
        if (cName.match(/^switch-button-top/i)) {
            bottom.removeClass('shadow');
        } else if (cName.match(/^switch-button-bottom/i)) {
            top.removeClass('shadow');
        }
        shadow = false;
        parentDiv.addClass('shadow');
    }
}


/**
 * Called when switch button is clicked down
 * 
 * @param {type} switchJQuery jQuery call of element
 * @returns {undefined}
 */
function onSwitchDown(switchJQuery) {
    var switchButton = switchJQuery;
    if (switchButton.length > 0) {
        switchDown(switchButton[0]);
    }
}

/**
 * Called when switch button is released
 * 
 * @param {type} switchJQuery jQuery call of element
 * @returns {undefined}
 */
function onSwitchUp(switchJQuery) {
    var switchButton = switchJQuery;
    if (switchButton.length > 0) {
        switchUp(switchButton[0]);
    }
}

/**
 * Eventlistener for switch buttons
 * mouse and touch events
 * 
 * @param {type} id id of button
 * @returns {undefined}
 */
function eventsOnSwitch(cssPath, tag, value) {
    var switchJQuery = _findElement(cssPath);
    shadow = false;

    registerEventsForSwipeableElement(switchJQuery,
        function () {
            onSwitchDown(switchJQuery);
        },
        function () {
            onSwitchUp(switchJQuery);
        },
        function () {
            var switchContainer = switchJQuery.parent().parent();
            if (!switchContainer.find('.switch-ring').is(':animated')) {
                ComClient.sendTagValue(tag, value);
            }
        });
}

/**
 * Changes switch button ring state
 * animation
 * 
 * @param {type} value true or false for on and off
 * @param {type} btn id of the switch button
 * @returns {undefined}
 */
function changeSwitchButtonState(value, id) {
    var ring1 = $(id).find('.ring1');
    var ring2 = $(id).find('.ring2');

    $(ring1).stop(true);
    $(ring2).stop(true);

    if (value === true) {
        $(ring1).animate({ opacity: 1 }, 500);
        $(ring2).animate({ opacity: 0 }, 500);
    } else {
        $(ring2).animate({ opacity: 1 }, 500);
        $(ring1).animate({ opacity: 0 }, 500);
    }
}

function initSwitchButtonState(value, btn) {
    var ring1 = $('#' + btn).find('.ring1');
    var ring2 = $('#' + btn).find('.ring2');

    if (value === 1) {
        $(ring1).css("opacity", "1");
        $(ring2).css("opacity", "0");
    } else {
        $(ring2).css("opacity", "1");
        $(ring1).css("opacity", "0");
    }
}

