﻿/*global $, ComClient, globals, parseInt*/
/*jslint browser: true*/

function Slider(sliderId, orient, min, max, tag, valueInvert, position, range, step, animationSpeed, inUseTimer, valueText) {
    inUseTimer = 200;
    var slider = this;
    this._animationSpeed = animationSpeed;
    this.sliderRange = globals.blind.sliderbg;
    this.sliderHatch = globals.blind.hatch;
    this.sliderBg = globals.blind.mask;
    this.sliderButton = globals.blind.button;
    this.sliderButtonDown = globals.blind.buttonDown;
    this._detailId;
    this._sliderId = sliderId;
    this._sliderHeight = parseInt($(sliderId).css("height"));
    this._valueInvert = valueInvert;
    this._min = min;
    this._max = max;
    this._startValue;
    this._position = position;
    this._range = range;
    this._target = false;
    this._animate = false;
    this._inUser = false;
    this._inUseTimeout = undefined;
    this._valueText = valueText;
    this._lastUserVal = 0;
    $(this._sliderId).slider({
        orientation: orient,
        range: range,
        min: min,
        max: max,
        value: 100,
        step: step,
        stop: function (event, ui) {
            var value = slider._valueInvert ? slider._max - ui.value : ui.value;
            slider._lastUserVal = value;

            ComClient.sendTagValue(tag, value);
            slider.setSliderValue(value, true);
            clearTimeout(slider._inUseTimeout);
            slider._inUseTimeout = setTimeout(function () {
                slider._inUse = false;
            }, inUseTimer);
        },
        start: function (event, ui) {
            slider._startValue = ui.value;
        },
        slide: function (event, ui) {
            slider._inUse = true;
            slider._target = slider._valueInvert ? slider._max - ui.value : ui.value;

            if (slider._valueText) {
                slider.setText(ui.value);
            }

            this._target = slider._target;

            $(slider._sliderId + " > .ui-slider-bluebar").stop();
            $(slider._sliderId + " > .ui-slider-stripe-bar").stop();

            $(slider._sliderId + " > .ui-slider-stripe-bar").css('height', slider._target + '%');

            if (slider._target < slider._lastUserVal) {
                $(slider._sliderId + "> .ui-slider-bluebar").css('height', slider._target + '%');
                $(slider._sliderId + " > .ui-slider-stripe-bar").css('height', slider._lastUserVal + '%');
            }
        }
    });


    //Overwrite uiSliders refresh method to handle the slider handle only
    $(this._sliderId).data('uiSlider')._refreshValue = function () {
        var valPercent = (this._valueMax() !== this._valueMin()) ?
                    (this.value() - this._valueMin()) / (this._valueMax() - this._valueMin()) * 100 : 0;

        this.handle.stop(1, 1)["css"]({bottom: valPercent + '%'}, false);
    };

    /*
     * prepends the slider background AFTER the parend element
     */
    $(this._sliderId).prepend("<div class='ui-slider-" + orient + " ui-slider-background'></div>");
    /*
    * Sets all backgrounds and background colors
    */
    $(this._sliderId + "> .ui-slider-range").after("<div class='ui-slider-bluebar'></div>");
    $(this._sliderId + "> .ui-slider-bluebar").addClass("ui-slider-blue-bar").addClass(this.sliderRange);
    $(this._sliderId + "> .ui-slider-range").addClass("ui-slider-stripe-bar").addClass(this.sliderHatch);
    $(this._sliderId + "> .ui-slider-background").addClass(this.sliderBg).addClass("sprites");
    $(this._sliderId).css("background-color", "rgb(220,220,220)");

    /*
    * Up-Down Status of the Slider Handle
    */
    var sliderHandle = $(this._sliderId + "> .ui-slider-handle");

    /*
 * add slider graphic insite of handle
 */
    sliderHandle.prepend('<div class="slider-handle-graphic sliderbutton-bg"><div class="sliderbutton-fg"></div><div class="sliderbutton-label"></div></div>');
    var sliderHandleBackground = $(sliderHandle).find(".sliderbutton-bg");
    var sliderHandleForground = $(sliderHandle).find(".sliderbutton-fg");
    var sliderHandleLabel = $(sliderHandle).find(".sliderbutton-label");
    sliderHandleLabel.addClass("sprites").addClass(this.sliderButton);

    sliderHandle.mousedown(function () {
        if (sliderHandleBackground.hasClass("sliderbutton-bg"))
            sliderHandleBackground.addClass("sliderbutton-bg-down");
        if (sliderHandleForground.hasClass("sliderbutton-fg"))
            sliderHandleForground.addClass("sliderbutton-fg-down");
    });
    $(document).mouseup(function () {
        if (sliderHandleBackground.hasClass("sliderbutton-bg-down"))
            sliderHandleBackground.removeClass("sliderbutton-bg-down");
        if (sliderHandleForground.hasClass("sliderbutton-fg-down"))
            sliderHandleForground.removeClass("sliderbutton-fg-down");
    });

    /*
     * wraps a div around the handle to set the size
     */
    $(this._sliderId + " > .ui-slider-handle").wrap("<div class='ui-slider-vertical ui-slider-handle-range-size'></div>");


    /*
    * Event Propagation to stop Swiping the Slide when you move the Slider
    */
    $(this._sliderId).mousedown(function (event) {
        event.stopPropagation();
    });

    $(this._sliderId)[0].ontouchstart = function(event) {
        event.stopPropagation();
    };
}


/*
* set the slider Value with  new Values from the Connection
*/
Slider.prototype.setSliderValue = function (val, animate) {
    if (this._inUse && !animate) return;

    var asInt = Round(val, 0);
    if (!isValidValue(asInt))
    {
        asInt = 0;        
        this.setValueText(undefined);
        return;
    }
    var newInt = asInt;
    var value = asInt;
    if (this._valueInvert === true) {
        newInt = this._max - newInt;
    }
	
	this._lastUserVal = value;

    $(this._sliderId).slider('value', newInt);

    if (this._valueText) {
        this.setValueText(value);
    }

    if (animate)
	{
        if (this._animate === false) 
		{
            if (this._target == value)						
                this.animation(value);
        } else {
            // stops the bar animation(s)
            $(this._sliderId + " > .ui-slider-bluebar").stop(1,1);
			$(this._sliderId + " > .ui-slider-stripe-bar").stop(1,1);
            this.animation(value);
        }
    } 
	else 
	{
        $(this._sliderId + " > .ui-slider-bluebar").stop(1,1);
		$(this._sliderId + " > .ui-slider-stripe-bar").stop(1,1);
        $(this._sliderId + " > .ui-slider-blue-bar").css("height", value + "%");
        $(this._sliderId + " > .ui-slider-stripe-bar").css("height", value + "%");		
    }
};


/*
* set the detail id to find the left and right text boxes
*/
Slider.prototype.setDetailId = function (detailId) {
    this.detailId = detailId;
};

/*
* set the text in the text boxes when the slider handle is moved
*/
Slider.prototype.setText = function (value) {
    if (this._valueInvert === true) {
        $(this.detailId + " > ." + this._position + " > .value_text").text(this._max - value);
    }
    else if (this._valueInvert === false) {
        $(this.detailId + " > ." + this._position + " > .value_text").text(value);
    }
};


/*
* set the text in the text boxes when the connection set a new value
*/
Slider.prototype.setValueText = function (value) {

    var valInt = Round(value, 0);
    if (!isValidValue(valInt))
        valInt = '-';
    $(this.detailId + " > ." + this._position + " > .value_text").text(valInt);

};

/*
* starts the slider animation simulation
*/
Slider.prototype.animation = function (value) {	
    var slider = this;
    var currentValue = this._valueInvert === true ? this._max - this._startValue : this._startValue;
    var deltaValue = Math.abs(currentValue - value);
    var animationMs = deltaValue * this._animationSpeed;
    var targetValue = this._valueInvert ? value : this._max - value;
			
    this._animate = true;
		
	var animate_blueBar = (targetValue > currentValue);
	var animate_sripe   = (targetValue < currentValue);
		
	if(animate_blueBar)
	{		
		$(slider._sliderId + " > .ui-slider-bluebar").stop(1,1).animate({
			height: targetValue + "%"
		}, {
			duration :animationMs,
			easing: 'linear',
			done :function () {
				slider._animate = false;
				slider._target = false;								
			}
		});
	}
	
	if(animate_sripe)
	{
		// here we have to use px instead of %, % cause an unexpected error with the stripe-bar's height to be greater then 100%
		$(slider._sliderId + " > .ui-slider-stripe-bar").stop(1,1).animate({
			height: targetValue * slider._sliderHeight / 100 + "px"
		}, {
			duration :animationMs,
			easing: 'linear',
			done :function () {
				slider._animate = false;
				slider._target = false;
			}
		});		
	}
	
};

/**
 * Initializes the slider for blind and shutter absolute templates
 * for key down image and set shadow
 * 
 * @param {String} name Name of the slider used to store in element data
 * @param {String} sliderPosition Positon of the slider (left, right  or center)
 * @param {String} valuePositon Position of the according value display (left or right)
 * @param {String} positionTag Tag for slider positoin telegrams
 * @param {String} positionStateTag Tag for slider position status telegrams
 * @param {String} movementStateTag Tag for the movment state of the actor
 * @param {String} animationSpeed Animation time for a value change of 1
 * @param {String} inUseTimer Time to block the slider for incomming telegrams after user input
 * @param {String} valueText Flag to enable/disbale status value updates
 * @param {String} detailId Id of the detail element comprising the slider
 */
function initSlider(name, sliderPosition, valuePositon, positionTag, positionStateTag, movementStateTag, animationSpeed, inUseTimer, valueText, detailId){
    var slider = new Slider(detailId + " .blindabsolute > .slider_" + sliderPosition, "vertical", 0, 100, positionTag, true, valuePositon,
                      "max", 0, animationSpeed, inUseTimer, valueText);
    var initWithSetpoint = false;

    slider.setDetailId(detailId + " .blindabsolute");
    $(detailId).data(name, slider);
    temporaryCaseSets.push(new CaseSet(positionStateTag, CaseSetType.VALUE).setOnValueFunction(function (value) {
        if (!initWithSetpoint)
        {   
             $(detailId).data(name).setSliderValue( isValidValue(value) ? value : '-');            
        }
        else
        {
            initWithSetpoint = false;
        }
    }));
    if(movementStateTag != '') {
        temporaryCaseSets.push(new CaseSet(movementStateTag, CaseSetType.VALUE).setOnValueFunction(function(value) {
            if(parseInt(value) === 1)
                $(detailId +' .blindabsolute > .movement_symbol').show();
            if (parseInt(value) === 0)
                $(detailId + ' .blindabsolute > .movement_symbol').hide();
        }));

        $(detailId).on('init', function () {
            if (parseInt(ComClient.getTagValue(movementStateTag)) === 1) {
                var setpointValue = ComClient.getTagValue(positionTag);
                    $(detailId).data(name).setSliderValue(setpointValue);
                    initWithSetpoint = true;
                
            }
        });
    }
}