﻿/*global $, globals, onTriggerUp, onTriggerDown, ComClient, registerEventsForTilePressButton, registerEventsForPressButton, setTimeout, fsm*/
/*jslint browser: true*/

/**
 * Eventlistener for scence trigger button
 * mouse and touch events 
 * 
 * @param {type} id id of button
 * @returns {undefined}
 */
function eventsOnSceneTrigger(id, tag) {
    var triggerJQuery = $(id).find('.trigger-button');

    registerEventsForSwipeableElement(triggerJQuery,
        function () {
            onTriggerDown(triggerJQuery);
        },
        function () {
            onTriggerUp(triggerJQuery);
        },
        function () {
            if (!triggerJQuery.find('.ring1').is(':animated')) {
                ComClient.sendTagValue(tag, 1);
                changeSceneTriggerButtonState(id);
            }
        }
    );

}

/**
 * Changes scene trigger button ring animation
 * 
 * @param {type} btn id of the trigger button
 * @returns {undefined}
 */
function changeSceneTriggerButtonState(id) {
    var ring2 = $(id).find('.ring2');

    ring2.clearQueue();

    $(ring2).animate({ opacity: 1 }, globals.scene.glowTime);
    setTimeout(function () { $(ring2).animate({ opacity: 0 }, globals.scene.glowTime); }, globals.scene.glowingTime);
}

/**
 * register event handling for scene trigger button on tiles and led handling
 * 
 * @param {type} tileId id of the scene tile
 * @param {type} tag    communication tag for scene tigger
 * @param {type} on     led sprite class for on state
 * @param {type} off    led sprite class for off state
 * @returns {undefined}
*/
function registerSceneTriggerTile(tileId, tag, on, off) {
    var led = $('#' + tileId).find('.tile-status-led');

    if (!led.has('div').length) {
        led.append("<div class='off sprites " + off + "'></div>");
        led.append("<div class='on sprites " + on + "'></div>");

        led.find('.on').css('opacity', '0');
        led.find('.on').css('position', 'absolute');
        led.find('.off').css('position', 'absolute');
    }
    var ledOn = led.find('.on');

    var button = $('#' + tileId).find('.trigger-button');
    registerEventsForTilePressButton(
        tileId,
        button,
        function () {
            button.attr('onclick', '').unbind('click');
            ComClient.sendTagValue(tag, 1);

            ledOn.clearQueue();
            ledOn.animate({ opacity: 1 }, globals.scene.glowTime);
            setTimeout(function() { ledOn.animate({ opacity: 0 }, globals.scene.glowTime); }, globals.scene.glowingTime);
        });
}

/**
 * register event handling for scene settings button on scene detail
 * 
 * @param {string} id id of the scene detail
*/
function eventOnSceneSettingsButton(id, tag) {
    var setSceneButton = $(id).find('.sceneSettingsBtn');
    registerEventsForPressButton(setSceneButton,
        function () {
            setSceneButton.addClass('down');
        }, function () {
            setSceneButton.removeClass('down');
        }, function () {
            showSceneSettings(id, tag);
        });
}

/**
 * show scene settings with coverflip
 * 
 * @param {string} id id of the scene detail
*/
function showSceneSettings(id, tag) {
    loadView('templates/scene_settings.xhtml',
           function (data) {
               $(id).find('.coverflip-viewsides').append(data);
               setTimeout(function () { coverflipFrontToBack(id, true); }, 0);
               eventOnSceneSettingsEntry(id, '#settingsRow-save', tag);
               initSceneBtns(id);
           });
}

/**
 * init scene settings button
 * 
 * @param {string} id id of the scene settings detail
*/
function initSceneBtns(id) {
    var sceneSettingsBtnEnd = $(id).find('#ok');
    registerEventsForPressButton(sceneSettingsBtnEnd,
       function () {
           sceneSettingsBtnEnd.addClass('down');
       }, function () {
           sceneSettingsBtnEnd.removeClass('down');
       }, function () {
           NavbarController.getInstance().back();
    });
};

/**
 * register event handling for scene settings entry on scene settings detail
 * 
 * @param {string} id id of the scene detail
 * @param {int} tag tagId of scene from config
*/
function eventOnSceneSettingsEntry(detailId, id, tag) {
    var setSceneSettingsEntry = $(detailId).find(id);
    registerEventsForPressButton(setSceneSettingsEntry,
        function () {
            setSceneSettingsEntry.addClass('down');
            setSceneSettingsEntry.find('.flow-top').css('visibility', 'visible');
            setSceneSettingsEntry.find('.settings-row-text.main-menu-text').removeClass('t1sg').addClass('t1ws');
        }, function () {
            setSceneSettingsEntry.find('.settings-row-text.main-menu-text').removeClass('t1ws').addClass('t1sg');
            setSceneSettingsEntry.find('.flow-top').css('visibility', 'hidden');
            setSceneSettingsEntry.removeClass('down');
        }, function () {
            showSaveScenePopup(detailId, tag);
    });
}

/**
* Show a 'are you really sure?' Popup
*
* @param {string} detailId id of the scene detail
* @param {int} tag tagId of scene from config
*/
function showSaveScenePopup(detailId, tag) {

    //build the scene save popup's message
    var name = $(detailId).data('scenename');

    var msg_part1 = window.Gira.appLang.appI18nTexts.msgPart1;
    var msg_part2 = window.Gira.appLang.appI18nTexts.msgPart2;

    fsm.API.SystemMessage.OpenConfirmation(msg_part1 + name + msg_part2,
        function () { /* do related stuff whether OK pressed */
            ComClient.sendTagValue(tag, 1);
            fsm.API.SystemMessage.CloseConfirmation();
        },
        function () { /* do related stuff whether CANCEL pressed */           
            fsm.API.SystemMessage.CloseConfirmation();
        });
    };


