﻿/*global $*/
/*jslint browser: true*/
NavbarController.MAX_HISTORY_SIZE = 10;
NavbarController.instance = null;
NavbarController.getInstance = function () {
    if (!NavbarController.instance) {
        NavbarController.instance = new NavbarController("#navbar", "#btnBack", "#btnHome", "#btnInfo", "#btnSettings", "#btnGridMode", "sprite_36x36_gc4_navicon_back", "sprite_36x36_gc4_navicon_home", "sprite_36x36_gc4_navicon_info", "sprite_36x36_gc4_navicon_set", "sprite_36x36_gc4_navicon_grid");
    }
    return NavbarController.instance;
};


/**
 * NavbarController Constructor
 *
 * @param {array} navbarBtnStatus contains the different button status css classes for sprites use
 * @returns {NavbarController}
 */
function NavbarController(navbarId, btnBackId, btnHomeId, btnInfoId, btnSettingsId, btnGridModeId, btnConfigBack, btnConfigHome, btnConfigInfo, btnConfigSettings, btnConfigGridMode) {
    var navbar = this;
    var btnBack = this;
    var btnHome = this;
    var btnInfo = this;
    var btnSettings = this;
    var btnGridMode = this;
    var self = this,
        I18nTexts = window.Gira.appLang.appI18nTexts;

    var oldTitle = undefined;
    var lastIndex = -1;

    this._history = new Array();
    this._currentLocation = undefined;

    this._helpActive = false;
    this._helpAnimationTime = 1000;
    this._currentViewType = viewTypes.DETAIL;
    this._alternativeViewType = viewTypes.TILE;
    this._openGridMode = false;
    this._firstFunctionOpened = false;

    // buttons ids
    this._navbarID = navbarId;
    this._btnBackId = btnBackId;
    this._btnHomeId = btnHomeId;
    this._btnInfoId = btnInfoId;
    this._btnSettingsId = btnSettingsId;
    this._btnGridModeId = btnGridModeId;
    // the sprites for the buttons
    this._btnConfigBack = btnConfigBack;
    this._btnConfigHome = btnConfigHome;
    this._btnConfigInfo = btnConfigInfo;
    this._btnConfigSettings = btnConfigSettings;
    this._btnConfigGridMode = btnConfigGridMode;

    this._homeButtonDisabled = true;
    this._backButtonDisabled = true;
    this._infoButtonDisabled = false;
    this._settingsButtonDisabled = false;
    this._gridViewButtonDisabled = false;
    this._gridViewButtonWasDisabled = false;

    //holds the current swiper element
    this._swiper;

    this._mainTitle = $('#title').text();

    this._wifiOverlayUID;
    this._primaryFunctionOverlayUID;

    navbar = $(this._navbarID);
    btnBack = navbar.find(this._btnBackId);
    var btnBackSprite = btnBack.find('.btnBackSprite');
    btnHome = navbar.find(this._btnHomeId);
    var btnHomeSprite = btnHome.find('.btnHomeSprite');
    btnInfo = navbar.find(this._btnInfoId);
    var btnInfoSprite = btnInfo.find('.btnInfoSprite');
    btnSettings = navbar.find(this._btnSettingsId);
    var btnSettingsSprite = btnSettings.find('.btnSettingsSprite');
    btnGridMode = navbar.find(this._btnGridModeId);
    var btnGridModeSprite = btnGridMode.find('.btnGridModeSprite');

    this._infoBusy = false;

    this.overlayId = "immovableObject";
    this.isTksOpenend = false;   //flag to determine if the TKS world is opened or not

    this.homeFunction = null;
    this._homescreenType = localStorage["homescreen"] ? localStorage["homescreen"] : 'tile';

    /**
     * Executes the last function on the history stack if it is not empty. Disables
     * the back button if the history stack becomes empty.
     */
    this.back = function () {
        if (this._history.length === 0) return;

        var backAction = this._history.pop();
        backAction.call();

        if (this._history.length === 0) {
            this._disableBackButton();
        }
        this.setHomeButtonState();
    };

    /**
    *  check if homescreen id displayed
    */
    this.setHomeButtonState = function () {
        var tksOnly = ($('head').attr('tksonly') === "true");

        //check if tksOnly Mode
        if (tksOnly) {
            if (fsm.API.SystemMenu.monitor().current === "closed") {
                NavbarController.getInstance()._disableHomeButton();
            } else {
                NavbarController.getInstance()._enableHomeButton();
            }
        }
        // knx mode
        else {
            // settings menu is open
            if (fsm.API.SystemMenu.monitor().current === "poppedUp") {
                NavbarController.getInstance()._enableHomeButton();
            }
            // swiper is loaded
            else if (typeof this._swiper != "undefined") {
                var viewId = this._swiper.params.viewId;
                var slideId = this._swiper.activeIndex;
                if (NavbarController.getInstance().isHomescreenSlideShown(viewId, slideId)) {
                    NavbarController.getInstance()._disableHomeButton();
                } else {
                    NavbarController.getInstance()._enableHomeButton();
                }
            }
        }
    };

    /**
    *  checks for the first slider in top swiper which is defined as homescreentype
    * @param {string} viewId  name of the View
    * @param {string} slideId   name of the slideId
    *
    * @return true if homescreen is found and false if not
    */
    this.isHomescreenSlideShown = function(viewId, slideId) {
        if (slideId === 0 && viewId.indexOf("top") >= 0 && viewId.indexOf(NavbarController.getInstance()._homescreenType) >= 0) {
            return true;
        } else {
            return false;
        }
    };

    /**
    * Clears the history stack and disables the back button.
    */
    this._clearHistory = function () {
        this._history = new Array();
        this._disableBackButton();
    };

    /**
	* set back button's status depending on the history length
	*/
    this._setBackButtonStatus = function () {

        if (this._history.length <= 0) {
            this._disableBackButton();
        } else {
            this._enableBackButton();
        }
    };

    this._addUnclickableOverlay = function () {
        disableTouch = true;
        if ($("#" + this.overlayId).length != 0) return;
        var $overlay = $("<div>", {
            id: this.overlayId,
            style: "position: absolute; top:0; left:0; width: 480px; height:800px; z-index:10000; opacity:1.0;"
        });
        $('body').append($overlay);
    };

    this._removeUnclickableOverlay = function () {
        $("#" + this.overlayId).remove();
        disableTouch = false;
    };
    /**
     * Adds a back function to the history stack.
     * 
     * * @param {type} backFunction Function to be added to the history stack
     */
    this.addBackFunction = function (backFunction) {
        this._history.push(backFunction);
        this._enableHomeButton();
        if (this._history.length === 1) {
            this._enableBackButton();
        }
        if (this._history.length > NavbarController.MAX_HISTORY_SIZE) {
            this._history.splice(0, this._history.length - NavbarController.MAX_HISTORY_SIZE);
        }
    };

    this.removeBackFunction = function (backFunction) {
        var index = this._history.indexOf(backFunction);
        if (index > -1) {
            this._history.splice(index, 1);
        }
        if (this._history.length === 0) {
            this._disableBackButton();
        }
    };


    this.prepareForSlideOut = function () {
        var $copycat = $('body > #pageContent').clone(false);
        $copycat.attr('id', 'animatedContent');
        $copycat.appendTo($('body'));
        $('#animatedContent').addClass('slideOutRight backButtonSlideOut');
        $('.view-container').focus();
    };

    /*
    * This method loads a given "world" page, using the world-change animation for page transition.
    * @param worldLocation the file name containing the html code of the page or the page ID (similar to backButtonLocation)
    * @param backButtonLocation the view ID of a view content located in the hiddenContent part of the page
    * @param onbackFunction an optional function which is executed when the back button is pressed
    * @param usePreloadedContent Falg which indicates if the world content is preloaded and can be selected by its ID
	* @param loadCallback When provided will be called with the parent dom element to which the load can append itself
    */
    this.loadWorld = function (worldLocation, backButtonLocation, onBackFunction, usePreloadedContent, loadCallback) {
        if (this._currentLocation === worldLocation) return;
        this._currentLocation = worldLocation;

        var _this = this;
        var currentTitle = $('#title').text();

         var $worldData;
        _this._addUnclickableOverlay();
        _this._swiper = undefined;
        // load world view either form hidden-content or file
        if (!loadCallback) {
            if (usePreloadedContent) {
                $worldData = $(worldLocation);
            } else {
                $.ajax({
                    url: worldLocation,
                    data: {},
                    cache: false,
                    async: false,
                    success: function (data) {
                        $worldData = $(data);
                    },
                    dataType: 'html'
                });
            }
        }
        var currentView = $('body > #pageContent > #content > .view-container'),
            currentWorld = $('body > #pageContent > #content > .world');
        $("body").css("overflow", "hidden");
		
        //if(!$(currentView).data("swiper")) {
        //    _this.lastIndex = 0;
        //} else {
        //    _this.lastIndex = $(currentView).data("swiper").activeIndex;
        //}

        // clone current view and add it to the body
        var $pageContentOld = $('body > #pageContent').clone(false);
        $pageContentOld.attr('id', 'pageContentOld');
        $('body').append($pageContentOld);

        // unregister case sets of current view
        var viewCaseSets = currentView.data('caseSets');
        if (viewCaseSets !== null && viewCaseSets != undefined) ComClient.unregisterAll(viewCaseSets);

        // move current view to hidden content and add world view content
        currentView.appendTo($('#hidden-content'));
        // remove current "world" if any is loaded
        currentWorld.remove();

        var contentElement = $('body > #pageContent').find('#content');

        if (loadCallback) {
            loadCallback(contentElement);
        } else {
            contentElement.html($worldData);
            //trigger optional event functions
            $worldData.trigger('loadView');
        }

        // change page titel to the world title comprised in the world view
        $('#pageContent #title').text($('#pageContent #world-title').text());

        // disable grid view button while in world view is active
        _this._disableViewButton();
        // set animation classes
        $('#pageContentOld').addClass('changeWorldsAnimationOut');
        $('body > #pageContent').addClass('changeWorldsAnimationIn');
        $('body').addClass('changeWorldsBackground');
        $('#pageContentOld').bind('animationend webkitAnimationEnd', function () {
            _this._removeUnclickableOverlay();
            $('#pageContentOld').remove();
                $('body').removeClass('changeWorldsBackground');
                $('body > #pageContent').removeClass('changeWorldsAnimationIn');
            });
        //do not add back action if we are coming from another "world"(case when we replacing "one world with another")
        // we will use existing one
        if(currentWorld[0] === undefined) {
            this.oldTitle = currentTitle;
            if(!$(currentView).data("swiper")) {
                _this.lastIndex = 0;
            } else {
                _this.lastIndex = $(currentView).data("swiper").activeIndex;
            }
            this.addBackFunction(function () {                
                    // call back for additional actions when navigation out of a world view (e.g. disable camera overlay)
                    if (onBackFunction != undefined) {
                        onBackFunction();
                    }
                    _this._addUnclickableOverlay();
                    _this.prepareForSlideOut();

                $('#title').text(currentTitle);

                _this.loadContainer(backButtonLocation, true, _this.lastIndex, undefined, undefined, undefined, !usePreloadedContent);
                _this._enableViewButton();
                setTimeout(function () {
                    $('#animatedContent').remove();
                    _this._removeUnclickableOverlay();
                }, 800);
            });
        }

        $('.tile .hasDownState, .detail .hasDownState').trigger('touchcancel');
        //this._currentLocation = backButtonLocation;
    };

    this.setHomeFunction = function(callback) {
        this.homeFunction = callback;
    };

    /**
     * Loads a new container and pushes the according back function to the history stack.
     * Unregisters old temporary case sets and registers the new ones.
     * 
     * @param {type} container  url of the container file to load
     * @param {type} back		backFunction Function to be added to the history stack
     * @param {type} index		index of active slide if existing
     * @param {type] isChild	true if the container is opened as child of an other container
     * @param {type] animation	The animation which should be used for the container switch
     * @param {type] backAction	Callback for custom back action
     * @param {type] discardOldContent If set to true the current view is not appended to the hidden content
     */
    this.loadContainer = function (container, back, index, isChild, animation, backAction, discardOldContent) {
        if (container === this._currentLocation) return;

        var _this = this;
        if (this._currentLocation !== undefined && !back) {
            var prevLocation = _this._currentLocation;
            var backIndex = this._swiper.activeIndex;
            this.addBackFunction(function () {
                _this._addUnclickableOverlay();
                //_this.prepareForSlideOut();
                _this.loadContainer(prevLocation, true, backIndex, undefined, animationTypes.BACK);
                if (backAction !== undefined)
                    backAction.call();
            });
        }

        var newView = $(container);
        var currentView = $('body > #pageContent > #content > .view-container');

        var viewCaseSets = currentView.data('caseSets');
        if (viewCaseSets !== null && viewCaseSets != undefined) ComClient.unregisterAll(viewCaseSets);

        $("body >  #pageContent >  #content").append(newView);
        var newSwiper = newView.data("swiper");
        if (newSwiper) {
            index = index ? index : 0;
            newSwiper.swipeTo(index);
        }

        switch (animation) {
            case animationTypes.FADE_IN:
                {
                    newView.addClass('fadeIn fadeIn-animation');
                    this._addUnclickableOverlay();
                    newView.bind('animationend webkitAnimationEnd', function () {
                        $('#hidden-content').append(currentView);
                        _this._removeUnclickableOverlay();
                        newView.removeClass('fadeIn fadeIn-animation');
                        newView.unbind('animationend webkitAnimationEnd');
                    });
                }
                break;
            case animationTypes.COVER_ZOOM:
                {
                    newView.addClass('fadeIn coverZoom-animation');
                    $(newView.find('.swiper-slide')[index]).addClass('scaleIn coverZoom-animation');
                    this._addUnclickableOverlay();
                    newView.bind('animationend webkitAnimationEnd', function () {
                        $('#hidden-content').append(currentView);
                        _this._removeUnclickableOverlay();
                        newView.removeClass('fadeIn coverZoom-animation');
                        $(newView.find('.swiper-slide')[index]).removeClass('scaleIn coverZoom-animation');
                        newView.unbind('animationend webkitAnimationEnd');
                    });
                }
                break;
            case animationTypes.BACK:
                {
                    var $animatedContent = $("<div>", { id: 'animatedContent' });
                    $animatedContent.append($('#statusbar, #branding-row, #navbar').clone(false));
                    var $content = $("<div>", { id: 'content' });
                    $content.append(currentView);
                    $animatedContent.append($content);
                    $animatedContent.appendTo($('body'));
                    $("body >  #pageContent > #content").children().not(newView).remove();
                    $('.view-container').focus();
                    $animatedContent.addClass('slideOutRight backButtonSlideOut');
                    $animatedContent.bind('animationend webkitAnimationEnd', function () {
                        $('#hidden-content').append(currentView);
                        $animatedContent.remove();
                        _this._removeUnclickableOverlay();
                        $animatedContent.unbind('animationend webkitAnimationEnd');
                    });
                }
                break;
            default:
                {
                    if (!discardOldContent) {
                        $('#hidden-content').append(currentView);
                    }
                    $("body >  #pageContent > #content").children().not(newView).remove();
                }
        }

        newView.trigger('loadView');
        newView.find('.tile').trigger('loadTile');
        newView.find('.detail, .tile').trigger('init');
        this._currentLocation = container;

        if (!back) {
            newView.data('wasSwiped', false);
        }


        /* register temporaryCaseSets on content change */
        viewCaseSets = $(container).data('caseSets');
        if (viewCaseSets !== null && viewCaseSets != undefined) {
            ComClient.registerAll(viewCaseSets);
        }
        /* Fix for persistent down effect after view change */
        currentView.find('.hasDownState').trigger('touchcancel');
        $('#navbar > div').trigger('touchcancel');
        this.setHomeButtonState();
    };

    /**
     * Dummy function for determining the help page context. Currently alwas returns
     * path to static.xhtml.
     * 
     * @returns {String} Path to the info overlay which has to be displayed for the current context.
     */
    this.determineInfoContext = function () {
        var en = getHTTPGetParameters('locale') === 'en-US';
        if (en) {
            return 'templates/help/static_en.xhtml';
        } else {
            return 'templates/help/static.xhtml';
        }
    };

    /**
     * A.Bratfisch:
     * Disable the info button, needed by TKS:
     * If a call is incoming and the user presses the info button, it is possible the fucking
     * camera overly is on top of the help view because at this point we dont know if we use a 
     * camera. Disable this button until the camera can be handled by TKS view.
     */
    // this.setInfoDisabled = function (disabled) {
    //     this._btnInfo_locked = disabled ? true : false;
    // };

    /**
     * Opens the help page for the current context.
     */
    this.openInfo = function () {
        var _this = this;

        _this.__infoBusy = true;

        this._gridViewButtonWasDisabled = this._gridViewButtonDisabled;
        this._disableViewButton();

        this._disableSettingsButton();

        if (_this._helpActive == true) {
            console.log("Info already active");
            _this.__infoBusy = false;
            return;
        }

        var url = NavbarController.getInstance().determineInfoContext();
        /* load and set new content*/
        $.ajax({
            url: url,
            data: {},
            cache: false,
            async: false,
            success: function (data) {
                $("body >  #pageContent > #content").append($(data));
                btnInfoSprite.removeClass(_this._btnConfigInfo);
                btnInfoSprite.addClass(_this._btnConfigInfo + "_active");
                btnInfo.addClass("active");
                _this._helpActive = true;
            },
            dataType: 'html'
        });

        var anmc = $('#animatedHelpContent');
        var dscr = $("#description-row");
        var idsc = $("#info-description-row");

        dscr.stop(true);
        idsc.stop(true);

        idsc.css("opacity", "0");
        dscr.animate({ opacity: "0" }, this._helpAnimationTime);
        idsc.animate({ opacity: "1" }, this._helpAnimationTime);
        anmc.addClass("slideInFromBottom-infoAnimation");
        anmc.removeClass("slideOutFromBottom-infoAnimation");
        _this.__infoBusy = false;
    };

    /**
     * Closes the info overlay.
     
     * @param {type} delayedFnc 
     *				A Function called after info animation has ended
     * @returns {Boolean} False if there was no overlay to close, true otherwise
     */

    this.closeInfo = function (delayedFnc) {
        var _this = this;
        _this.__infoBusy = true;
        var popup = $('#info-overlay');
        if (popup[0] === undefined) {
            _this.__infoBusy = false;
            return false;
        }
        else {
            var anmc = $('#animatedHelpContent');
            var dscr = $("#description-row");
            var idsc = $("#info-description-row");

            anmc.addClass("slideOutFromBottom-infoAnimation");
            anmc.removeClass("slideInFromBottom-infoAnimation");
            dscr.stop(true);
            idsc.stop(true);

            setTimeout(function () {
                $('#info-overlay').remove();
                btnInfo.removeClass("active");
                btnInfoSprite.removeClass(_this._btnConfigInfo + "_active");
                btnInfoSprite.addClass(_this._btnConfigInfo);

                NavbarController.getInstance()._helpActive = false;

                if (delayedFnc) {
                    delayedFnc.call();
                }

                //enable grid button
                if (!_this._gridViewButtonWasDisabled) {
                    _this._enableViewButton();
                }
                //enable settings button 
                _this._enableSettingsButton();
                _this.__infoBusy = false;
            }, 1000);

            dscr.animate({ opacity: "1" }, this._helpAnimationTime);
            idsc.animate({ opacity: "0" }, this._helpAnimationTime);

            return true;
        }
    };

    /**
     * Toggles the info overlay.
     * Pushes functions to revert toggel to the history stack
     */
    this.toggleInfo = function () {
        var _this = this;

        // A.B.: Set by TKS to prevent help gets opened under camera overlay.
        if (this._btnInfo_locked) return;

        if (_this.__infoBusy || this._infoButtonDisabled) return;
        _this.__infoBusy = true;

        if (this._helpActive) {
            _this.back();
        }
        else {
            _this.openInfo();
            _this.addBackFunction(function () { _this.closeInfo(); });
        }
    };
    /**
    * Sets the icon of the home button to disabled and
    * unregisters event handlers.
    */
    this._disableHomeButton = function () {
        btnHomeSprite.removeClass(this._btnConfigHome);
        btnHomeSprite.addClass(this._btnConfigHome + "_inactive");
        this._homeButtonDisabled = true;
    };

    /**
    * Sets the icon of the back button to enabled and
    * registers event handlers.
    */
    this._enableHomeButton = function () {
        btnHomeSprite.removeClass(this._btnConfigHome + "_inactive");
        btnHomeSprite.addClass(this._btnConfigHome);
        this._homeButtonDisabled = false;
    };
    /**
    * Sets the icon of the back button to disabled and
    * unregisters event handlers.
    */
    this._disableBackButton = function () {
        btnBackSprite.removeClass(this._btnConfigBack);
        btnBackSprite.addClass(this._btnConfigBack + "_inactive");
        this._backButtonDisabled = true;

    };

    /**
    * Sets the icon of the back button to enabled and
    * registers event handlers.
    */
    this._enableBackButton = function () {
        btnBackSprite.removeClass(this._btnConfigBack + "_inactive");
        btnBackSprite.addClass(this._btnConfigBack);
        this._backButtonDisabled = false;
    };

    /**
    * Sets the icon of the info button to disabled and
    * unregisters event handlers.
    */
    this._disableInfoButton = function () {
        btnInfoSprite.removeClass(this._btnConfigInfo);
        btnInfoSprite.addClass(this._btnConfigInfo + "_inactive");
        this._infoButtonDisabled = true;

    };

    /**
    * Sets the icon of the info button to enabled and
    * registers event handlers.
    */
    this._enableInfoButton = function () {
        btnInfoSprite.removeClass(this._btnConfigInfo + "_inactive");
        btnInfoSprite.addClass(this._btnConfigInfo);
        this._infoButtonDisabled = false;
    };


    /*
    * Sets the settings-button to inactive (normal white color)
    */
    this._disableSettingsButton = function () {
        btnSettings.removeClass("active");
        btnSettingsSprite.removeClass(this._btnConfigSettings + "_active");
        btnSettingsSprite.addClass(this._btnConfigSettings);
    };

    /*
    * Sets the settings-button to active (green color)
    */
    this._enableSettingsButton = function () {
        btnSettingsSprite.removeClass(this._btnConfigSettings);
        btnSettingsSprite.addClass(this._btnConfigSettings + "_active");
        btnSettings.addClass("active");
    };

    /**
     * Toggles between tile- and detailview and sets the state of the grid button accordingly.
     * Always loades the tile viwe slide which comprises the currently displayed detail view element.
     * The displayed detail view slide is either determined by the last displayed detail view element
     * or the first tile view element of the current slide.
     */
    this.openGridMode = function () {
        if (!this._openGridMode && !this._gridViewButtonDisabled) {

            //in info overlay active delay mode change until info is closed
            if (this._helpActive) {
                var _this = this;
                this.closeInfo(function () { _this.openGridMode(); });
                this.addBackFunction(function () { _this.openInfo(); });
                return;
            }

            this._openGridMode = true;
            var newLocation, index, newViewType;
            var $currentLocation = $(this._currentLocation);
            if (this._currentViewType === viewTypes.DETAIL) {
                newLocation = this._currentLocation.replace(viewTypes.DETAIL, this._alternativeViewType);
                newViewType = this._alternativeViewType;
                var targetTileId = '#' + $('#content .swiper-slide-active .detail')[0].id.replace(viewTypes.DETAIL, this._alternativeViewType);
                var targetSlide = $(targetTileId).parents('.swiper-slide');
                index = $(newLocation + ' .swiper-slide').index(targetSlide);
                $(newLocation).data('lastDetailIndex', this._swiper.activeIndex);
                this._lastDetailAlternativeElement = targetTileId;
            } else {
                newLocation = this._currentLocation.replace(this._alternativeViewType, viewTypes.DETAIL);
                newViewType = viewTypes.DETAIL;
                if ($currentLocation.data('wasSwiped')) {
                    index = $('#content .tile').index($('#content .swiper-slide-active .tile'));
                } else {
                    index = $currentLocation.data('lastDetailIndex');
                }
            }

            var _this = this;
            var backViewType = this._currentViewType;
            this.loadContainer(newLocation, false, index, false, animationTypes.FADE_IN, function () {
                _this._setViewType(backViewType);
            });

            this._setViewType(newViewType);
            this._openGridMode = false;
        }
    };

    this.openFirstFunction = function () {
        if (!this._homeButtonDisabled) {
            var _this = this;

            //the tks-only (Door communication system only) flag determines whether the app runs in the special DCS-only mode
            var tksOnly = ($('head').attr('tksonly') === "true");
            // remove case setes of current view
            var currentView = $('body > #pageContent > #content > .view-container');
            /* unregister viewCaseSets */
            var viewCaseSets = currentView.data('caseSets');
            if (viewCaseSets !== null && viewCaseSets != undefined) ComClient.unregisterAll(viewCaseSets);

            /* unregister settingsCaseSets */
            if (settingsCaseSets !== null && settingsCaseSets != undefined) {
                ComClient.unregisterAll(settingsCaseSets);
                settingsCaseSets = [];
            }

            var target = $('#content');
            target.addClass('fadeOut home-animation');
            this._addUnclickableOverlay();
            target.bind('animationend webkitAnimationEnd', function () {
                if (!tksOnly) {
                    $('#hidden-content').append(currentView);
                    $('body > #pageContent > #content').children().remove();
                } else {
                    //the DCS content is always visible in DCS-only mode
                    $('body > #pageContent > #content').children().not('#tks-view').remove();
                }                
                _this._removeUnclickableOverlay();

                target.removeClass('fadeOut home-animation');
                target.unbind('animationend webkitAnimationEnd');

                _this._resetButtons();
                _this._disableHomeButton();
                _this._clearHistory();
                _this._currentLocation = 'home';
                $('#title').text(_this.oldTitle);

                if (!tksOnly) {
                    //there is no swiper in DCS-only mode
                    var slideIndex;
                    if (_this._currentViewType === viewTypes.DETAIL) {
                        slideIndex = $('#content .swiper-slide-active').index();
                    } else {
                        slideIndex = 0;
                    }
                }

                _this.loadHomescreen(animationTypes.FADE_IN);
                $(_this._currentLocation).data('lastDetailIndex', slideIndex);

                // notify listeners for homebutton-pressed event
                $("body").trigger('homeButtonPressed');
                /* close settings menu */
                if (fsm.API.SystemMenu.monitor().current == 'poppedUp') {
                    fsm.API.SystemMenu.Close();
                    NavbarController.getInstance().setHomeButtonState();
                }
            });
        }
    };

    this._restoreHomeState = function (tksOnly) {
        var slideIndex = 0;

        this._resetButtons();
        this._clearHistory();
        this._currentLocation = 'home';
        $('#title').text(this.oldTitle);

        if (!tksOnly) {
            //there is no swiper in DCS-only mode
            if (this._currentViewType === viewTypes.DETAIL) {
                slideIndex = $('#content .swiper-slide-active').index();
            }
        }

        this.loadHomescreen(animationTypes.FADE_IN);
        $(this._currentLocation).data('lastDetailIndex', slideIndex);

        // notify listeners for homebutton-pressed event
        $("body").trigger('homeButtonPressed');

    };

    /**
     * Loads the currently configured homescreen or detail-view-top by default.
     *
     * @param {int} animation Animation type for loading the home view
     */
    this.loadHomescreen = function(animation) {
        this._homescreenType = localStorage["homescreen"] ? localStorage["homescreen"] : 'tile';
        //TKS only mode is determined in SVP generator; the generator sets the header attribute tksonly == true / false
        var tksOnly = ($('head').attr('tksonly') === "true");
        if (tksOnly) {
            $('#pageContent #title').text(I18nTexts.langBrandingDCS);
            if ($('#content').attr('data-bind') == undefined) {
                $('#content').attr('data-bind', 'template: {name: \"dcs-template\"}');
                //because of the dynamic nature of the DCS system, we need to wait until all includes etc. are loaded 
                window.setTimeout(function () {
                    window.Gira.DCS.Bootstrapper.rebindTo($('#content'));
                    window.Gira.DCS.Controller.Tile.isAlwaysOpen();
                }, 1000);
            }
            this._disableViewButton();
        } else {
            var homescreen = "#" + this._homescreenType + "-view-top";
            this.loadContainer(homescreen, true, 0, false, animation);
            this._setViewType(viewTypes[this._homescreenType.toUpperCase()]);
            var swiperChildren = $('.swiper-wrapper').children()[0];
            // GAPP-2636 deactivate grid button when generating without a configfile
            if (swiperChildren == undefined) {
                this._disableViewButton();
            }
        }
    };

    /**
     * Sets the current view type state and changes the grid button icon accordingly.
     * 
     * @param {type} newViewType New view type state
     */
    this._setViewType = function (newViewType) {
        if (newViewType === viewTypes.DETAIL) {
            btnGridModeSprite.addClass(this._btnConfigGridMode);
            btnGridModeSprite.removeClass(this._btnConfigGridMode + "_active");
            btnGridMode.removeClass("active");
        } else {
            btnGridModeSprite.removeClass(this._btnConfigGridMode);
            btnGridModeSprite.addClass(this._btnConfigGridMode + "_active");
            btnGridMode.addClass("active");
        }
        this._currentViewType = newViewType;
    };

    /**
    * Sets the icon of the grid view button to disabled and removes events.
    */
    this._disableViewButton = function () {

        if (this._currentViewType === viewTypes.DETAIL) {
            btnGridModeSprite.removeClass(this._btnConfigGridMode);
        } else {
            btnGridModeSprite.removeClass(this._btnConfigGridMode + "_active");
            btnGridMode.removeClass("active");
        }
        btnGridModeSprite.addClass(this._btnConfigGridMode + "_inactive");
        this._gridViewButtonDisabled = true;
    };

    /**
    * Sets the icon of the grid view button to the current view type and
    * registers event handlers.
    */
    this._enableViewButton = function () {

        if (btnGridModeSprite.hasClass(this._btnConfigGridMode + "_inactive")) {
            btnGridModeSprite.removeClass(this._btnConfigGridMode + "_inactive");
            if (this._currentViewType === viewTypes.DETAIL) {
                btnGridModeSprite.addClass(this._btnConfigGridMode);
            } else {
                btnGridModeSprite.addClass(this._btnConfigGridMode + "_active");
                btnGridMode.addClass("active");
            }
            this._gridViewButtonDisabled = false;
        }
    };

    /**
    * Resets info, setings and gridMode buttons and the according states
    **/
    this._resetButtons = function () {
        btnSettings.removeClass("active");
        btnSettingsSprite.removeClass(this._btnConfigSettings + "_active");
        btnSettingsSprite.removeClass(this._btnConfigSettings + "_inactive");
        btnSettingsSprite.addClass(this._btnConfigSettings);

        btnInfo.removeClass("active");
        btnInfoSprite.removeClass(this._btnConfigInfo + "_active");
        btnInfoSprite.removeClass(this._btnConfigInfo + "_inactive");
        btnInfoSprite.addClass(this._btnConfigInfo);

        btnGridMode.removeClass("active");
        btnGridModeSprite.removeClass(this._btnConfigGridMode + "_active");
        btnGridModeSprite.removeClass(this._btnConfigGridMode + "_inactive");
        btnGridModeSprite.addClass(this._btnConfigGridMode);

        this._infoButtonDisabled = false;
        this._settingsButtonDisabled = false;
        this._gridViewButtonDisabled = false;
        this._helpActive = false;
        this.__infoBusy = false;
    };

    /**
     * Opens the detail view element for the specified tile.
     * 
     * @param {type} tileElement DOM element of the tile which was clicked
     */
    this.openDetailElement = function (tileElement) {
        var index = $('#content .tile').index($(tileElement));
        var newLocation = this._currentLocation.replace(this._alternativeViewType, viewTypes.DETAIL);
        var _this = this;
        var backViewType = this._currentViewType;
        this.loadContainer(newLocation, false, index, false, animationTypes.COVER_ZOOM, function () {
            _this._setViewType(backViewType);
        });
        this._setViewType(viewTypes.DETAIL);
    };

    // Callback function executed when settings menu is closed by home or menu button
    var leaveSettingsConfirmation = undefined;

    /**
     * Sets the leaveSettingsHandler
     *
     * @param {function} leaveSettingsHandler Callback executed when settings menu is closed by home or menu button
     */
    this.setLeaveSettingsConfirmation = function (leaveSettingsHandler) {
        leaveSettingsConfirmation = leaveSettingsHandler;
    };


    /**
     * Removes the current leaveSettingsHandler
     */
    this.removeLeaveSettingsConfirmation = function () {
        leaveSettingsConfirmation = undefined;
    };

    /**
     * Executes a callback function if no leaveSettingsConfirmation is set or if it returns true
     *
     * @param {function} callback Function which shall be executed
     */
    this.confirm = function (callback) {
        if (leaveSettingsConfirmation) {
            leaveSettingsConfirmation(function(result) {
                if (result) {
                    callback();
                    self.removeLeaveSettingsConfirmation();
                }
            });
        } else {
            callback();
        }
    };

    this.getHistoryLength = function() {
        return this._history.length;
    };

    /*
    * Clears the history entries starting at the given index
    */
    this.clearHistoryFromIndexToEnd = function(historyIndex) {
        for (var i = this._history.length - historyIndex; i >= 0; i--) {
            this._history.pop();
        }
        this._setBackButtonStatus();
    };

    /**
    * Registers event handlers for the down effect for navbar buttons.
    */
    this.eventsOnBtn = function (btnJQuery, disabledState, clickFunction) {
        var _this = this;
        registerEventsBase(btnJQuery, function() {
             if (!_this[disabledState]) btnJQuery.addClass('down');
        }, function () { btnJQuery.removeClass('down'); }, clickFunction,
        { stopPropagation: true, ignoreY: false, callUpFunction4TouchMove: true, callClickAction4TouchEnd: true });
    };

    // Register events on navigation bar buttons
    this.eventsOnBtn(btnBack, '_backButtonDisabled', this.back.bind(this));
    this.eventsOnBtn(btnHome, '_homeButtonDisabled',
        function() {
             if (self.homeFunction != null && self.homeFunction != undefined) {
                 self.homeFunction();
                 self.homeFunction = undefined;
             }
             self.confirm(self.openFirstFunction.bind(self));
        });
    this.eventsOnBtn(btnInfo, '_infoButtonDisabled', this.toggleInfo.bind(this));
    this.eventsOnBtn(btnSettings, '_settingsButtonDisabled', function () { 
        self.confirm(NavbarSettingsButton.toggleSettings);
    });
    this.eventsOnBtn(btnGridMode, '_gridViewButtonDisabled', this.openGridMode.bind(this));

    fsm.API.SystemMenu.Init(NavbarSettingsButton.openSettings, NavbarSettingsButton.closeSettings);
}

/**
 * @enum view types
 */
viewTypes = {
    DETAIL: 'detail',
    TILE: 'tile',
    LIST: 'list'
};

/**
 * @enum supported connection events
 */
animationTypes = {
    NONE: 0,
    FADE_IN: 1,
    COVER_ZOOM: 2,
    BACK: 3
};

var disableTouch = false;
