﻿/*global $, NavbarController, ComClient, fsm*/
/*jslint browser: true*/

var NavbarSettingsButton = (function () {

    var module = {};
    var historySettingsStartIndex = null;
    /**
     * Closes the settings overlay.
     *
     * @param {type} delayedFnc 
     *              A Function called after settings animation has ended
     * @returns {Boolean} False if there was no overlay to close, true otherwise
     */
    module.closeSettings = function (hardClose) {
        var navbarController = NavbarController.getInstance();
        navbarController.removeLeaveSettingsConfirmation();

        var popup = $('#settings-overlay');
        if (popup[0] === undefined) {
            return false;
        } else {
            navbarController._addUnclickableOverlay();
            var anmc = $('#settings-overlay');
            if (hardClose) {
                anmc.addClass("fadeOut-settingsAnimation");
            } else {
                anmc.addClass("slideOutFromBottom-settingsAnimation");
            }
            anmc.removeClass("slideInFromBottom-settingsAnimation");

            if (hardClose) {
                module.cleanup();
            } else {
                //wait for animation
                setTimeout(module.cleanup, 1000);
            }
        }
        return true;
    };

    /*
 * Several cleanup calls when the settings menu is closed
     */
    module.cleanup = function () {
        var navbarController = NavbarController.getInstance();
        $('#settings-overlay').remove();
        navbarController._removeUnclickableOverlay();
        NavbarController.getInstance().clearHistoryFromIndexToEnd(historySettingsStartIndex);
        $('.menuPage').remove();

        if (!navbarController._gridViewButtonWasDisabled) {
            navbarController._enableViewButton();
        }
        navbarController._enableInfoButton();
        navbarController._disableSettingsButton();

        /* unregister settingsCaseSets */
        if (settingsCaseSets !== null && settingsCaseSets != undefined) {
            ComClient.unregisterAll(settingsCaseSets);
            settingsCaseSets = [];
        }
        navbarController.setHomeButtonState();
    };

    /**
     * Opens the settings page.
     */
    module.openSettings = function () {
        var navbarController = NavbarController.getInstance();
        navbarController._gridViewButtonWasDisabled = navbarController._gridViewButtonDisabled;
        navbarController._disableViewButton();
        navbarController._addUnclickableOverlay();
        navbarController.addBackFunction(function () { fsm.API.SystemMenu.Close(); });
        historySettingsStartIndex = navbarController.getHistoryLength();
        var url = "templates/settings/settings.xhtml";
        /* load and set new content*/
        $.ajax({
            url: url,
            data: {},
            cache: false,
            async: false,
            success: function (data) {
                $("body >  #pageContent > #content").append($(data));
                NavbarController.getInstance()._enableSettingsButton();
            },
            dataType: 'html'
        });

        /* register settingsCaseSets */
        settingsCaseSets = $('.menuPage').data('caseSets');
        if (settingsCaseSets !== null && settingsCaseSets != undefined) {
            ComClient.registerAll(settingsCaseSets);
        }

        navbarController._disableInfoButton();
        var anmc = $('#settings-overlay');
        anmc.addClass("slideInFromBottom-settingsAnimation");
        anmc.one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function () {
            navbarController._removeUnclickableOverlay();
        });
        if (anmc.hasClass("fadeOut-settingsAnimation")) {
            anmc.removeClass("fadeOut-settingsAnimation");
        } else {
            anmc.removeClass("slideOutFromBottom-settingsAnimation");
        }
        return true;
    };

    /**
     * Toggles the settings overlay.
     * Pushes functions to revert toggle to the history stack
     */
    module.toggleSettings = function () {
        if (fsm.API.SystemMenu.monitor().current == 'poppedUp') {
            fsm.API.SystemMenu.Close();
        } else {
            fsm.API.SystemMenu.Open();
        }
    };

    return module;
}());