﻿/*global $, tsx, ComClient, jQuery, moment, getHTTPGetParameters, temporaryCaseSets*/
/*jslint browser: true*/

/**
 * Sets the time in the statusbar with local format
 * Uses regular expression to get HH:MM am/pm
 */
function getClock() {
    var time = moment().format(window.Gira.dateTimeFormatsModel.getTimeFormat());
    tsx.StatusbarController.time(time);
    /*
     var timeRequest = {"request": {"command": "GetValue", "urn": "urn:gds:dp:GIG1LXKXIP.General:GDS-Device-Channel:Local-Time"}};
    gds$.request(timeRequest, function (response) {
        var time = moment(response.value).format(window.Gira.dateTimeFormatsModel.getTimeFormat());
        tsx.StatusbarController.time(time);
    });*/
}

/**
 * Sets the date in the statusbar with local format 
 */
function getDate() {
    var localDate = moment().format(window.Gira.dateTimeFormatsModel.getDateFormat());
    tsx.StatusbarController.date(localDate);
}

//  is a object a valid array
function isValidArray(object) {
    return object != null && typeof object === "object" &&
        'splice' in object && 'join' in object;
}

function isValidString(value) {
    if (value === undefined || value === "") {
        return false;
    }
    return true;
}

function isValidValue(value) {
    return ( value !== "" && value !== undefined && !isNaN(value) ) ? true : false;
}

/**
 * Returns the formated temperature

 * @returns {String}
 *           formatted temperature value
*/
function formatTemperatureValue(value) {
    var returnValue = 0;
    if (!isValidValue(value)) {
        returnValue = "--.- °C";
    } else {
        returnValue = parseFloat(value).toFixed(1) + " °C";
    }

    return returnValue;
}

/**
 * Returns time-difference in milliseconds
 *
 * @param {Date} startDate
 *          time at start
 * @param {Date} stopDate
 *          time at stop
 *
 * @returns time difference between startDate and endDate
 */
function getTime_Difference_Milliseconds(startDate, stopDate) {
    var diffTime = 0,
        startTime,
        stopTime;

    if ((startDate !== null) && (stopDate !== null)) {
        startTime = startDate.getTime();
        stopTime = stopDate.getTime();
        if (stopTime - startTime) {
            diffTime = (stopTime - startTime);
        }
    }
    return diffTime;
}

/**
 * Gets the connection information either from the URL parameters 
 * or the local browser storage
 * 
 * @returns Dictionary with the connection information
 */
function getConnectionInfo() {
    var connectionInfo = {  //
            ip: '', //
            port: '', //
            login: '', //
            password: '', //
            tks_proxy_ip: '', //
            tks_proxy_port: '', //
            tks_proxy_login: '', //
            tks_proxy_password: '', //
            tks_gw_ip: '', //
            tks_gw_login: '',  //
            tks_gw_password: ''
        },
        entry;
    for (entry in connectionInfo) {
        if (getHTTPGetParameters(entry) !== 'undefined') {
            localStorage[entry] = getHTTPGetParameters(entry);
        }
        connectionInfo[entry] = localStorage[entry];
    }

    if (!connectionInfo['ip']) {
        connectionInfo['ip'] = 'localhost';
    }

    return connectionInfo;
}

/**
 * change sprite_XYZ class of element to sprite_XYZ_down
 * for key down image
 * 
 * @param {type} element
 * @returns {undefined}
 */
function spriteDown(element) {
    if (element !== undefined && $(element).hasClass("sprites")) {
        var cName = element.className;
        var sprite = cName.match(/sprite_\S*\s?/g);
        if (sprite !== null && sprite[0].match("_down") === null) {
            sprite = sprite[0].trim();
            var spriteNew = sprite + "_down";
            element.className = cName.replace(sprite, spriteNew);
        }
    }
}

/**  
 * change sprite_XYZ_down class of element to sprite_XYZ
 * for key down image
 * 
 * @param {type} element
 * @returns {undefined}
 */
function spriteUp(element) {
    if (element !== undefined && $(element).hasClass("sprites")) {
        var cName = element.className,
            sprite = cName.match(/sprite_\S*\s?/g),
            spriteNew;
        if (sprite !== null) {
            sprite = sprite[0].trim();
            spriteNew = sprite.replace("_down", "");
            element.className = cName.replace(sprite, spriteNew);
        }
    }
}

/**
 * Checks if the value is outside the 
 * min - max interval
 */
function valueInRange(min, max, value) {
    if ((value >= min) && (value <= max)) {
        return true;
    }
    return false;
}

/**
* Adds source url's content to parent element.
* @param {type} url to the resource
* @param {type} parent parent element
* @param {type} isAsync execute asynchronous or synchronous
**/
function appendFromUrl(url, parent, isAsync) {
    $.ajax({
        url: url,
        data: {},
        cache: false,
        async: isAsync,
        success: function (data) {
            try {
                parent.append(data);
            } catch (e) {
                console.error('error in preloaded file ' + url);
                throw e;
            }
        },
        dataType: 'html'
    });
}

/**
 * Adds a container to the hidden content of the page
 * @param {type} container Path to the file which should be loaded
 **/
function preloadContainer(container) {
    appendFromUrl(container, $("#hidden-content"), false);
}

/**
* Registers events base method.
*
* @param {type} element JQuery element for which the events are registered
* @param {type} downFunction Callback for down effects
* @param {type} upFunction Callback for up effects
* @param {type} clickAction Callback for the click action
* @param {configuration} stopPropagation for onclick, ignoreY, callUpFunction4TouchMove, callClickAction4TouchEnd, clickDelay
**/
function registerEventsBase(element, downFunction, upFunction, clickAction, configuration) {
    element.addClass('hasDownState');
    if (!("ontouchstart" in document.documentElement) || navigator.userAgent === 'Selenium') {
        element.mousedown(function (e) {
            if (configuration.stopPropagation) e.stopPropagation();

            var startX = e.screenX;
            var startY = e.screenY;
            var id = setTimeout(function () {
                element.off('touchmove');
                element.data('active', true);
                element.data('screenX', startX);
                element.data('screenY', startY);
                if (downFunction) downFunction.call(null, e);
            }, configuration.clickDelay);
            element.mousemove(function (event) {
                if ((Math.abs(event.screenX - startX) > globals.general.downAbortDistance) || (!configuration.ignoreY && (Math.abs(event.screenY - startY) > globals.general.downAbortDistance))) {
                    if (configuration.callUpFunction4TouchMove && upFunction) upFunction.call();
                    clearTimeout(id);
                    element.off('mousemove');
                }
            });
        });
        element.mouseup(function (e) {
            setTimeout(function () {
                if (upFunction) upFunction.call();
                if (configuration.callClickAction4TouchEnd) {
                    if (element.data('active')) {
                        if (Math.abs(element.data('screenX') - e.screenX) <= globals.general.clickAbortDistance)
                            if(clickAction)clickAction.call();
                        element.data('active', false);
                    }
                }
            }, configuration.clickDelay);
        });
        if (!configuration.callClickAction4TouchEnd) {
            element[0].onclick = function (e) {
                if (configuration.stopPropagation) e.stopPropagation();
                setTimeout(function () {
                    if (clickAction) clickAction.call();
                }, configuration.clickDelay);
            };
        }
        element.mouseleave(function (e) {
            setTimeout(function () {
                element.data('active', false);
                if (upFunction) upFunction.call();
            }, configuration.clickDelay);
        });
    } else if (element[0]) {
        element[0].ontouchstart = function (e) {
            if (configuration.stopPropagation) e.stopPropagation();
            var startX = e.touches[0].screenX;
            var startY = e.touches[0].screenY;
            var id = setTimeout(function () {
                element.off('touchmove');
                element.data('active', true);
                element.data('screenX', startX);
                element.data('screenY', startY);
                if (downFunction) downFunction.call(null, e);
            }, configuration.clickDelay);

            element[0].ontouchmove = function (event) {
                if ((Math.abs(event.touches[0].screenX - startX) > globals.general.downAbortDistance) || (!configuration.ignoreY && (Math.abs(event.touches[0].screenY - startY) > globals.general.downAbortDistance))) {
                    if (configuration.callUpFunction4TouchMove && upFunction) {
                        element.data('active', false);
                        upFunction.call();
                    }
                    clearTimeout(id);
                    element.off('touchmove');
                }
            };
        };
        element[0].ontouchend = function (e) {
            setTimeout(function () {
                if (upFunction) upFunction.call();
                if (configuration.callClickAction4TouchEnd) {
                    if (element.data('active')) {
                        if (Math.abs(element.data('screenX') - e.changedTouches[0].screenX) <= globals.general.clickAbortDistance && Math.abs(element.data('screenY') - e.changedTouches[0].screenY) <= globals.general.clickAbortDistance)
                            if (clickAction) clickAction.call();
                        element.data('active', false);
                    }
                }
            }, configuration.clickDelay);
        };
        if (!configuration.callClickAction4TouchEnd) {
            element[0].onclick = function (e) {
                if (configuration.stopPropagation) e.stopPropagation();
                setTimeout(function () {
                    if (clickAction) clickAction.call();
                }, configuration.clickDelay);
            };
        }
        element[0].ontouchcancel = function () {
            setTimeout(function () {
                element.data('active', false);
                if (upFunction) upFunction.call();
            }, configuration.clickDelay);
        };
    }
}

/**
 * Registers events for swipeable elements. The down function is not executed on swipe gestures.
 * The click action is not executed if a swipe was performed between the up and down events.
 *
 * @param {type} element JQuery element for which the events are registered
 * @param {type} downFunction Callback for down effects
 * @param {type} upFunction Callback for up effects
 * @param {type} clickAction Callback for the click action
 **/
function registerEventsForSwipeableElement(element, downFunction, upFunction, clickAction) {
    registerEventsBase(element, downFunction, upFunction, clickAction, { stopPropagation: false, ignoreY: true, callUpFunction4TouchMove: false, callClickAction4TouchEnd: true, clickDelay: globals.general.clickDelay });
}

/**
 * Registers events for swipeable elements. The down function is not executed on swipe gestures.
 * The click action is not executed if a swipe was performed between the up and down events.
 *
 * @param {type} element JQuery element for which the events are registered
 * @param {type} downFunction Callback for down effects
 * @param {type} upFunction Callback for up effects
 * @param {type} clickAction Callback for the click action
 **/
function registerEventsForHorizontalSwipeableElement(element, downFunction, upFunction, clickAction) {
    registerEventsBase(element, downFunction, upFunction, clickAction, { stopPropagation: false, ignoreY: false, callUpFunction4TouchMove: true, callClickAction4TouchEnd: true, clickDelay: globals.general.clickDelay });
}

/**
 * Registers events for swipeable elements on knob (dimmer, rtr). The down function is not executed on swipe gestures.
 * The click action is not executed if a swipe was performed between the up and down events.
 *
 * @param {type} element JQuery element for which the events are registered
 * @param {type} downFunction Callback for down effects
 * @param {type} upFunction Callback for up effects
 * @param {type} clickAction Callback for the click action
 * @param {type} delay
 **/
function registerEventsForPressButton(element, downFunction, upFunction, clickAction, delay) {
    registerEventsBase(element, downFunction, upFunction, clickAction, { stopPropagation: false, ignoreY: false, callUpFunction4TouchMove: true, callClickAction4TouchEnd: true, clickDelay: delay === undefined ? globals.general.clickDelay: delay });
}

/**
 * Registers events for swipeable elements on function folder. The down function is not executed on swipe gestures.
 * The click action is not executed if a swipe was performed between the up and down events.
 *
 * @param {type} element JQuery element for which the events are registered
 * @param {type} downFunction Callback for down effects
 * @param {type} upFunction Callback for up effects
 * @param {type} clickAction Callback for the click action
 **/
function registerEventsForSwipeableElementKnob(element, downFunction, upFunction, clickAction) {
    registerEventsBase(element, downFunction, upFunction, clickAction, { stopPropagation: true, ignoreY: false, callUpFunction4TouchMove: true, callClickAction4TouchEnd: false, clickDelay: globals.general.clickDelay });
}

/**
*	Ignore all touch events until the current one has ended
*	Usage:
		Just call this function in the document ready function ..
**/
function singleTouchOnly(disablePrimaryFunction) {
    var body = document.body;
    var multiTouchActive = false;
    var palmTouch = false;

    body.addEventListener("touchstart", handleStart, true);
    body.addEventListener("touchmove", handleMove, true);
    body.addEventListener("touchend", handleEnd, true);
    body.addEventListener("touchcancel", handleCancel, true);
    body.addEventListener("touchleave", handleLeave, true);
    var ongoingTouch = -1;

    function handleStart(evt) {

        if (!disablePrimaryFunction) {
            if (primaryFunction.isPrimaryFunctionActive() && evt.touches[0].webkitForce) {
                $(document).trigger("primaryFunctionStart");
                //palmTouch = true;
                evt.preventDefault();
                evt.stopPropagation();
                return;
            }
        }
        if (evt.touches.length > 1 /*ongoingTouch !== -1*/ || disableTouch) {
            //console.log("handleStart ret");
            evt.preventDefault();
            evt.stopPropagation();
            return;
        }
        ongoingTouch = evt.changedTouches[0].identifier;
        //console.log("handleStart");
    }

    function handleMove(evt) {
        var idx = ongoingTouchIndexById(ongoingTouch, evt);
        if (idx === -1 || disableTouch) {
            //console.log("handleMove ret");
            evt.preventDefault();
            evt.stopPropagation();
            return;
        }
        //console.log("handleMove");
    }

    function handleCancel(evt) {
        var idx = ongoingTouchIndexById(ongoingTouch, evt);
        if (idx === -1 || disableTouch) {
            //console.log("handleCancel ret");
            //evt.preventDefault();
            //evt.stopPropagation(); return;
        }
        ongoingTouch = -1;
        //console.log("handleCancel");
    }


    function handleLeave(evt) {
        var idx = ongoingTouchIndexById(ongoingTouch, evt);
        if (idx === -1 || disableTouch) {
            //console.log("handleLeave ret");
            evt.preventDefault();
            evt.stopPropagation(); return;
        }
        ongoingTouch = -1;
        //console.log("handleLeave");
    }


    function handleEnd(evt) {
        /*if (palmTouch) {
            palmTouch = false;
            $(document).trigger("primaryFunctionEnd");
            evt.preventDefault();
            evt.stopPropagation();
            ongoingTouch = -1;
            return; 
        }*/

        var idx = ongoingTouchIndexById(ongoingTouch, evt);
        if (idx === -1 || disableTouch) {
            //console.log("handleEnd ret");
            evt.preventDefault();
            evt.stopPropagation(); return;
        }
        ongoingTouch = -1;
        //console.log("handleEnd");
    }

    function ongoingTouchIndexById(idToFind, evt) {
        for (var i = 0; i < evt.changedTouches.length; i++) {
            if (evt.changedTouches[i].identifier === idToFind) {
                //console.log("");
                return i;
            }
        }
        //console.log("");
        return -1;    // not found
    }
}

// function setDataValue(elemName,value,defValue,append) {
//     var valid = isValidValue(value);
//     $(elemName).text( ( valid ? value : defValue ) + append );
// }

function setDataFunction(func, value, defValue, append) {
    var valid = isValidValue(value);
    func((valid ? value : defValue) + append);
}

/**
* Synced ajax call to load the given file. Calls the callback function after loading is complete.
*
* @param {type} fileName the file to be loaded
* @param {type} callback the function which is called after the file is loaded
**/
function loadView(fileName, callback) {
    $.ajax({
        url: fileName,
        data: {},
        cache: false,
        async: false,
        success: function (data) {
            try {
                callback($(data));
            }
            catch (e) {
                console.error('error in loadView:' + e.message);
            }
        },
        dataType: 'html'
    });
}

/**
* generates random UID's
*
**/
function generateUID() {

    var charSet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    var charSetSize = charSet.length;
    var charCount = 10;
    var id = '';

    for (var i = 1; i <= charCount; i++) {
        var randPos = Math.floor(Math.random() * charSetSize);
        id += charSet[randPos];
    }
    return id;
        
}

// small extension to get measured width / height of a HTML DOM element
/*
 * USAGE:
 * var width  = $(html_element).getMeasuredWidth();
 * var height = $(html_element).getMeasuredHeight();
 */
jQuery.fn.extend({
    getMeasuredWidth: function () {
        var style = window.getComputedStyle(this[0], null);
        if (null == style || undefined == style)
            return 0;

        var width = parseInt(style.getPropertyValue("width"));
        width += parseInt(style.getPropertyValue("padding-left"));
        width += parseInt(style.getPropertyValue("padding-right"));
        width += parseInt(style.getPropertyValue("border-left-width"));
        width += parseInt(style.getPropertyValue("border-right-width"));
        return width;
    },

    getMeasuredHeight: function () {
        var style = window.getComputedStyle(this[0], null);
        if (null == style || undefined == style)
            return 0;

        var height = parseInt(style.getPropertyValue("height"));
        height += parseInt(style.getPropertyValue("padding-top"));
        height += parseInt(style.getPropertyValue("padding-bottom"));
        height += parseInt(style.getPropertyValue("border-top-width"));
        height += parseInt(style.getPropertyValue("border-bottom-width"));
        return height;
    }
});

/**
* Rounds numbers
*
**/
function Round(num, dec) {
    return parseFloat(num).toFixed(isNaN(dec) ? 2 : dec) / 1;
}