﻿/*global $, fsm*/
/*jslint browser: true*/

window.tsx.createEtsConfig = function () {
    var defaultTsxRooms,
        I18nTexts = window.Gira.appLang.appI18nTexts,
        module = {};

    $.ajax({
        url: "js//defaultRooms.json",
        cache: false,
        async: false,
        success: function (data) {
            defaultTsxRooms = JSON.parse(data);
            if (defaultTsxRooms.containers === undefined) {
                defaultTsxRooms.containers = [];
            }
        }
    });


    //some constants:
    var gdsAppName = 'gira-app';
    var outFile = 'userfavouritessorting.json';


    // deep clone of default object
    module.tsxRooms = $.extend(true, {}, defaultTsxRooms);

    /**
    * Overwrites the tsxRooms data structure with the default ets values.
    */
    function restoreDefault() {
        $.ajax({
            url: "js//defaultEtsRooms.json",
            cache: false,
            async: false,
            success: function (data) {
                var defaultEtsRooms = JSON.parse(data);

                module.tsxRooms = $.extend(true, {}, defaultEtsRooms);

                if (module.favoriteSelectionModel.containers != undefined) {
                    module.favoriteSelectionModel.containers(module.tsxRooms.containers);
                }

                if (module.channelSortModel.topView != undefined) {
                    module.channelSortModel.topView(module.tsxRooms.topViews);
                }
            }
        });
    }

    /**
    * if user triggers the restore default ets action
    */
    module.onRestoreDefault = function () {
        fsm.API.SystemMessage.OpenConfirmation(I18nTexts.resetEtsConfig,
            // ok button: restore ETS config
            function () {
                restoreDefault();
                module.save();
                module.startGeneration();
                fsm.API.SystemMessage.CloseConfirmation();
            },
            // cancel button: close popup
            function () {
                fsm.API.SystemMessage.CloseConfirmation();
            });
    };

    /**
    * Checks if the favourites or sorting has been changed
    *
    * @returns true if modified otherwise false
    */
    module.hasChanged = function () {

        var compareChannels = function (c1, c2)
        {
            if (c1.index != c2.index) return false;
            if (c1.icon != c2.icon) return false;
            if (c1.name != c1.name) return false;

            return true;
        };
		
		/**
		* Checks if a array is empty or undefined	
		* @returns true if the array has a zero-length or is undefined
		*/
		var arrayEmptyOrUndefined = function (a) {
			if (a === undefined || a.length === 0) return true;
			return false;
		};
		
		/**
		* compares two topViewArrays (of containers) 
		* undefined and zero-length arrays are considered to be equal
		*
		* @returns true if equal, otherwise false
		*/
		var compareContainerTopViewArray = function (v1, v2)
		{											
			//check if undefined or length == 0								
			if(arrayEmptyOrUndefined(v1))
			{				
				if(arrayEmptyOrUndefined(v2))return true;				
				else if(v1 === undefined || v2 === undefined) return false;
			}																	
					
			if(v1.length != v2.length) return false;						
			
			//check for each value in v1 if it exists in v2
			for (var i in v1){								
							
				var found = false;
				
				for(var j in v2)
				{
					if(v1[i] === v2[j]) 
					{
						found = true;
						break;
					}
				}
				if(found === false) return false;				
			}
			
			return true;
		};
		
		/**
		* compare two containers for equality
		*
		* @returns true if equal, otherwise false
		*/
		var compareContainer = function (c1, c2) {
			if (!c1 || !c2) {
				return false;
			}
			if (!compareChannels(c1, c2)) return false;
									
			if (!compareContainerTopViewArray(c1.topView, c2.topView)) return false;
			
			for (var i in c1.channels) {
				if(!compareChannels(c1.channels[i], c2.channels[i])) return false;
			}	

			return true;
		};
		
		/**
		* compares all containers for equality
		*
		* @returns true if equal, otherwise false
		*/
		var compareContainers = function (m1, m2) {
			for (var i in m1) {
				if(!compareContainer(m1[i], m2[i])) return false
			}			
			
			return true;
		};
		
		/**
		* compare 'main' the topView arrays
		*
		* @returns true if equal, otherwise false
		*/
		var compareTopViews = function(t1, t2) {
			if(t1.length != t2.length) return false;
			
			for (var i in t1) {
				if(!compareChannels(t1[i], t2[i])) return false;
			}
			
			return true;
		};

	    module.channelSortModel.applyCurrentChanges();
	    // do the compare
		var containerUnchanged = compareContainers(defaultTsxRooms.containers, module.tsxRooms.containers);
		var topViewUnchanged = compareTopViews(defaultTsxRooms.topViews, module.tsxRooms.topViews);
		if (containerUnchanged && topViewUnchanged) {
		    return false;
		}
		return true;
	
	};

    /**
    * Overwrites the tsxRooms data structure  with the default values.
    */
	function reset() {
        module.tsxRooms = $.extend(true, {}, defaultTsxRooms);

        if (module.favoriteSelectionModel.containers != undefined) {
            module.favoriteSelectionModel.containers(module.tsxRooms.containers);
        }

        if (module.channelSortModel.topView != undefined) {
            module.channelSortModel.topView(module.tsxRooms.topViews);
        }
	}

    /**
    * Resets individualization data and models. Registers confirmation callback which is called when the individualization is aborted.
    */
	module.onEnter = function () {
	    reset();

	    module.favoriteSelectionModel.lastViewChannels = false;
	    module.channelSortModel.subViewActive = -1;

	    var navigation = NavbarController.getInstance();
	    navigation.setLeaveSettingsConfirmation(leaveIndividualization);
	    NavbarController.getInstance().addBackFunction(leaveIndividualization);
	};

    /**
     * Opens a confirmation popup if the indiviualization is aborted and if there are changes which would be lost.
     * 
     * @param {function} resultCallback 
     *          Callback to perfrom/cancel home action or settings close by passing true/false
     */
	var leaveIndividualization = function (resultCallback) {
	    var navigation = NavbarController.getInstance();
	    if (module.hasChanged()) {
	        fsm.API.SystemMessage.OpenConfirmation(I18nTexts.losingConfig,
                                // ok button: perform close/back
	                function () {
	                    fsm.API.SystemMessage.CloseConfirmation(function () {
	                        resultCallback ? resultCallback(true) : navigation.back();
	                        navigation.removeLeaveSettingsConfirmation();
	                    });
	                },
	                // cancel button: close popup, cancel close action/re add back function
                    function() {
                        fsm.API.SystemMessage.CloseConfirmation();
                        resultCallback ? resultCallback(false) : NavbarController.getInstance().addBackFunction(leaveIndividualization);
                    }
                );
        } else {
            resultCallback ? resultCallback(true) : navigation.back();
            navigation.removeLeaveSettingsConfirmation();
        }
    };

    /**
     * Opens a confirmation popup if indivdualization changes were made which shall be applied.
     * 
     */
    module.apply = function () {
        if (module.hasChanged()) {
            fsm.API.SystemMessage.OpenConfirmation(I18nTexts.generateNew,
                // ok button: save individualization file and start generators
	            function () {
	                module.save();
	                module.startGeneration();
	            },
                // cancel button: close popup
	            function () {
	                fsm.API.SystemMessage.CloseConfirmation();
	            });
        } else {
            NavbarController.getInstance()._history.pop();
            NavbarController.getInstance().back();
        }
    };
	
	
	/**
	* Save the current favourites and sorting to the file system
	* /opt/userdata/devicestack/appData/(gdsAppName)/(outFile)
	*/
	module.save = function() {
		var objString = JSON.stringify(this.tsxRooms);		
		gds$.setAppValue(gdsAppName, outFile, objString);
	};
	
	/**
	* Turn off display and start generation
	*
	*/
	module.startGeneration = function () {
		ComClient.sendTagValue(1101,2);
	};

    /**
     * Returns the container with the specified container
     * 
     * @param {string} index Index of a container
     * @returns the according container object or undefined if it does not exist
     */
    function getContainer(index) {
        var containers = module.tsxRooms.containers;
        for (var i in containers) {
            if (containers[i].index === index) {
                return containers[i];
            }
        }
        return undefined;
    }
	
	/**
	* get the container's array index from module.tsxRooms.containers
	* by the containers named index 
	*
	*@param {string} index Index of a container (e.g container-0)
	*@returns the according index of the container in the module.tsxRooms.containers array or undefined
	*/
	function getContainerArrayIndex(index)
	{
		var numericIndex = index.match(/\d+$/);
		numericIndex = numericIndex[0];

		var containers = module.tsxRooms.containers;
        for (var i in containers) 
		{			
            if (containers[i].index === numericIndex) 
			{
                return i;
            }
        }
        return undefined;
	}

	/**
	* get index in the module.tsxRooms.topViews array of a element by it's index
	*
	* @param {string} channel, container or world index (e.g channel-1, 1-1; 'rtr')
	* @returns index of element in module.tsxRooms.topViews or -1
	*/	
	function findTopViewElement(index)
	{
		var topViews = module.channelSortModel.topView();
		
		for(var i = 0; i < topViews.length; i++)
		{
			if(topViews[i].index === index) return i;
		}
		return -1;
	}
	
	/**
	* lookup for a element if it is topView by it's index in the module.tsxRooms.containers structure	
	* Elements other then channels are considered to be topView	
	*
	* @param {string} channel index (e.g 1-1)
	* @returns true if element is marked as 'topView', otherwise false
	*/	
	function isElementTopView(index)	
	{	
		var containers = module.favoriteSelectionModel.containers();		
		var containerIndex = index.match(/^\d+/);
		var channelIndex = index.match(/\d+$/);
				
		if(containerIndex === null || channelIndex === null) return true;
		
		containerIndex = containerIndex[0];
		channelIndex = channelIndex[0];		
					
		for(var i = 0; i < containers.length; i++)
		{
			if(containers[i].index === containerIndex)
			{
				if(containers[i].topView === undefined) return false;
				if(containers[i].channels === undefined) return false;
				
				for(var j = 0; j < containers[i].topView.length; j++)
				{
					if(containers[i].topView[j] === channelIndex)
					{						
						return true;
					}
				}
			}
		}	
		
		return false;
	}
	
	/**
	* get the first elements index in module.tsxRooms.topViews that is not a regular channel
	*
	* @returns index of first element that's not a regular channel or -1 if no element is found	 
	*/
	function getFirstNonChannelTopView()
	{
		var topViews = module.channelSortModel.topView();
		
		for(var i = 0; i < topViews.length; i++)
		{			
			// match for non channel index format
			if(!topViews[i].index.match(/^\d+[-]\d+/))
			{				
				return i;
			}			
		}		
		return -1;
	}
	
	
	/**
	* Count all non channel elements that are in the topView list
	*
	*@returns count of all non channel elements that are in the topView list
	*/
	function getTopViewNonChannelCount()
	{
		var topViews = module.tsxRooms.topViews;
		var nonChannelTopViewCount = 0;
	    if (!isValidArray(topViews))
	        return 0;

		for(var i = 0; i < topViews.length; i++)
		{			
			if(!topViews[i].index.match(/^\d+[-]\d+/))
			{				
				nonChannelTopViewCount++;
			}			
		}		
		
		return nonChannelTopViewCount;
	}
	
	/**
	* Get all containers from the TopView list
	*
	* @return new Array referencing all containers from module.tsxRooms.topViews
	*/
	function getTopViewContainers()
	{
		var topViewContainers = new Array();		
		var topViews = module.tsxRooms.topViews;
		
		if (!isValidArray(topViews))
		    return topViewContainers;

		for(var i = 0; i < topViews.length; i++)
		{			
			if(topViews[i].index.match(/^container[-]\d+/))
			{				
				topViewContainers.push(topViews[i]);
			}			
		}	
		
		return topViewContainers;
	}
	
	var MAX_FAVOURITES = 25;
	
	function showMaxFavouritesPopup() {
	    fsm.API.SystemMessage.OpenWarning(I18nTexts.maxOfFavorites);
	}

    /**
     * Model for the dynamic generation of the favorite selection room and channel lists.
     */
    module.favoriteSelectionModel = new function () {
        var self = this;

		self.n = undefined;
        // Title of the current channel sort menu page
        self.subMenuTitle = "";

        // Observable list of containers
        self.containers = ko.observableArray(module.tsxRooms.containers);
        // Observable list of channels for current room
        self.channels = undefined;
        // Observable list of topview elements for current room
        self.topView = undefined;
		
		//for undo ....
		self.channelBackup = undefined;
		self.containersBackup = undefined;
		self.lastViewChannels = false;
		
		// static favourites count
		// = Container + Worlds
		self.staticFavourites = getTopViewNonChannelCount();
		
        // Registers events for channel row elements
        self.registerEvents = function (element, data) {
            var $element = $(element[1]);
            eventsOnSettingsEntry('channel-' + data.index);
            $element.on('settingsEntryAction', function () {
                var pos = self.topView.indexOf(data.index);
										
                if (pos < 0) {
				
					if(self.countSelectedFavourites() + self.staticFavourites >= MAX_FAVOURITES)
					{
						showMaxFavouritesPopup();
					}
					else
					{
						self.topView.push(data.index);
					}
                } 
				else 
				{
                    self.topView.splice(pos, 1);
                }
            });
        };

        // Registers events for container row elements
        self.registerContainerEvents = function (element, data) {
            eventsOnSettingsEntry('container-' + data.index);
            $(element).on('settingsEntryAction', function () {
			
				//backup current channel
				self.channelBackup = $.extend(true, {}, data);
				self.lastViewChannels = true;
			
				if(data.topView === undefined) data.topView = new Array();
				
                self.subMenuTitle = data.name;
                self.channels = ko.observableArray(data.channels);
                self.topView = ko.observableArray(data.topView);
				
                openSettingsElement(this.parentNode.getAttribute('menu'), this.parentNode.getAttribute('submenu'));
				self.n.addBackFunction(function(){self.revert(); self.n.back(); });
            });
        };

        // sets the title of the current menu page
        self.setTitle = function () {
            $(menuId + ' .settings-subtitle').text(self.subMenuTitle);
        };
		
		//do view dependent things on enter
		self.onEnter = function() {
			//make a backup from the whole room structure if not entered from a child view
			if(self.lastViewChannels === false)
			{				
				self.containersBackup = $.extend(true, {}, module.tsxRooms);
				self.n = NavbarController.getInstance();
				self.n.addBackFunction(function(){self.revert(); self.n.back(); });
			}			
			else self.lastViewChannels = false;
		};
		
		//handle ok button
		self.ok = function() {
			self.n._history.pop();
		
			self.channelBackup = undefined;
			
			if(self.lastViewChannels === false) {
				self.updateTopViews();
			}
			self.lastViewChannels = false;
		};
		
		//handle cancel button
		self.cancel = function(){
			//not required
		};
		
		//revert changes in one or all channel
		self.revert = function() {
			//revert one channel
			if(self.channelBackup !== undefined) {
				module.tsxRooms.containers[self.channelBackup.index] = self.channelBackup;
				self.channelBackup = undefined;
			} else { //revert all channel
				module.tsxRooms =  $.extend(true, {}, self.containersBackup);
				self.containersBackup = undefined;				
				self.containers(module.tsxRooms.containers);
				self.lastViewChannels = false;
			}						
		};
		
		// count currently selected favourites
		self.countSelectedFavourites = function() {
			var count = 0;
			var containers = module.tsxRooms.containers;
			for (var i in containers) 
			{
				if(undefined !== containers[i].topView)
				{
					count += containers[i].topView.length;
				}
			}						
			return count;	
		};
		
		//Update TopViews for sorting
		self.updateTopViews = function() {
			var numContainers = module.tsxRooms.containers.length;
			var containers = module.tsxRooms.containers;			
			var topViews = module.channelSortModel.topView();
									
			//remove elements that are no more topViews
			for(var i = 0; i < topViews.length; i++) {
				if(!isElementTopView(topViews[i].index)) {
					topViews.splice(i--,1);					
				}
			}
			
			var insertPos = getFirstNonChannelTopView();
			
			for(i = 0; i < numContainers; i++) {
				if(containers[i].topView !== undefined) {
					for(var j = 0; j < containers[i].topView.length; j++) {
						var topView = containers[i].topView[j];						
						var newIndex = containers[i].index + "-" + containers[i].channels[topView].index;
																				
						//insert if element is not a topView element already 
						if(findTopViewElement(newIndex) < 0) {
							var newTopViewElement = new Object();				
							newTopViewElement.index = newIndex;
							newTopViewElement.icon = containers[i].channels[topView].icon;
							newTopViewElement.name = containers[i].channels[topView].name;		
							
							topViews.splice(insertPos++, 0, newTopViewElement);						
						}																					
					}
				}
			}		
		}
    };

    /**
     * Model for the dynamic generation of the channel sort lists.
     */
    module.channelSortModel = new function () {
        var self = this;

		self.n = undefined;
		
        // Title of the current channel sort menu page
        self.subMenuTitle = "";

		self.backup = undefined;
		
        // Observable list of topview channels
        self.topView = ko.observableArray(module.tsxRooms.topViews);
        // Observable list with topview channels of the current container
        self.channels = undefined;		
		// 
		self.subViewActive = -1;

        // registers events for a sort list row and initializes dragsort 
        self.registerEvents = function (element, data) {
            eventsOnSettingsEntry('channel-' + data.index);			
            if (data.containerId !== undefined) {
                $(element).on('settingsEntryAction', function () {
					self.sortTopViews();
					self.subViewActive = data.containerId;
                    var targetContainer = getContainer(data.containerId);
                    self.subMenuTitle = targetContainer.name;
                    self.channels = ko.observableArray(targetContainer.channels);
                    openSettingsElement(this.parentNode.getAttribute('menu'), this.parentNode.getAttribute('submenu'));
                });
            }
            self.registerDragsort();
        };

        // destroys and reinitializes dragsort
        self.registerDragsort = function () {
            $(menuId + " .channel-sort").dragsort('destroy');
            $(menuId + " .channel-sort").dragsort({
                containment: ".channel-sort",
                scrollContainer: menuId + " .settings-swiper-container",
                dragBetween: false,
                dragSelector: menuId + " .settings-row-sortindicator",
                itemSelector: menuId + " .settings-row",
                placeHolderTemplate: '<div class="settings-row dsl-placeholder"></div>',
                dragStart: function () {
                },
                dragEnd: function () {
                    // return true when drop position is allowed
                    // otherwise return false here
                    return true;
                }
            });
        };

        // sets the title of the current menu page
        self.setTitle = function() {
            $(menuId + ' .settings-subtitle').text(self.subMenuTitle);
        };
		
		//do view dependent things on enter
		self.onEnter = function()
		{	
			if(self.subViewActive === -1)
			{				
				self.backup = $.extend(true, {}, module.tsxRooms);
				
				self.n = NavbarController.getInstance();
				self.n.addBackFunction(function(){self.revert(); self.n.back(); });
			}		
			self.subViewActive = -1;
		};

        // apply current changes
		self.applyCurrentChanges = function () {
		    if (self.subViewActive > -1) {
		        self.sortContainer();
		    }
		    else {
		        self.sortTopViews();
		        self.sortFavouritesChannels();
		    }
		};
		
		//handle ok button
		self.ok = function()
		{							
			if(self.subViewActive > -1)
			{
				self.sortContainer();
				self.subViewActive = -1;
			}
			else
			{
				self.n._history.pop();	
				self.sortTopViews();
				self.sortFavouritesChannels();
			}			
		};
		
		//handle cancel button
		self.cancel = function()
		{
			//notRequired
		};
		
		//apply gui sorting inside a container 
		self.sortContainer = function()
		{			
			var newSorting = new Array();
			var sortedGuiElements = $(menuId + " .channel-sort .settings-row");
			if (sortedGuiElements.length === 0) return;
			
			for(var i = 0; i < sortedGuiElements.length; i++)
			{
				newSorting.push(ko.dataFor(sortedGuiElements[i]));
			}
			
			getContainer(self.subViewActive).channels = newSorting;
		};
		
		//apply gui sorting of topViews
		self.sortTopViews= function()
		{			
			var newSorting = new Array();
			var sortedGuiElements = $(menuId + " .channel-sort .settings-row");
			if (sortedGuiElements.length === 0) return;
			
			for(var i = 0; i < sortedGuiElements.length; i++)
			{
				newSorting.push(ko.dataFor(sortedGuiElements[i]));
			}
			
			self.topView(newSorting);			
			module.tsxRooms.topViews = newSorting;
		};
				
		//apply gui sorting Containers to Favorites selection
		self.sortFavouritesChannels = function()
		{
			var newSorted = new Array(),
			    tvc = getTopViewContainers(),
                i;

			for(i in tvc)
			{				
				var orgIndex = getContainerArrayIndex(tvc[i].index);
				newSorted.push(module.tsxRooms.containers[orgIndex]);
			}

			module.favoriteSelectionModel.containers(_.union(newSorted, module.tsxRooms.containers));
		};
		
		//revert changes in a one or all channel
		self.revert = function()
		{
			module.tsxRooms =  $.extend(true, {}, self.backup);
			module.favoriteSelectionModel.containers(module.tsxRooms.containers);
			self.topView(module.tsxRooms.topViews);
			self.backup = undefined;	
			self.subViewActive = -1;			
		}
    };

    return module;
};
