/*global ko, $, gds$, _*/
/*jslint browser: true*/

(function (ns) {
    "use strict";
    function LicenseData() {
        var licensesData = {};

        function loadTpIpJson() {
            var result;

            result = JSON.parse($.ajax({
                url: "gira/license/tpipSoftware.json",
                async: false
            }).responseText);

            return result;
        }

        function loadLicenseText() {
            var tpipTable =  loadTpIpJson(),
                result = JSON.parse($.ajax({
                    url: "gira/license/licenseText.json",
                    async: false
                }).responseText),
                insertIpTable = function (result) {
                    return _.map(result, function (obj) {
                        if (obj.tpip) {
                            obj.table = tpipTable;
                        }
                        return obj;
                    });
                };
            licensesData.de = insertIpTable(result.de);
            licensesData.en = insertIpTable(result.en);
            licensesData.agreeDe = result.agreeDe;
            licensesData.agreeEn = result.agreeEn;
            return licensesData;
        }

        function getLicenseTextsObj() {
            var licensesObj;
            if (!licensesData.de) {
                licensesObj = loadLicenseText();
            } else {
                licensesObj = licensesData;
            }
            return licensesObj;
        }

        return {
            licenseTextObj: getLicenseTextsObj
        };
    }

    ns.LicenseData = LicenseData;
    ns.licenseData = new LicenseData();

}(window.Gira));
//# sourceURL=gira.LicenceData.js