/*jslint todo: true browser: true*/
/*global $, ko, window*/

(function (ns) {
    'use strict';

    if (ns.LanguageManager !== undefined) {
        return;
    }

    var Log = window.Gira.Log;

    function LanguageManager() {
        var modules = {},
            langRootPath = "lang/",
            langConfig = {lang: "de", langRootPath: langRootPath};

        function getLangPath() {
            return langRootPath + langConfig.lang + "/";
        }

        function getFileData(path) {
            return $.ajax({
                url: path,
                async: false
            }).responseText;
        }

        function register(module, file) {
            // register the modules
            try {
                var data = getFileData(getLangPath() + file);
                modules[module] = JSON.parse(data);
                return modules[module];
            } catch (ex) {
                Log.exception(ex);
            }
        }

        function registerWithCallback(module, getFilePathCallback) {
            try {
                var filePath = getFilePathCallback(langConfig),
                    data = getFileData(filePath);
                modules[module] = JSON.parse(data);
                return modules[module];
            } catch (ex) {
                Log.exception(ex);
            }
        }

        function getCurrentConfig() {
            return langConfig;
        }

        function get(module) {
            return modules[module];
        }

        function loadLangConfig() {
            var data;
            try {
                data = getFileData(langRootPath + "langConfig.json");
                langConfig = JSON.parse(data);
                langConfig.langRootPath = langRootPath;
            } catch (ex) {
                Log.exception(ex);
            }
        }

        loadLangConfig();

        return {
            register: register,
            getCurrentConfig: getCurrentConfig,
            registerWithCallback: registerWithCallback,
            get: get,
            reLoadLangConfig : loadLangConfig
        };
    }

    ns.LanguageManager = LanguageManager;

}(window.Gira));