/*global ws, Gira, WebSocket*/
/*jslint browser: true*/

(function (ns) {
    'use strict';

    /*
     * Wrapping a Connection to separate the sender and receiver.
     */
    function GdsConnectionWrapper(ip) {
        var self = this,
            createSocket = function () { return new WebSocket('ws://' + ip + ':8182/gds/api'); },
            ws = createSocket(),
            emptyHandler = function () { return undefined; },
            handlers = {
                onopen: emptyHandler(),
                onclose: emptyHandler(),
                onerror: emptyHandler(),
                onmessage: emptyHandler()
            };
        self.send = function (message) {
            ws.send(message);
        };

        self.onopen = function (ea) {
            handlers.onopen = ea;
            ws.onopen = ea;
        };

        self.onclose = function (ea) {
            handlers.onclose = ea;
            ws.onclose = ea;
        };

        self.onerror = function (ea) {
            handlers.onerror = ea;
            ws.onerror = ea;
        };

        self.onmessage = function (ea) {
            handlers.onmessage = ea;
            ws.onmessage = ea;
        };

        self.readyState = function () {
            return ws.readyState;
        };

        self.close = function () {
            ws.close();
        };
        // Creates a new web socket and attaches the previously attached 'on' handlers
        self.renew = function () {
            ws = createSocket();
            ws.onopen = handlers.onopen;
            ws.onclose = handlers.onclose;
            ws.onerror = handlers.onerror;
            ws.onmessage = handlers.onmessage;
        };
    }

    ns.GdsConnectionWrapper =  GdsConnectionWrapper;
}(window.Gira));