/*jslint browser: true, todo: true*/
/*global ko, Gira, $, _*/

(function (vm) {
    "use strict";
    var countDownRecall = window.Gira.DCS.Viewmodels.countDownRecall;

    function DisplayViewmodel(options, mediaStreamVideo) {
        var self = this,
            video = mediaStreamVideo,
            DCS = window.Gira.DCS,
            Urns = DCS.Urns,
            DoorCall = DCS.DoorCall,
            Messages = DCS.Messages,
            messages = options.messages,
            recallCountDownFrom = 0,
            recallCountdown = ko.observable(null),
            connection = options.connection,
            hangupClass = 'dcs-hangup-receiver-animation dcs-hangup-receiver',
            incomingCallClass = 'dcs-incomingcall-icon-loop',
            acceptingCallClass = 'dcs-incomingcall-icon-move',
            endingCallWithoutCameraClass = 'dcs-incomingcall-icon-end',
            tableImageBusBusy = 'dcs-display-table-image-busbusy',
            tableImageNoConnection = 'dcs-display-table-image-noconnection',
            tableImageIdle = 'dcs-display-table-image-idle',
            noConnectionMsg = messages[Urns.displayMessages.noConnectionToDCS],
            requestStreamInProgress = false;

        self.showVideostream = ko.observable(false);
        self.showCameras = ko.observable(false);
        self.displayMain = ko.observable(noConnectionMsg.text);
        self.displayHeadline = ko.observable(noConnectionMsg.header);
        self.displayAnimationMessage = ko.observable('');
        self.displayAnimationMessageVisibility = ko.observable(false);
        self.displayAdditional = ko.observable('');
        self.doorCallIsActive = ko.observable(false);
        self.cameras = ko.observableArray();
        self.showAnimation = ko.observable(false);
        self.animationReceiver = ko.observable();
        self.showTableImage = ko.observable(false);
        self.tableImage = ko.observable(tableImageNoConnection);
        self.showCameraName = ko.observable(false);
        self.recallCountdown = recallCountdown;
        self.cameraPopUp = new DCS.CameraPopUp();
        self.activeVideoSlideIndex = 0;
        self.popUpDisplayAdditional = ko.observable(true);
        self.currentCameraName = ko.observable('');
        self.latestVideoIndex = 0;

        function cameraLoadInfoVisibility(show) {
            if (show) {
                _.each(self.cameras(), function (camera) {camera.showCameraLoadInfo(true); });
            }
            if (self.cameras().length > 0) {
                self.cameras()[self.activeVideoSlideIndex].showCameraLoadInfo(show);
            }
        }
        // in case when we have unknown video source and menu configuration does not contain any camera
        function checkVideoSlideExistence() {
            if (self.cameras().length === 0) {
                self.generateSlides([{key: "1", set: "Cameras", value: self.displayAdditional()}], true);
                self.activeVideoSlideIndex = 0;
                self.showStreamOnActiveSlide(false);
            }
        }
        function videoStreamMsgCheck(data) {
            self.showVideostream(data.value === '1');
            if (self.showVideostream()) {
                checkVideoSlideExistence();
                self.setUpActiveSlide(self.latestVideoIndex - 1);
                self.showCamerasAndSyncSlide();
            } else {
                self.cameraPopUp.resetSlidePopup();
                self.showStreamOnActiveSlide(false);
            }
            // when user swipe we have first VideoStream Message = 0
            cameraLoadInfoVisibility(requestStreamInProgress || self.showVideostream());
            DCS.CameraSwiper.syncSwiperCurrentSlide(self.activeVideoSlideIndex);
            self.hideShowVideo(self.showVideostream());
            requestStreamInProgress = false;
        }

        function temporarySlidePlaysVideo(newCameraList) {
            return newCameraList.length === 0 && // new camera list is empty
                self.cameras().length === 1 && // we already have one camera
                self.cameras()[0].isTemporarySlide && // this camera is temporary created to show stream from unknown source
                self.showCameras(); // if cameras are not shown to user it is ok to generate cameras
        }

        function videoIndexMsgCheck(data) {
            var videoIndex,
                videoIndexChanged = false;
            videoIndex = parseInt(data.value, 10);
            if (!isNaN(videoIndex)) {
                videoIndexChanged = (data.value !== data.oldValue);
                if (videoIndex > 0 && videoIndex <= self.cameras().length) {
                    self.setUpActiveSlide(videoIndex - 1);
                    if (self.showCameras()) {
                        DCS.CameraSwiper.syncSwiperCurrentSlide(self.activeVideoSlideIndex);
                    }
                    cameraLoadInfoVisibility(true);
                }
                self.popUpDisplayAdditional(videoIndex === 0);
                self.latestVideoIndex = videoIndex;
            }
            if (DCS.cameraSwiper) {
                if (self.showVideostream() && videoIndex !== 0 && videoIndexChanged) {
                    self.showStreamOnActiveSlide(false);
                    self.hideShowVideo(true);
                }
            }
        }
        //show stream when started
        video.onVideoStartedAction(function () {
            self.showStreamOnActiveSlide(true);
        });

        self.runReceiverAnimation = function (css, text) {
            self.animationReceiver('');
            self.animationReceiver(css);
            self.showAnimation(true);
            if ((text !== '') && (text !== undefined)) {
                self.displayAnimationMessage(text);
                self.displayAnimationMessageVisibility(true);
            } else {
                self.displayAnimationMessage('');
                self.displayAnimationMessageVisibility(false);
            }
        };
        self.onAnimationFinish = function () {
            self.displayAnimationMessageVisibility(false);
            // trigger subscription on transition end.
            if (self.animationReceiver() === hangupClass || self.animationReceiver() === endingCallWithoutCameraClass) {
                self.showAnimation(false);
            }
            self.showTableImage(true);
        };
        self.resetVideoStream = function () {
            if (self.showVideostream() && self.showCameras()) {
                cameraLoadInfoVisibility(true);
                self.hideShowVideo(true);
            }
        };
        self.setDefaults = function () {
            self.resetVideoStream();
            self.cameraPopUp.setCameraPopUpDefaults();
        };
        self.showCamera = function (slideIndex) {
            var index = slideIndex - 1;
            if (self.cameras()[index] !== undefined) {
                self.cameraPopUp.resetSlidePopup();
                self.activeVideoSlideIndex = index;
                self.cameras().forEach(function (vm) {
                    vm.isActiveSlide(false);
                });
                self.cameras()[index].isActiveSlide(true);
            }
        };
        self.sendMessage = function (message) {
            connection.sendMessage(message);
        };
        self.isCamerasCollectionChanged = function (cameraArr) {
            var collectionChanged = false,
                index = 0,
                numberOfCameras = self.cameras().length;
            if (numberOfCameras !== cameraArr.length) {
                return true;
            }
            do {
                collectionChanged = (self.cameras()[index].FullText !== cameraArr[index].value);
                index = index + 1;
            } while (index < numberOfCameras && !collectionChanged);
            return collectionChanged;
        };
        self.generateSlides = function (cameras, isTemporarySlide) {
            var numberOfCameras = self.cameras().length,
                isTmpSlide = isTemporarySlide || false;
            if (numberOfCameras === 0 || self.isCamerasCollectionChanged(cameras)) {
                //reset active video slide index before camera-slides generation
                self.activeVideoSlideIndex = 0;
                if (numberOfCameras > 0) {
                    self.cameras.removeAll();
                }
                cameras.forEach(function (camera, index) {
                    var active = self.activeVideoSlideIndex === index,
                        text = camera.value;
                    self.cameras.push(new DCS.Viewmodels.CameraSliderViewmodel(active, text, active && self.showVideostream(), camera.value, isTmpSlide));
                });
                if (DCS.cameraSwiper) {
                    DCS.cameraSwiper.reInit();
                }
            }
        };

        self.setUpActiveSlide = function (index) {
            var slideIndex = index >= 0 ? index : 0;
            self.activeVideoSlideIndex = slideIndex;
            self.cameras().forEach(function (vm) {
                vm.isActiveSlide(false);
            });
            self.cameras()[slideIndex].isActiveSlide(true);
            self.currentCameraName(self.cameras()[slideIndex].Text());

        };
        self.showStreamOnActiveSlide = function (showVideoTag) {
            self.cameras().forEach(function (vm) {
                vm.ShowVideoTag(false);
                if (vm.isActiveSlide() && showVideoTag) {
                    vm.ShowVideoTag(showVideoTag);
                }
            });
        };
        /*
         * Function to delegate swiped information to state machine
         */
        self.requestNewCameraStream = function () {
            var activeCameraText = self.cameras()[self.activeVideoSlideIndex].Text(),
                indexOfCurrentCamera = self.activeVideoSlideIndex + 1;
            if (self.showVideostream()) {
                self.showStreamOnActiveSlide(false);
            }
            self.sendMessage(Messages.setMenuValue.showCamera(indexOfCurrentCamera, activeCameraText));
        };
        self.applyData = function (data) {
            self.handleDoorCallMessages(data);
            self.handleDisplayMessages(data);
            self.handleCameraMessages(data);
        };
        self.hideShowVideo = function (isShown) {
            if (isShown) {
                video.startVideoStream();
            } else {
                video.stopVideoStream();
            }
        };
        self.showCamerasAndSyncSlide = function () {
            self.showCameras(true);
            DCS.CameraSwiper.swipeToActiveSlide(self.activeVideoSlideIndex);
            self.cameraPopUp.slideDown(false);
        };
        self.handleMenuConfiguration = function (data) {
            var menu = Messages.menuConfigToObject(data);
            recallCountDownFrom = menu.recallTimeout;
            // do not generate new slides in case we have only temporary active slide and empty camera list arrived
            if (!temporarySlidePlaysVideo(menu.cameras)) {
                self.generateSlides(menu.cameras);
            }
        };

        self.handleCameraMessages = function (data) {
            if (Urns.isVideoStream(data.urn)) {
                videoStreamMsgCheck(data);
            } else if (Urns.isVideoStreamIndex(data.urn)) {
                videoIndexMsgCheck(data);
            } else if (Urns.isResponseForMenuGetConfiguration(data)) {
                self.handleMenuConfiguration(data);
            } else if (Urns.isMenuExecuteCameraRequest(data)) {
                requestStreamInProgress = true;
                cameraLoadInfoVisibility(true);
            } else {
                if (DoorCall.isCameraCloseByUser(data)) {
                    self.showCameras(false);
                    self.cameraPopUp.resetSlidePopup();
                }
            }
        };
        self.shouldHideCameras = function (messageValue) {
            if (messageValue !== Urns.displayMessages.activeDoorCall) {
                self.showCameras(false);
            }
        };
        self.handleDisplayMessages = function (data) {
            if (Urns.isDisplayMain(data.urn)) {
                if (data.value === Urns.displayMessages.outgoingCameraCall) {
                    self.showCamerasAndSyncSlide();
                    self.onAnimationFinish();
                } else if (data.value === Urns.displayMessages.activeCameraCall) {
                    if (self.showCameras()) {
                        self.cameraPopUp.slideDown(false);
                    }
                } else {
                    if (self.showCameras()) {
                        self.shouldHideCameras(data.value);
                    }
                    if (!self.showCameras()) {
                        self.cameraPopUp.resetSlidePopup();
                        cameraLoadInfoVisibility(true);
                    }
                    if (data.value === Urns.displayMessages.busy) {
                        self.tableImage(tableImageBusBusy);
                    } else if (data.value === Urns.displayMessages.noConnectionToDCS) {
                        self.tableImage(tableImageNoConnection);
                    } else {
                        self.tableImage(tableImageIdle);
                    }
                    var messageDetail = messages[data.value];
                    if (messageDetail !== undefined) {
                        self.displayMain(messageDetail.text);
                        self.displayHeadline(messageDetail.header);
                    }
                }
                if (options.NotificationIcons[data.value]) {
                    self.cameraPopUp.notificationIcon(options.NotificationIcons[data.value]);
                } else {
                    self.cameraPopUp.notificationIcon(null);
                }
            } else if (Urns.isAdditional(data.urn)) {
                self.displayAdditional(data.value);
                if (self.showCameras()) {
                    self.cameraPopUp.slideDown(false);
                }
            }
        };
        self.stopRecallCountDown = function () {
            if (recallCountdown() !== null) {
                recallCountdown().stop();
                recallCountdown(null);
            }
        };
        self.isLoopingAnimationActive = function () {
            return (self.animationReceiver() === acceptingCallClass ||
                    self.animationReceiver() === incomingCallClass);
        };
        self.stopAnimationLoop = function () {
            if (self.isLoopingAnimationActive()) {
                self.showAnimation(false);
            }
        };
        self.setInactiveCallParameters = function () {
            self.stopRecallCountDown();
            self.doorCallIsActive(false);
            self.stopAnimationLoop();
            self.showCameraName(false);
        };
        self.handleDoorCallMessages = function (data) {
            if (DoorCall.canAcceptRecall(data)) {
                self.doorCallIsActive(false);
                self.stopAnimationLoop();
                self.stopRecallCountDown();
                recallCountdown(countDownRecall(recallCountDownFrom, function () { recallCountdown(null); }));
            }
            if (DoorCall.hasAcceptedCall(data)) {
                self.showCameras(self.showVideostream());
                self.stopRecallCountDown();
                self.runReceiverAnimation(acceptingCallClass);
                self.doorCallIsActive(true);
                self.showCameraName(true);
            }
            if (DoorCall.isOutgoingCallInitiated(data)) {
                self.stopRecallCountDown();
            }
            if (DoorCall.isCallArriving(data)) {
                // if no camera exists show the amazing animation.
                self.showCameraName(true);
                self.runReceiverAnimation(incomingCallClass);
                self.doorCallIsActive(true);
                self.popUpDisplayAdditional(true);
                self.cameraPopUp.slideDown(false);
            }

            if (DoorCall.isCallInactive(data)) {
                self.setInactiveCallParameters();
            }

            if (DoorCall.isHangUpSelected(data)) {
                self.displayAnimationMessageVisibility(false);
                self.showCameraName(false);
                if (self.showCameras()) {
                    self.showCameras(false);
                    self.runReceiverAnimation(hangupClass, DCS.I18nTexts.callEnded);
                } else {
                    self.runReceiverAnimation(endingCallWithoutCameraClass, DCS.I18nTexts.callEnded);
                }
            }
        };
        self.click = function () {
            self.cameraPopUp.slideDown(false);
        };
        self.touchEnd = function () {
            self.cameraPopUp.slideDown(false);
        };
        self.close = function () {
            self.onAnimationFinish();
            cameraLoadInfoVisibility(false);
            self.showStreamOnActiveSlide(false);
            self.hideShowVideo(false);
        };
    }
    vm.DisplayViewmodel = DisplayViewmodel;
}(Gira.DCS.Viewmodels));
//# sourceURL=dcs.viewmodels.displayViewModel.js