/*jslint browser: true*/
/*global Gira, ko*/
(function (ns) {
    "use strict";
    ns.countDownRecall = function (recallCountdownFrom, finishCallback) {
        var doCountDownRecall = true,
            countdownFrom = recallCountdownFrom,
            latestTimerId,
            seconds = ko.observable(''),
            onStop = function () {
                seconds('');
                finishCallback();
            },
            displayRemainingTime = function (remainingSeconds) {
                seconds(remainingSeconds > 9 ? remainingSeconds.toString() : '0' + remainingSeconds.toString());
            },
            aux = function (countdown) {
                return setTimeout(function () {
                    if (countdown <= 0 || !doCountDownRecall) {
                        onStop();
                    } else {
                        displayRemainingTime(countdown);
                        latestTimerId = aux(countdown - 1);
                    }
                }, 1000);
            };
        displayRemainingTime(countdownFrom);
        latestTimerId = aux(countdownFrom - 1);
        return {
            stop: function () {
                doCountDownRecall = false;
                clearTimeout(latestTimerId);
                onStop();
            },
            seconds: seconds
        };
    };
}(Gira.DCS.Viewmodels));
//# sourceURL=dcs.countDown.js

