/*jslint browser: true*/
(function (ns) {
    "use strict";
    var state = /:State$/,
        icon = /:Icon$/,
        label = /:Label$/,
        additional = /:Additional$/,
        main = /:Main$/,
        videoStream = /:VideoStream$/,
        videoStreamIndex = /:VideoStreamIndex/,
        displayUrn = "",
        menuUrn = "",
        menuExecuteUrn = "",
        cameraUrn = "",
        doorOpener = "",
        ringTone = "",
        doorCall = "",
        f1 = "",
        f2 = "",
        cameraIndex = "",
        cameraState = "",
        light = "",
        doorGarage = "",
        connectionState = "",
        cameraVideo = "",
        connect = "",
        connectChannel = "",
        disconnectReason = "",
        menuChannel = "",
        displayMessages = {
            idle : "0",
            busy : "1",
            recall: "2",
            incomingDoorCall : "3",
            activeDoorCall : "4",
            outgoingDoorCall : "5",
            incomingCommunicatorCall : "6",
            activeCommunicatorCall : "7",
            outgoingCommunicatorCall : "8",
            activeInternalCall : "9",
            outgoingInternalCall : "10",
            noConnectionToDCS : "11",
            configurationActive : "12",
            outgoingCameraCall : "13",
            activeCameraCall : "14"
        },
        urnEndsWith = function (url, regex) {
            return regex.exec(url);
        },
        isForUrn = function (urn, eventUrn) {
            if (!urn || urn === "" || !eventUrn || eventUrn === "") {
                return false;
            }
            return eventUrn.indexOf(urn) !== -1;
        },
        isResponseFor = function (data, urn) {
            if (!data.response) {
                return false;
            }
            if (!data.response.object) {
                return false;
            }
            return data.response.object.urn === urn;
        };

    ns.Urns = {
        doorOpener: doorOpener,
        ringTone: ringTone,
        doorCall: doorCall,
        F1: f1,
        F2: f2,
        display: displayUrn,
        camera: cameraUrn,
        cameraIndex: cameraIndex,
        cameraState: cameraState,
        light: light,
        doorGarage: doorGarage,
        connectionState: connectionState,
        cameraVideo: cameraVideo,
        connect: connect,
        connectChannel: connectChannel,
        disconnectReason: disconnectReason,
        menuChannel: menuChannel,
        menu: menuUrn,
        menuExecute: menuExecuteUrn,
        displayMessages: displayMessages,
        isState: function (urn) {
            return urnEndsWith(urn, state);
        },
        isIcon: function (urn) {
            return urnEndsWith(urn, icon);
        },
        isLabel: function (urn) {
            return urnEndsWith(urn, label);
        },
        isDisplay : function (urn) {
            return isForUrn(this.display, urn);
        },
        isDisplayMain : function (urn) {
            return this.isDisplay(urn) && urnEndsWith(urn, main);
        },
        isDisplayMainWithValue : function (data, value, oldValue) {
            return this.isDisplayMain(data.urn) &&
                data.value === value && (oldValue ? data.oldValue === oldValue : true);

        },
        isAdditional: function (urn) {
            return this.isDisplay(urn) && urnEndsWith(urn, additional);
        },
        isVideoStream: function (urn) {
            return this.isDisplay(urn) && urnEndsWith(urn, videoStream);
        },
        isVideoStreamIndex: function (urn) {
            return this.isDisplay(urn) && urnEndsWith(urn, videoStreamIndex);
        },
        isForUrn: isForUrn,
        isResponseForMenuGetConfiguration: function (data) {
            return isResponseFor(data, this.menuChannel) && data.response.request.command === "GetConfiguration";
        },
        isMenuExecuteCameraRequest : function (data) {
            return isForUrn(this.menuExecute, data.urn) && data.value.indexOf("Cameras:") === 0;
        },
        isMenuConfigurationChanged: function (data) {
            return data.event && data.event.type === "Configuration" && data.event.configuration.urn === this.menuChannel;
        },
        isOutgoingCameraCall: function (data) {
            return this.isDisplayMainWithValue(data, displayMessages.outgoingCameraCall);
        },
        isOutgoingDoorStationCall: function (data) {
            return this.isDisplayMainWithValue(data, displayMessages.outgoingDoorCall);
        },
        isIncomingDoorCall: function (data) {
            return this.isDisplayMainWithValue(data, displayMessages.incomingDoorCall);
        },
        isRecallCall: function (data) {
            return this.isDisplayMainWithValue(data, displayMessages.recall);
        },
        isActiveDoorCall: function (data) {
            return this.isDisplayMainWithValue(data, displayMessages.activeDoorCall);
        },
        isIdle: function (data) {
            return this.isDisplayMainWithValue(data, displayMessages.idle);
        },
        isConfigurationCompleted: function (data) {
            return this.isDisplayMainWithValue(data, displayMessages.idle, displayMessages.configurationActive);
        },
        isDoorCallIdle: function (data) {
            return this.isDisplayMainWithValue(data, displayMessages.idle);
        },
        isNoConnectionToDcs: function (data) {
            return this.isDisplayMainWithValue(data, displayMessages.noConnectionToDCS);
        },
        init:  function (deviceName) {
            var dataPointUrnPart = "urn:gds:dp:" + deviceName + ".DcsVHsGUI",
                channelUrnPart = "urn:gds:chn:" + deviceName + ".DcsVHsGUI",
                makeUrn = function (urnPart, name) {
                    return urnPart + ":" + name;
                };
            //datapoint urns
            this.camera = makeUrn(dataPointUrnPart, "Camera");
            this.display = makeUrn(dataPointUrnPart, "Display");
            this.menu = makeUrn(dataPointUrnPart, "Menu");
            this.menuExecute = makeUrn(dataPointUrnPart, "Menu:Execute");
            this.doorOpener = makeUrn(dataPointUrnPart, "DoorOpener");
            this.ringTone = makeUrn(dataPointUrnPart, "RingTone");
            this.doorCall = makeUrn(dataPointUrnPart, "Call");
            this.F1 = makeUrn(dataPointUrnPart, "F1");
            this.F2 = makeUrn(dataPointUrnPart, "F2");
            this.cameraIndex = makeUrn(dataPointUrnPart, "Camera:Index");
            this.cameraState = makeUrn(dataPointUrnPart, "Camera:State");
            this.light = makeUrn(dataPointUrnPart, "Light");
            this.doorGarage = makeUrn(dataPointUrnPart, "GarageDoor");
            this.connectionState = makeUrn(dataPointUrnPart, "Connect:ConnectionState");
            this.cameraVideo = makeUrn(dataPointUrnPart, "CameraSwiper");
            this.connect = makeUrn(dataPointUrnPart, "Connect:Connect");
            this.disconnectReason = makeUrn(dataPointUrnPart, "Connect:DisconnectReason");
            //channel urns
            this.connectChannel = makeUrn(channelUrnPart, "Connect");
            this.menuChannel = makeUrn(channelUrnPart, "Menu");
        }

    };

}(window.Gira.DCS));
//# sourceURL=dcs.urns.js
