/*jslint browser: true*/
/*global ko, $, _*/

(function (ns) {
    "use strict";
    var DCS = ns,
        Messages = DCS.Messages;

    function Switch(saveCallbackFunc, cancelCallbackFunc, keyInMenu, makeMessagesWithCurrentValue, configuration, statusBarController) {
        var makeMessages = makeMessagesWithCurrentValue,
            key = keyInMenu,
            saveCallback = saveCallbackFunc,
            cancelCallback = cancelCallbackFunc,
            checked = ko.observable(false),
            isArmed = ko.observable(false),
            isConnected = ko.observable(false),
            isVisible = ko.computed(function () { return isArmed() && isConnected(); }),
            config = configuration,
            statusBar = statusBarController;

        function getOnOffString(value) {
            return value ? "On" : "Off";
        }

        checked.subscribe(function () {
            var onOff = getOnOffString(checked());
            saveCallback(_.map(makeMessages, function (makeMessage) { return makeMessage(onOff); }), false);
        });

        return {
            init: function (menuObj) {
                var val = menuObj[key];

                if (val !== undefined) {
                    checked(val);
                    isArmed(true);
                } else {
                    isArmed(false);
                }

                statusBar.doorautom(isArmed() && checked());
            },
            ok: function () {
                return undefined;
            },
            cancel: function () {
                cancelCallback();
            },
            getPersistedData: function () {
                return {};
            },
            isConnected: isConnected,
            model: {
                checked: checked,
                label: config.automaticDoorOpenerLabel,
                isVisible: isVisible
            }
        };
    }

    function createAutomaticDoorOpenerOnOff(saveCallbackFunc, cancelCallbackFunc, configuration, statusBarController) {
        return new Switch(saveCallbackFunc, cancelCallbackFunc, 'automaticDoorOpener', [Messages.setMenuValue.automaticDoorOpener], configuration, statusBarController);
    }

    DCS.Switch = Switch;
    DCS.createAutomaticDoorOpenerOnOff = createAutomaticDoorOpenerOnOff;
}(window.Gira.DCS));
//# sourceURL=settings.switch.js
