/*jslint browser: true*/
/*global $, ko*/
(function (ns) {
    "use strict";

    var cameraPopUp;

    cameraPopUp = function () {
        var self = this,
            popupVisibilitySeconds = 5,
            slideInClass = 'dcs-display-notification dcs-slideInToTop-videoPopUp',
            slideOutClass = 'dcs-display-notification dcs-slideOutFromTop-videoPopUp',
            timer = new window.Gira.DCS.Utils.Timer(popupVisibilitySeconds),
            transitionHandler = function (e) {
                if (e.currentTarget.className === slideInClass) {
                    self.sliderIsVisible = false;
                }
            };

        self.animationElementClass = ko.observable(slideInClass);
        self.slideDownTextOpacity = ko.observable(1);
        self.notificationIcon = ko.observable('');
        self.sliderIsVisible = false;
        self.slideUpPopUp = function () {
            self.animationElementClass(slideInClass);
        };
        self.transitionEndHandler = transitionHandler;

        self.resetSlidePopup  = function () {
            self.slideUpPopUp();
            self.sliderIsVisible = false;
            timer.pause();
        };
        self.slideDown = function (showWithoutTimer) {
            if (showWithoutTimer) {
                self.sliderIsVisible = true;
                self.animationElementClass(slideOutClass);
                return;
            }
            if (!self.sliderIsVisible) {
                self.sliderIsVisible = true;
                self.animationElementClass(slideOutClass);
                timer.setCallback(function () {
                    self.slideUpPopUp();
                });
                timer.start();
            }
        };
        self.setCameraPopUpDefaults = function () {
            var displayNotification = $('.dcs-display-notification')[0];
            self.resetSlidePopup();
            displayNotification.removeEventListener('webkitTransitionEnd', transitionHandler, false);
            displayNotification.addEventListener('webkitTransitionEnd', transitionHandler, false);
        };
    };
    ns.CameraPopUp = cameraPopUp;
}(window.Gira.DCS));
//# sourceURL= dcs.cameraPopUp.js