﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="xsltemplates.xsl"/>
    <xsl:output indent="yes" />
    <xsl:output method="html"/>
    <xsl:template match="/">
      <div>
      <xsl:variable name="detailId"><xsl:text>detail-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
      <div id="description-row" class="description-row" style="display: none;">
            <div class="function-name t1sw"> <xsl:value-of select="Channel/Description/Language[@Index = 0]" /></div>
            <div class="room-name t3gw"><xsl:value-of select="Channel/FunctionFolderText" /></div>
              <xsl:if test="Channel/@Index = 'tks'">
                  <div class="function-icon sprites {{{{dvicon_key}}}}"></div>
              </xsl:if>
              <xsl:if test="Channel/@Index = 'weather'">
                  <div class="function-icon sprites {{{{dvicon_weather}}}}"></div>
              </xsl:if>
        </div>
        <div class="detail">
            <xsl:attribute name="id">
              <xsl:copy-of select="$detailId" />
            </xsl:attribute>
            <div class="doorcom_img" style="background: url(../img/ no-repeat left top;">
              <xsl:attribute name="style">
                <xsl:text>background: url(img/</xsl:text>
                <xsl:value-of select="Channel/FolderImage"/>
                <xsl:text>) no-repeat left top;</xsl:text>
              </xsl:attribute>
            </div>
            <div class="tks_text_row">
                <div class="tks_text t2sg">{{langWorldDetail}}</div>
                <div class="tks_arrow sprites {{{{tile-arrow-right}}}} "></div>
            </div>
            <div class="world-detail-down-state"></div>
        </div>
        <script type="text/javascript">
          (function(){
            var detailId = '#<xsl:copy-of select="$detailId" />';
            var action = function(){
            <xsl:if test="Channel/@Index = 'tks'">
              if (window.Gira) {
                window.Gira.DCS.Controller.Tile.openTksView("templates/tks_view.xhtml", "#detail-view-top");
              }
            </xsl:if>
            <xsl:if test="Channel/@Index = 'weather'">
              if (window.Gira) {
                window.Gira.Weather.Controller.Tile.openView("templates/weather_view.xhtml", "#detail-view-top");
              }
            </xsl:if>
            }
            
            <xsl:text disable-output-escaping="yes"><![CDATA[ 
            registerEventsForSwipeableElement($(detailId),
              function(){
                $(detailId + '> .world-detail-down-state').css('display', 'block');
              },
              function(){
                $(detailId + '> .world-detail-down-state').css('display', 'none');
              },
              action
            );
            ]]></xsl:text>
          })();
        </script>
        </div>
    </xsl:template>
</xsl:stylesheet>

