﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <div>
    <xsl:variable name="detailId">detail-<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
    <xsl:call-template name="channel_detail_description_row"></xsl:call-template>
    <div class="detail detailflip">
      <xsl:attribute name="id">
        <xsl:copy-of select="$detailId" />
      </xsl:attribute>
      <xsl:attribute name="data-off-text">
        <xsl:value-of select="Channel/StatusTexts/Off"/>
      </xsl:attribute>
      <xsl:attribute name="data-on-text">
        <xsl:value-of select="Channel/StatusTexts/On"/>
      </xsl:attribute>
      <xsl:attribute name="data-on-off-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='OnOff']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-state-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='State']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-status-feedback">
        <xsl:value-of select="Channel/StatusLed/@Enable = 'true'"/>
      </xsl:attribute>
      <xsl:attribute name="data-channel-index">
        <xsl:value-of select="Channel/@Index"/>
      </xsl:attribute>
      <xsl:attribute name="data-container-index">
        <xsl:value-of select="Channel/@ContainerIndex"/>
      </xsl:attribute>
      <xsl:attribute name="data-count">
        <xsl:value-of select="Channel/@count"/>
      </xsl:attribute>
      
      <div class="coverflip-container">
        <div class="coverflip-viewsides">
          <div id="flip" class="coverflip-side front">
            <xsl:if test="Channel/StatusTexts/@Enable = 'true'">
              <div class="statusValue t2sg">
                <xsl:attribute name="id">
                  <xsl:value-of select="$detailId"/>_statusValue</xsl:attribute>
                <xsl:text>- - -</xsl:text>
              </div>
            </xsl:if>
            <div class="switch-container">
              <div>
                <xsl:attribute name="class">switch-button <xsl:if test="Channel/StatusLed/@Enable = 'false'">shadow</xsl:if></xsl:attribute>
                <div class="switch-button-top sprites {{{{detail-button-switch-2ho}}}}">
                  <span class="switch-text-on sprites {{{{label-button-on}}}}"></span>
                </div>
                <div class="switch-button-bottom sprites {{{{detail-button-switch-2hu}}}}">
                  <span class="switch-text-off sprites {{{{label-button-off}}}}"></span>
                </div>
              </div>
              <xsl:if test="Channel/StatusLed/@Enable = 'true'">
                <div>
                  <xsl:attribute name="class">switch-ring ring1 sprites {{statusring-<xsl:value-of select="Channel/StatusLed/@On"/>}}</xsl:attribute>
                </div>
                <div>
                  <xsl:attribute name="class">switch-ring ring2 sprites {{statusring-<xsl:value-of select="Channel/StatusLed/@Off"/>}}</xsl:attribute>
                </div>
              </xsl:if>
            </div>
            <div class="coverflip-background">
            </div>
            <xsl:if test="Channel/TimeSwitches/@Enable ='true'">
                <div class="timer-icon sprites {{{{gc4_button_timer}}}}"></div>
             </xsl:if>
          </div>
        </div>
      </div>  
      <script type="text/javascript">
        (function(){
        var detailId = '<xsl:value-of select="$detailId" />';
        var dataset = document.getElementById(detailId).dataset;
        var isStatusFeedbackEnabled = (dataset.statusFeedback === 'true');
        

        eventsOnSwitch(new Array(detailId, "switch-container", 'switch-button-top'), dataset.onOffId, 1);
        eventsOnSwitch(new Array(detailId, "switch-container", 'switch-button-bottom'), dataset.onOffId, 0);

        initSwitchButtonState(parseInt(ComClient.getTagValue(dataset.stateId),10), 'switch-container-' + dataset.containerIndex + '-' + dataset.channelIndex);

        if(isStatusFeedbackEnabled){
        /* status ring animation call */
        temporaryCaseSets.push(new CaseSet(dataset.stateId, CaseSetType.CONTENT)
        .addCase(new Case().setExpectedValue(1).setNewValue(true))
        .addCase(new Case().setExpectedValue(0).setNewValue(false))
        .setOnValueFunction(function(value) {
        changeSwitchButtonState(value, '#' + detailId);
        })
        );
        }
        <xsl:if test="Channel/StatusTexts/@Enable = 'true'">

          /**
          * Register CaseSet for status value and set functions on receive
          */
          temporaryCaseSets.push(new CaseSet(dataset.stateId, CaseSetType.CONTENT)
          .addCase(new Case().setExpectedValue(1).setNewValue(dataset.onText))
          .addCase(new Case().setExpectedValue(0).setNewValue(dataset.offText))
          .setOnValueFunction(function(value) {
          if ( !isValidString(value) ) {
          value = "<xsl:text>- - -</xsl:text>";
          }
          $('#' + detailId + '_statusValue').text(value);
          })
          );
        </xsl:if>

        <xsl:if test="Channel/TimeSwitches/@Enable ='true'">
          var timerFunctions = [{name: "switch", datapoint: dataset.onOffId, values: [1, 0]}];
          tsx.timer.registerTimer(detailId, 'switch', dataset.count, timerFunctions);
        </xsl:if>

          })();
      </script>
    </div>
    </div>
  </xsl:template>
</xsl:stylesheet>

