<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">

<!-- settings button for scene detail view -->
.sceneSettingsBtn{
    position: absolute;
    top: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn']/top" />px;
    left: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn']/left" />px;
    height: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn']/height" />px;
    width: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn']/width" />px;
    -webkit-border-radius: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn']/radius" />%;
    border: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn']/border" />px solid rgb(180,180,180);
    -webkit-box-shadow:0px 1px 0px 0px #ffffff, 0px 1px 0px 0px rgb(255,255,255) inset;
    background-color: transparent;
    display: inline-block;
    }

    .sceneSettingsBtn:before{
    content: "";
    display: block;
    position: absolute;
    border-radius: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn.before']/radius" />px;
    top: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn.before']/top" />px;
    left: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn.before']/left" />px;
    right: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn.before']/right" />px;
    bottom: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn.before']/bottom" />px;
    border: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn.before']/border" />px solid transparent;
    }
    
    .sceneSettingsBtnSprite{
    position: absolute;
    top: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn.sprite']/top" />px;
    left: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn.sprite']/left" />px;
    }

    .sceneSettingsBtn.down {
    border: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.setBtn']/border" />px solid rgb(180,180,180);
    background-color: rgb(200,200,200);
    -webkit-box-shadow:0px 1px 0px 0px #fff;
    }

    .detailscene {
    background-color: transparent !important;
    }
   
    #scene-settings {
    position: absolute;
    width: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings']/width" />px;
    height: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings']/height" />px;
    z-index: 1;
    background: #F4F4F4;
    top: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings']/top" />px;
    right: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings']/right" />px;
    }

    #scene-settings .settings-description-row {
    width: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.description-row']/width" />px;
    height: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.description-row']/height" />px;
    background-color: rgb( 235, 235, 235);
    }

    #scene-settings  .settings-description-row .settings-description-row-text {
    padding-top: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.description-row-text']/padding-top" />px;
    padding-left: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.description-row-text']/padding-left" />px;
    }

    #scene-settings .settings-row {
    border: none;
    border-top: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.settings-row']/border" />px solid #FFFFFF;
    border-bottom: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.settings-row']/border" />px solid #c8c8c8;
    width: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.settings-row']/width" />px;
    height: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.settings-row']/height" />px;
    position: relative;
    background-color: #F5F5F5;
    }

    #scene-settings .settings-row .settings-row-text{
    left: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.settings-row-text']/left" />px;
    position: absolute;
    width: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.settings-row-text']/width" />px;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
    }

    #scene-settings .main-menu-text{
    top: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.settings-row-text']/top-main" />px;
    }

    #scene-settings .down{
    background-color: #505050;
    }

    #scene-settings  .flow-top{
    height: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.flow-top']/height" />px;
    background: -webkit-linear-gradient(top, #141414 0%,#505050 100%);
    visibility: hidden;
    }

    #scene-settings  .settings-row .left,
    #scene-settings  .settings-row .right{
    position: absolute;
    left: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.row.left']/left" />px;
    top: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.row.left']/top" />px;
    }

    #scene-settings .settings-row .right{
    left: <xsl:value-of select="/metrics/scene/metric[@key = 'scene.settings.row.right']/left" />px;
    }

    #scene-settings .scene-controls {
    position: relative;
    height: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-controls']/height" />px;
    border: none;
    border-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #FFFFFF;
    border-bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #c8c8c8;
    }

   </xsl:template>
</xsl:stylesheet>
