<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">
html, body {
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.content']/height" />;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.content']/width" />;
    overflow: hidden;
    margin: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.content']/margin" />;
    padding: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.content']/padding" />;
    background-color: white;
    position: absolute;
    top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.content']/top" />;
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.content']/left" />;
}

*::selection {
    background:transparent;
}

* {
  -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
}

@font-face {
    font-family: 'UniversNextLight';
    src: url('../font/UniversNextW1G-Light.otf');
}

@font-face {
    font-family: 'UniversNextMedium';
    src: url('../font/UniversNextW1G-Medium.otf');
}

.t3sw {
    font-family: UniversNextMedium;
    color: #3c3c3c;
    font-size:  <xsl:value-of select="/metrics/font/metric[@key = 't3sw']/font-size" />px;
    line-height:  <xsl:value-of select="/metrics/font/metric[@key = 't3sw']/line-height" />px;
}

.t3gg {
    font-family: UniversNextMedium;
    color: #a0a0a0;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't3gg']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't3gg']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't3gg']/text-shadow-z" />px #FFFFFF;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't3gg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't3gg']/line-height" />px;
}

.t2sw {
    font-family: UniversNextMedium;
    color: #3c3c3c;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/line-height" />px;
}

.t2gw {
    font-family: UniversNextMedium;
    color: #a0a0a0;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/line-height" />px;
}

.t2sg {
    font-family: UniversNextMedium;
    color: #3c3c3c;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/text-shadow-z" />px #FFFFFF;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/line-height" />px;
}

.t2gg {
    font-family: UniversNextMedium;
    color: #a0a0a0;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't2gg']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't2gg']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't2gg']/text-shadow-z" />px #FFFFFF;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2gg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2gg']/line-height" />px;
}

.t2lgg {
    font-family: UniversNextLight;
    color: #a0a0a0 !important;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't2lgg']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't2lgg']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't2lgg']/text-shadow-z" />px #FFFFFF;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2lgg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2lgg']/line-height" />px;
}

.t2ws {
    font-family: UniversNextMedium;
    color: #ffffff;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't2ws']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't2ws']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't2ws']/text-shadow-z" />px rgba(0,0,0,0.35);
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2ws']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2ws']/line-height" />px;
}
    
.t2lsg {
    font-family: UniversNextLight;
    color: #3c3c3c;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2lsg']/font-size" />px;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't2lsg']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't2lsg']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't2lsg']/text-shadow-z" />px #FFFFFF;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2lsg']/line-height" />px;
}
.t2lws {
    font-family: UniversNextLight;
    color: #ffffff;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2lws']/font-size" />px;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't2lws']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't2lws']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't2lws']/text-shadow-z" />px rgba(0,0,0,0.35);
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2lws']/line-height" />px;
    }

.t2lsw {
    font-family: UniversNextLight;
    color: #3c3c3c;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2lsw']/font-size" />px;    
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2lsw']/line-height" />px;
    }

    .t1sw {
    font-family: UniversNextMedium;
    color: #3c3c3c;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't1sw']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't1sw']/line-height" />px;
}

.t1ws {
    font-family: UniversNextMedium;
    color: #ffffff;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/line-height" />px;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't1ws']/text-shadow-z" />px rgba(0, 0, 0, 0.35);
}

.t1gw {
    font-family: UniversNextMedium;
    color: #a0a0a0;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't1gw']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't1gw']/line-height" />px;
    }

.t1sg {
    font-family: UniversNextMedium;
    color: #3c3c3c;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't1sg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't1sg']/line-height" />px;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't1sg']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't1sg']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't1sg']/text-shadow-z" />px #FFFFFF;
    }

    .t1gg {
    font-family: UniversNextMedium;
    color: #a0a0a0;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't1sg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't1sg']/line-height" />px;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't1sg']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't1sg']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't1sg']/text-shadow-z" />px #FFFFFF;
    }
.t3sg {
    font-family: UniversNextMedium;
    color: #3c3c3c;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't3sg']/font-size" />px;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't3sg']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't3sg']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't3sg']/text-shadow-z" />px #FFFFFF;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't3sg']/line-height" />px;
	}
.t3lsg {
    font-family: UniversNextLight;
    color: #3c3c3c;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't3lsg']/font-size" />px;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't3lsg']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't3lsg']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't3lsg']/text-shadow-z" />px #FFFFFF;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't3lsg']/line-height" />px;
    }
    
.t3lsw {
    font-family: UniversNextLight;
    color: #3c3c3c;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't3lsg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't3lsg']/line-height" />px;
	}
  
.t3lws {
    font-family: UniversNextLight;
    color: #FFFFFF;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't3lsg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't3lsg']/line-height" />px;
	}
    
.t3lgg {
    font-family: UniversNextLight;
    color: #a0a0a0;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't3lgg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't3lgg']/line-height" />px;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't3lgg']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't3lgg']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't3lgg']/text-shadow-z" />px #FFFFFF;
    }

.t3gw {
	font-family: UniversNextMedium;
	color: #a0a0a0;
	font-size: <xsl:value-of select="/metrics/font/metric[@key = 't3gw']/font-size" />px;
	line-height: <xsl:value-of select="/metrics/font/metric[@key = 't3gw']/line-height" />px;
    }

    .t3ws {
    font-family: UniversNextMedium;
    color: #ffffff;
    text-shadow: <xsl:value-of select="/metrics/font/metric[@key = 't3ws']/text-shadow-x" />px <xsl:value-of select="/metrics/font/metric[@key = 't3ws']/text-shadow-y" />px <xsl:value-of select="/metrics/font/metric[@key = 't3ws']/text-shadow-z" />px rgba(0,0,0,0.35);
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't3ws']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't3ws']/line-height" />px;
    }
    .css1{
    -webkit-filter: drop-shadow(0px 3px 5px rgba(0,0,0, 0.2));
    }

    .css2{
    -webkit-filter: drop-shadow(0px 1px 2px rgba(0,0,0, 0.3));
    }

    .css3{
    -webkit-filter: drop-shadow(0px 8px 5px rgba(0,0,0, 0.5));
    }

    .css4{
    -webkit-filter: drop-shadow(0px 2px 2px rgba(0,0,0, 0.2));
    }

    .css5{
    background: -webkit-lineargradient(top, #141414 0%,#505050 100%);
    }

    .css6{
    -webkit-filter: blur(3px); filter: url(#blur-effect-1);
    }

    .css7a{
    background: -webkit-linear-gradient(top, #c8c8c8 0%,#e6e6e6 100%);
    }

    .css7b{
    background: -webkit-linear-gradient(bottom, #c8c8c8 0%,#e6e6e6 100%);
    }

    .css8a{
    background: -webkit-linear-gradient(top, #f5f5f5 100%,#f5f5f5 65%);
    }

    .css8b{
    background: -webkit-linear-gradient(bottom, #f5f5f5 100%,#f5f5f5 65%);
    }

    .led-color-0{
    background: #c8c8c8;
    }

    .led-color-1{
    background: #dc3c3c;
    }

    .led-color-2{
    background: #bedc00;
    }

    .led-color-3{
    background: #ff9b00;
    }

    .led-color-5{
    background: #78b4f0;
    }

    .deleteButton{
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton158']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton158']/height" />px;
    border:1px solid rgb(220,60,60);
    -webkit-border-radius:18px;
    -webkit-box-shadow:0px 1px 0px 0px
    #ffffff, 0px 1px 0px 0px #ffffff inset;
    background-color:transparent;
    display:inline-block;
    font-family: 'UniversNextLight';
    color: rgb(220,60,60);
    font-size: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton158']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton158']/line-height" />px;
    text-decoration:none;
    text-align:center;
    text-shadow:0px 1px 0px #ffffff;
    }

    .deleteButton.down{
    -webkit-box-shadow:
    0px 1px 0px 0px #ffffff;
    background-color: rgb(220,60,60);
    color: rgb(255,255,255);
    text-shadow:0px -1px 0px rgba(255,255,255,0.35);
    }

    .deleteButton.inactive{
    border:1px solid rgb(180,180,180);
    color: rgb(200,200,200);
    text-shadow:0px 1px 0px rgba(255,255,255,1);
    }

    .cssButton158{
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton158']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton158']/height" />px;
    border: 1px solid #b4b4b4;
    -webkit-border-radius: 18px;
    -webkit-box-shadow: 0px 1px 0px 0px #ffffff, 0px 1px 0px 0px #ffffff inset;
    background-color: transparent;
    display: inline-block;
    font-family: UniversNextLight;
    color: #3c3c3c;
    font-size: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton158']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton158']/line-height" />px;
    text-decoration: none;
    text-align: center;
    text-shadow: 0px 1px 0px #ffffff;
    }

    .cssButton158.inactive{
    color: #c8c8c8;
    }

    .cssButton158.down{
    -webkit-box-shadow: 0px 1px 0px 0px #ffffff;
    background-color: #c8c8c8 !important;
    color: #ffffff;
    text-shadow: 0px -1px 0px rgba(0,0,0,0.35);
    }

    .CSSButton170
    {
    width:<xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton170']/width"/>px;
    height:<xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton170']/height"/>px;
    border:1px solid #b4b4b4;
    -webkit-border-radius:18px;
    -webkit-box-shadow:0px 1px 0px 0px #ffffff, 0px 1px 0px 0px #ffffff inset;
    background-color:transparent;
    display:inline-block;
    font-family: UniversNextLight;
    color:#3c3c3c;
    font-size:<xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton170']/font-size"/>px;
    line-height:<xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton170']/line-height"/>px;
    text-decoration:none;
    text-align:center;
    text-shadow:0px 1px 0px #ffffff;
    }

    .CSSButton170.down{
    -webkit-box-shadow: 0px 1px 0px 0px #ffffff !important;
    background-color:#c8c8c8!important;
    color:#ffffff !important;
    text-shadow:0px -1px 0px rgba(0,0,0,0.35) !important;
    }

    .CSSButton170.inactive{
    color:#c8c8c8;
    }

    .cssButton170 .arrowLeft {
    position: absolute;
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.row.left']/margin-top" />px;
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.row.left']/margin-left" />px;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.button.arrow.icon']/top" />px;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.button.arrow.icon']/left" />px;
    }

    .cssButton170 .arrowRight {
    position: absolute;
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.row.left']/margin-top" />px;
    margin-right: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.row.right']/margin-right" />px;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.button.arrow.icon']/top" />px;
    right: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.button.arrow.icon']/right" />px;
    }

    .cssButton180{
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton180']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton180']/height" />px;
    border: 1px solid #b4b4b4;
    -webkit-border-radius: 18px;
    -webkit-box-shadow: 0px 1px 0px 0px #ffffff, 0px 1px 0px 0px #ffffff inset;
    background-color: transparent;
    display: inline-block;
    font-family: UniversNextLight;
    color: #3c3c3c;
    font-size: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton180']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'CSSButton180']/line-height" />px;
    text-decoration: none;
    text-align: center;
    text-shadow: 0px 1px 0px #ffffff;
    }

    .cssButton180.inactive{
    color: #c8c8c8;
    }

    .cssButton180.down{
    -webkit-box-shadow: 0px 1px 0px 0px #ffffff;
    background-color: #c8c8c8;
    color: #ffffff;
    text-shadow: 0px -1px 0px rgba(0,0,0,0.35);
    }

    .cssButtonRtc{
    height:34px;
    width:34px;
    -webkit-border-radius:50%;
    border: 1px solid rgb(180,180,180);
    -webkit-box-shadow:0px 1px 0px 0px #ffffff, 0px 1px 0px 0px rgb(255,255,255) inset;
    background-color:transparent;
    display:inline-block;
    }

    .cssButtonRtc:before{
    content: "";
    display: block;
    position: absolute;
    top: -5px;
    left: -15px;
    right: -15px;
    bottom: -5px;
    border: 5px solid transparent;
    }

    .cssButtonRtc .sprites{
    position: relative;
    top: -1px;
    left: -1px;
    }

    .cssButtonRtc.down{
    background-color: rgb(200,200,200);
    -webkit-box-shadow:0px 1px 0px 0px #fff;
    }

    html * {
    -webkit-user-select: none;
    }
    html * {
    -webkit-user-select: none;
    }

    #divider {
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.divider']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.divider']/height" />px;
    background-color: #C8C8C8;
    margin-left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.divider']/margin-left" />px;
    }
    
    .center-vertical {
	margin-left: auto;
	margin-right: auto;
	}

/* statusbar */
#statusbar {
    font-family: UniversNextLight;
    font-size: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar']/font-size" />px;
    color: #3C3C3C;
    position: relative;
}

.status-display .statusbar-icons {
    padding-bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons']/margin-bottom" />px;
    padding-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons']/margin-top" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons']/height" />px;
    right: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons']/right" />px;
    display: block;
    position: relative;   
}

.status-display .statusbar-icons div {
    vertical-align: middle;
    display: inline;
    float: right;
    bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons.temp-out-text']/bottom" />px;
    line-height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons']/line-height" />px;
    }
    
.status-display .statusbar-icons .system-configuration
{
    float: left;
    margin-left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons.system-configuration']/margin-left" />px;
    max-width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons.system-configuration']/max-width" />px;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons.system-configuration']/width" />px;
    white-space: nowrap;
    overflow: hidden;
    text-align: left;
}

.status-display .statusbar-icons .status-element-icons {
    top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-element-icons']/top" />px;
    position: relative;
}
    
.status-display .statusbar-icons .status-element-icons div{
    margin-left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-element-icons']/element-spacing" />px;
    float: right;
}

.status-display .statusbar-icons .status-element {
    margin-left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons']/element-spacing" />px;
}

.status-display .statusbar-icons .temp-out-txt, .status-display .statusbar-icons .temp-in-txt{
    margin-left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons']/icon-spacing" />px;
    max-width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.statusbar-icons.temp-out-text']/max-width" />px;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
}


#divider-sb {
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.divider-sb']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.divider-sb']/height" />px;
    background-color: #C8C8C8;
    margin-left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.divider-sb']/margin-left" />px;
    float: none;
    clear: both;
}

/* branding row */
#branding-row {
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.branding-row']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.branding-row']/height" />px;
    position: relative;
    
}

#branding-row #title {
      position: relative;
      top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.branding-row.title']/top" />px;
      left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.branding-row.title']/left" />px;
      width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.branding-row.title']/width" />px;
}

#divider-br {
      position: absolute;
      width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.branding-row.divider-br']/width" />px;
      height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.branding-row.divider-br']/height" />px;
      background-color: #C8C8C8;
      left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.branding-row.divider-br']/left" />px;
      top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.branding-row.divider-br']/top" />px;
}

/* navbar */
#navbar {
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar']/width" />px;
    min-height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar']/min-height" />px;
    }

    #navbar .btnBack,
    #navbar .btnHome,
    #navbar .btnInfo,
    #navbar .btnSettings,
    #navbar .btnGridMode,
    #navbar .btnListMode {
    position: absolute;
    top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons']/top" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons']/height" />px;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons']/width" />px;
    border: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons']/border" />px solid #B4B4B4;
    border-top-left-radius: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons']/radius" />px;
    border-top-right-radius: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons']/radius" />px;
    border-bottom-left-radius: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons']/radius" />px;
    border-bottom-right-radius: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons']/radius" />px;
    background-color: #FFFFFF;
    margin: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons']/margin" />px;
    }

    #navbar .btnBack:before,
    #navbar .btnHome:before,
    #navbar .btnInfo:before,
    #navbar .btnSettings:before,
    #navbar .btnGridMode:before,
    #navbar .btnListMode:before {
    content: "";
    display: block;
    position: absolute;
    top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons.before']/top" />px;
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons.before']/left" />px;
    right: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons.before']/right" />px;
    bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons.before']/bottom" />px;
    border: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons.before']/border" />px solid transparent;
    }

    #navbar .btnBackSprite,
    #navbar .btnHomeSprite,
    #navbar .btnInfoSprite,
    #navbar .btnSettingsSprite,
    #navbar .btnGridModeSprite,
    #navbar .btnListModeSprite {
    position: absolute;
    top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons.sprite']/top" />px;
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons.sprite']/left" />px;
    }

    #navbar .down {
    background-color: #C8C8C8;
    }
    #navbar .active {
    border: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.navbuttons.active']/border" />px solid #BEDC00;
    background-color: #bedc00;
    }

    #navbar .btnBack {
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.btnBack']/left" />px;
    }

    #navbar .btnHome {
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.btnHome']/left" />px;
    }

    #navbar .btnInfo {
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.btnInfo']/left" />px;
    display: none;
    }

#navbar .btnSettings {
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.btnSettings']/left" />px;
    }

#navbar #btnListMode {
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.btnListMode']/left" />px;
    }

#navbar .btnGridMode {
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.btnGridMode']/left" />px;
}

    #navbar #divider-nb {
    position: relative;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.divider-nb']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.divider-nb']/height" />px;
    background-color: #C8C8C8;
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.divider-nb']/left" />px;
    top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.navbar.divider-nb']/top" />px;
 }

/* breadcrumb */
#breadcrumb, #breadcrumb-detail{
    position: relative;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.breadcrumb']/width" />px;
    margin-left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.breadcrumb']/margin-left" />px;
    overflow: hidden;
}


#breadcrumb div, #breadcrumb-detail  div {
    padding-bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.breadcrumb']/margin-bottom" />px;
    padding-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.breadcrumb']/margin-top" />px;
}

#breadcrumb-detail div{
    padding-bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.breadcrumb']/margin-bottom-detail" />px !important;
}

#breadcrumb #room, #breadcrumb-detail #room{
    float: left;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

#breadcrumb #room{
    max-width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.breadcrumb']/width" />px;
}

#breadcrumb-detail #room{
    max-width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.breadcrumb-detail']/width" />px;
}

#breadcrumb #function{
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
}

/* content */
#content {
    position: relative;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.content']/width" />px;
    }

#content #detail-view {
  width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.detail-view']/width" />px;
}

#content .description-row-container {
	height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.description-row-container']/height" />px;
}

#content .description-row {
    clear: left;
	height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.description-row']/height" />px;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.description-row']/width" />px;
    margin-left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.description-row']/margin-left" />px;
    position: absolute;
    opacity: 0;
	-webkit-transform: translateZ(0);
}

#content .description-row.active {
	opacity: 1;
}

#content .description-row .function-name {
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.description-row.function-name']/width" />px;	
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
    padding-top: 7px;
    }

#content .description-row .room-name {
    margin-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.description-row.room-name']/marginTop" />px;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.description-row.room-name']/width" />px;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
      padding-top: 6px;
      }

#content .description-row .function-icon {
    position: absolute;
    top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.description-row.function-icon']/top" />px;
    right: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.description-row.function-icon']/right" />px;
    }

#content .detail {
    position: relative;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.detail']/height" />px;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.detail']/width" />px;
    background-color: #F5F5F5;
  }

#content .detail-view-white {
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.detail-view-white']/height" />px;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.detail-view-white']/width" />px; 
    background-color: #fff;
}

    .slide-container {
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container']/height" />px !important;
    padding-right: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.description-row']/margin-left" />px;
    }

    .slide-container .tile-container{
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.tile']/height" />px;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.tile']/width" />px;
    display: table-cell;
}

.slide-container .tile-grid-row{
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.row']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.tile']/height" />px;
    display: table;
}

.slide-container .divider-big{
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_big']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_big']/height" />px;
    background-color: #C8C8C8;
    border-bottom-color: #FFFFFF;
    border-bottom-style: solid;
    border-bottom-width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_big']/border-bottom-width" />px;
    display: inline-block;
}

.slide-container .grey-pix-large{
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_large']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_large']/height" />px;
    background-color: #C8C8C8;
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_large']/left" />px;
    top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_large']/top" />px;
    position: relative;
    margin-bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_large']/margin-bottom" />px;
    z-index: 199;
}

.slide-container .grey-pix-small-one{
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_small_one']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_small_one']/height" />px;
    background-color: #C8C8C8;
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_small_one']/left" />px;
    top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_small_one']/top" />px;
    position: relative;
    margin-bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_small_one']/margin-bottom" />px;
    z-index: 199;
}
    
.slide-container .grey-pix-small-two{
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_small_two']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_small_two']/height" />px;
    background-color: #C8C8C8;
    left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_small_two']/left" />px;
    top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_small_two']/top" />px;
    position: relative;
    margin-bottom: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.grey_pix_small_two']/margin-bottom" />px;
    z-index: 199;
}


.slide-container .divider-small-vertical{
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_small_vertical']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_small_vertical']/height" />px;
    background-color: white;
    border-left-color: #C8C8C8;
    border-left-style: solid;
    border-left-width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_small_vertical']/border-left-width" />px;
    display: inline-block;
}

.slide-container .divider-small{
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_small']/width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_small']/height" />px;
    background-color: #C8C8C8;
    border-bottom-color: #FFFFFF;
    border-bottom-style: solid;
    border-bottom-width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_small']/border-bottom-width" />px;
    float: left;
}
    
.slide-container .space{
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.space']/width - /metrics/layout/metric[@key = 'layout.container.divider_small_vertical']/border-left-width" />px;
    height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.space']/height - /metrics/layout/metric[@key = 'layout.container.divider_small']/border-bottom-width" />px;
    position: relative;
    float: left;
    background-color: white;
    border-left-color: #C8C8C8;
    border-left-style: solid;
    border-left-width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_small_vertical']/border-left-width" />px;
	
    border-top-color: #C8C8C8;
    border-top-style: hidden;
    border-top-width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_small']/border-bottom-width" />px;
    padding-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.container.divider_small']/padding-top" />px;
	
    display: inline-block;
}

.slide-container .large-tile-top{
    border-top-style: solid;
    padding-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.slide-container.large-tile']/padding-top" />px;
  }

  .slide-container .large-tile-bottom{
  height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.slide-container.large-tile']/height" />px;
  }

  /* bulletbar */
  .bulletbar {
  text-align: center;
  height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.bulletbar']/height" />px;
    width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.bulletbar']/width" />px;
    font-size: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.bulletbar']/font-size" />;
    margin-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.bulletbar']/margin-top" />px;
    margin-left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.bulletbar']/margin-left" />px;
}

.bullets{
    display: inline-block;
}

.bullets.first{
    margin-right: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.bulletbar.bullets.first']/margin-right" />px;
}

.bullets.middle{
    margin-right: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.bulletbar.bullets.middle']/margin-right" />px;
}

.bullets.last{
}

.bullets.active{
position: relative;
top:  <xsl:value-of select="/metrics/layout/metric[@key = 'layout.bulletbar.bullets.active']/top" />px;
}

.view-container {
position: absolute;
top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.view-container']/top" />px;
background: white;
-webkit-animation-duration: 0.5s;
animation-duration: 0.5s;
overflow: hidden;
}

.notransition {
-webkit-transition: none !important;
-moz-transition: none !important;
-o-transition: none !important;
-ms-transition: none !important;
transition: none !important;
}

#enet-icon {
position: absolute;
left: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.enet']/left" />px;
top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.statusbar.enet']/top" />px;
float: left;
}

.world-detail-down-state{
  display: none;
  position:absolute;
  top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.detail']/top" />px;
  height: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.detail']/height" />px;
  width: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.detail']/width" />px;
  z-index: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.detail']/z-index" />;
    background-color:rgba(0,0,0,0.2);
}

<!-- background class for "sliderbutton" on tile (i.e. I/O buttons); the name sliderbutton is a bit misleading but was taken from
the design concept -->
    .sliderbutton-bg {
    width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-bg']/width" />px;
    height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-bg']/height" />px;
    border: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-bg']/border" />px solid #c0c0c0;
    border-radius: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-bg']/border-radius" />px;
    background: -webkit-linear-gradient(top, rgba(255,255,255,1) 0%,rgba(235,235,235,1) 100%);
    -webkit-filter: drop-shadow(0px 3px 5px rgba(0,0,0, 0.2));
    z-index: 1;
    position: absolute;
    }

    .sliderbutton-bg-down {
    background: -webkit-linear-gradient(top, rgba(230,230,230,1) 0%,rgba(215,215,215,1) 100%) !important;
    -webkit-filter: drop-shadow(0px 1px 2px rgba(0,0,0, 0.3));
    }

    .sliderbutton-bg-switch-down {
    background: -webkit-linear-gradient(top, rgba(230,230,230,1) 0%,rgba(215,215,215,1) 100%) !important;
    }

    <!-- foreground class for sliderbutton on tile (i.e. I/O buttons); the name sliderbutton is a bit misleading but was taken from
the design concept -->
.sliderbutton-fg {
    width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-fg']/width" />px;
    height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-fg']/height" />px;
    top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-fg']/top" />px; /* move on top of button background */
    left: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-fg']/left" />px;
    border-radius: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-fg']/border-radius" />px;
    background: -webkit-linear-gradient(top, rgba(235,235,235,1) 0%,rgba(250,250,250,1) 100%);
    z-index: 2;
    position: absolute;
}

<!-- down effect for foreground class -->
.sliderbutton-fg-down {
      background: -webkit-linear-gradient(top, rgba(215,215,215,1) 0%,rgba(230,230,230,1) 100%) !important;
}

<!-- class for the label on sliderbuttons (I/O, arrows, etc.) -->
.sliderbutton-label {
    top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-label']/top" />px; /* correction for button border */
    left: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.sliderbutton-label']/left" />px;
    position: relative;
    z-index: 3;
    }

.timer-icon{
    position: absolute;
    top:416px;
    left:389px;
    z-index: 3;
}

.color-picker-icon {
    position: absolute;
    top:20px;
    left:389px;
    z-index: 4;
}

.timer-icon:before{
      content: "";
      display: block;
      position: absolute;
      top: -5px;
      left: -15px;
      right: -15px;
      bottom: -5px;
      border: 5px solid transparent;
}

.button-red {
  height: 34px;
  width: 34px;
  -webkit-border-radius: 18px;
  border: 1px solid rgb(220,60,60);
  -webkit-box-shadow: 0px 1px 0px 0px #ffffff, 0px 1px 0px 0px rgb(255,255,255) inset;
  background-color: transparent;
  display: inline-block;
  float: left;
}

.button-green {
  height:34px;
  width:34px;
  -webkit-border-radius:18px;
  border: 1px solid rgb(170,210,0);
  -webkit-box-shadow:0px 1px 0px 0px #ffffff, 0px 1px 0px 0px rgb(255,255,255) inset;
  background-color:transparent;
  display:inline-block;
  float: left;
}

.button-grey {
  height:34px;
  width:34px;
  -webkit-border-radius:18px;
  border: 1px solid rgb(180,180,180);
  -webkit-box-shadow:0px 1px 0px 0px #ffffff, 0px 1px 0px 0px rgb(255,255,255) inset;
  background-color:transparent;
  display:inline-block;
  float: left;
}

.detailflip{
    background-color: transparent !important;
    }
    
     #flip{
    position: relative;
    width: 444px;
    height: 470px;
    z-index: 1;
    background: #F5F5F5;
    }

    td[colspan="4"]{
      width: auto;
    }

    table.t3lsg td.license-td{
        text-align: left;
        margin-left:3px;
        word-break: break-word;
        width: 200px !important;
    }

    table.t3lsg td.license-name-td{
      text-align: left;
      word-break: break-word;
      overflow: hidden;
      width: auto;
    }

  </xsl:template>
</xsl:stylesheet>
