<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template name = "dimmer-template">
        <xsl:param name = "color-picker" />
        <div>
            <xsl:variable name="detailId">detail-<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" />
            </xsl:variable>
            <xsl:variable name="container">
                <xsl:value-of select="Channel/@ContainerIndex" />
            </xsl:variable>
            <xsl:variable name="channel">
                <xsl:value-of select="Channel/@Index" />
            </xsl:variable>
            <xsl:call-template name="channel_detail_description_row"></xsl:call-template>
            <div class="detail detailflip">
                <xsl:attribute name="id"><xsl:copy-of select="$detailId" /></xsl:attribute>
                <xsl:variable name ="StatusValueEnable">
                    <xsl:value-of select="Channel/StatusValue/@Enable"></xsl:value-of>
                </xsl:variable>
                <xsl:attribute name="data-switch-id">
                    <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Switch' and @Name='OnOff']/@Id" />
                </xsl:attribute>
                <xsl:attribute name="data-brightness-id">
                    <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='Brightness']/@Id"/>
                </xsl:attribute>
                <xsl:attribute name="data-brightness-status-id">
                    <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Percent' and @Name='BrightnessStatus']/@Id" />
                </xsl:attribute>
                <xsl:attribute name="data-step-size">
                    <xsl:value-of select="Channel/UpdateOnChange/@Value"/>
                </xsl:attribute>
                <xsl:attribute name="data-channel-index">
                    <xsl:value-of select="Channel/@Index"/>
                </xsl:attribute>
                <xsl:attribute name="data-container-index">
                    <xsl:value-of select="Channel/@ContainerIndex"/>
                </xsl:attribute>
                <xsl:attribute name="data-count">
                    <xsl:value-of select="Channel/@count"/>
                </xsl:attribute>
                <div class="coverflip-container">
                    <div class="coverflip-viewsides">
                        <div id="flip" class="coverflip-side front">
                            <div class="dimabs-container">
                                <xsl:attribute name="id">dimabs-container-<xsl:copy-of select="$detailId" /></xsl:attribute>
                                <div class="bg sprites {{{{statusring-0}}}}"></div>
                                <div class="notouchdec"></div>
                                <div class="dec shadow">
                                    <xsl:attribute name="id">dec-<xsl:copy-of select="$detailId" /></xsl:attribute>
                                    <div class="decs sprites {{{{gc4_icon_config_minus}}}}"></div>
                                </div>
                                <div class="notouchinc"></div>
                                <div class="inc shadow">
                                    <xsl:attribute name="id">inc-<xsl:copy-of select="$detailId" /></xsl:attribute>
                                    <div class="incs sprites {{{{gc4_icon_config_plus}}}}"></div>
                                </div>
                                <div class="dimbutton sprites {{{{detail-button}}}}">
                                    <xsl:attribute name="id">dimbutton-<xsl:copy-of select="$detailId" /></xsl:attribute>
                                    <div class="dimbutton-touch">
                                        <div class="inner dimmer-text-on t2lgg">{{menuConfigOn}}</div>
                                        <div class="inner dimmer-text-off t2lgg">{{menuConfigOff}}</div>
                                        <xsl:if test="$StatusValueEnable='true'">
                                            <div class="inner set-unit t2gg">%</div>
                                            <div class="inner set-percent t1sg">
                                                <xsl:attribute name="id">set-percent-<xsl:copy-of select="$detailId" /></xsl:attribute>-
                                            </div>
                                        </xsl:if>
                                    </div>
                                </div>
                                <div class="coverflip-background">
                                </div>
                                <div class="knob-container">
                                    <div class="event-blocker"></div>
                                    <input type="text" style="display:none" class="knob"
                                           data-angleOffset="0"
                                           data-angleArc="360"
                                           data-min="0"
                                           data-max="100"
                                           data-thickness="0.15"
                                           data-displayInput="true"
                                           data-displayPrevious="true"
                                           data-step="1"
                                           data-inputColor="transparent">
                                        <xsl:attribute name="id">knob-<xsl:copy-of select="$detailId" />
                                        </xsl:attribute>
                                    </input>
                                </div>
                                <div class="mask sprites {{{{gc4_dim_innerring_mask}}}}"></div>
                            </div>
                            <xsl:if test="$color-picker='true'">
                                <div class="color-picker-icon sprites sprite_36x36_gc4_navicon_set"></div>
                            </xsl:if>
                            <xsl:if test="Channel/TimeSwitches/@Enable ='true'">
                                <div class="timer-icon sprites {{{{gc4_button_timer}}}}"></div>
                            </xsl:if>
                        </div>
                    </div>
                </div>
                <script type="text/javascript">
                    (function(){
                    var detailId = "<xsl:copy-of select="$detailId" />";
                    var dataset = document.getElementById(detailId).dataset;
                    var knobId = "#knob-"+detailId;
                    var dec = "#dec-"+detailId;
                    var inc= "#inc-"+detailId;
                    var button= "#dimbutton-"+detailId;
                    var container = "#dimabs-container-"+detailId;
                    var steps= parseInt(dataset.stepSize);
                    var detailIdSelector = "#" + detailId;

                    <xsl:if test="$color-picker='true'">
                        var colorPickerButton = $(detailIdSelector + ' .color-picker-icon');
                        var detailIdJquery = $(detailIdSelector);

                        registerEventsForSwipeableElement(colorPickerButton,
                            function() {
                                colorPickerButton.addClass(globals.timer.buttonDown);
                            },
                            function() {
                                colorPickerButton.removeClass(globals.timer.buttonDown);
                            },
                            function() {
                                coverflipFrontToBack(detailIdSelector, true);
                                loadView('templates/colorpicker_detail.xhtml', function (data) {
                                    detailIdJquery.find('.coverflip-viewsides').append(data);
                                });
                            }
                        );
                    </xsl:if>

        <xsl:text disable-output-escaping="yes"><![CDATA[
            /**
            * Create new knob with ids for elements, tag and step value
            */
            var knob = new DimmerAbsoluteController(knobId, dataset.brightnessId, dataset.brightnessStatusId, dataset.switchId, dec, inc, button, steps, container,
                      "{{gc4_icon_config_plus}}", "{{gc4_icon_config_minus}}", "{{detail-button}}",
                      "{{gc4_dim_hatch}}", "{{gc4_dim_ring}}", globals.dimmer.animationSpeed, globals.dimmer.inUseTimer);
            /**
            * Register CaseSet and set functions on receive
            */
            temporaryCaseSets.push(new CaseSet(dataset.brightnessStatusId, CaseSetType.VALUE)
            .setOnValueFunction(function(value) {
              value = Round(value, 0);
              knob.update(value);
            }));
        ]]></xsl:text>

                    <xsl:if test="Channel/TimeSwitches/@Enable ='true'">
                        var timerFunctions = [{name: "dim", datapoint: dataset.brightnessId, values: [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100]}];
                        tsx.timer.registerTimer(detailId, 'dimmer', dataset.count, timerFunctions);
                    </xsl:if>

                    })();

                </script>

            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>