﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">

 

    /* dimabs container */
    .dimabs-container {
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container']/height" />px;
    position: relative;
    text-align: center;
    box-sizing: border-box;
    }

    .dimabs-container .knob-container {
    padding-top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.knob-container']/padding" />px;
    position: relative;
    z-index: 2;
    }

    .dimabs-container .knob-container canvas {
    cursor: pointer;
    }

    .dimabs-container .event-blocker {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.event-blocker']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.event-blocker']/left" />%;
    width:  <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.event-blocker']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.event-blocker']/height" />px;
    margin-left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.event-blocker']/margin-left" />px;
    border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.event-blocker']/border-radius" />px;
    position: absolute;
    }


    .dimabs-container .inc.shadow,
    .dimabs-container .dec.shadow {
    -webkit-box-shadow: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc']/shadow" /> #fff, inset <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc']/inset" /> #fff;
    }

    .dimabs-container .inc,
    .dimabs-container .dec {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc']/left" />px;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.css']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.css']/height" />px;
    margin: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc']/margin" />;
    border: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc']/border" />px solid rgb(180,180,180);
    border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc']/border-radius" />px;
    position: absolute;
    -webkit-transform: translateZ(0);
    background-color: rgb(245,245,245);
    cursor: pointer;
    z-index: 10;
    }

    .dimabs-container .inc:before,
    .dimabs-container .dec:before {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc.before']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc.before']/left" />px;
    right: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc.before']/right" />px;
    bottom: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc.before']/bottom" />px;
    border: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc.before']/border" />px solid transparent;
    border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.inc.before']/border-radius" />px;
    position: absolute;
    display: block;
    content: "";
    }

    .dimabs-container .notouchdec,
    .dimabs-container .notouchinc {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.notouchdec']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.notouchdec']/left" />px;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.notouchdec']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.notouchdec']/height" />px;
    border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.notouchdec']/border-radius" />px;
    position: absolute;
    z-index: 9;
    }


    .dimabs-container .notouchinc {
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.notouchinc']/left" />px;}


    .dimabs-container .dec {
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.dec']/left" />px;
    }

    .dimabs-container .incs,
    .dimabs-container .decs {
    position: absolute;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.incs']/left" />px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.button-config.incs']/top" />px;
    }

    .dimabs-container .down {
    background-color: rgb(200,200,200);
    -webkit-box-shadow: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.down']/shadow" /> #fff !important;
    }

    .dimabs-container .mask {
    pointer-events: none;
    position: absolute;
    z-index: 3;
    text-align: center;
    top: 0px;
    }
    
    .dimabs-container .dimbutton .inner {
    width:  <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.inner.all']/width" />px;
    left:   <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.inner.all']/left" />%;
    margin-left:  <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.inner.all']/margin-left" />px;
    position: absolute;
    display: block;
    z-index: 9;
    }
    .dimabs-container .dimbutton .dimbutton-touch .set-percent {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.inner.set-percent']/top" />px;
    }
    .dimabs-container .dimbutton .dimbutton-touch .set-unit {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.inner.set-unit']/top" />px;
    }
    .dimabs-container .dimbutton .dimbutton-touch .dimmer-text-on {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.inner.text-on-off']/top" />px;
    opacity: 0;
    }
    .dimabs-container .dimbutton .dimbutton-touch .dimmer-text-off {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.inner.text-on-off']/top" />px;
    opacity: 1;
    }

    .dimabs-container .bg {
    position: absolute;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.innerring-bg']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.innerring-bg']/left" />px;
    }

    .dimabs-container .dimbutton {
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.dimbutton']/left" />px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.dimbutton']/top" />px;
    border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.dimbutton']/radius" />px;
    position: absolute;
    z-index: 5;
    }

    .dimabs-container .dimbutton .dimbutton-touch {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.dimbutton.notouch']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.dimbutton.notouch']/left" />px;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.dimbutton.notouch']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.dimbutton.notouch']/height" />px;
    border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'DimmerAbsolute.container.dimbutton.notouch']/border-radius" />px;
    position: absolute;
    }

  </xsl:template>
</xsl:stylesheet>