// modified by NoEng 2014
// - added touch support
// - added idangerous swiper support instead css overflow scrolling
//
// original library content:
// jQuery List DragSort v0.5.2
// Website: http://dragsort.codeplex.com/
// License: http://dragsort.codeplex.com/license
(function ($) {

    $.fn.dragsort = function (options) {
        if (options == "destroy") {
            $(this.selector).trigger("dragsort-uninit");
            return;
        }

        var opts = $.extend({}, $.fn.dragsort.defaults, options);
        var lists = [];
        var list = null, lastPos = null;

        this.each(function (i, cont) {

            //if list container is table, the browser automatically wraps rows in tbody if not specified so change list container to tbody so that children returns rows as user expected
            if ($(cont).is("table") && $(cont).children().size() == 1 && $(cont).children().is("tbody"))
                cont = $(cont).children().get(0);

            var newList = {
                draggedItem: null,
                placeHolderItem: null,
                pos: null,
                offset: null,
                offsetLimit: null,
                scroll: null,
                container: cont,
                swiper: null,
                swiperWrapper: null,
                lastY: 0,
                lastX: 0,
                NON_VALID: -9999,


                init: function () {
                    //set options to default values if not set
                    opts.tagName = $(this.container).children().size() == 0 ? "li" : $(this.container).children().get(0).tagName.toLowerCase();
                    if (opts.itemSelector == "")
                        opts.itemSelector = opts.tagName;
                    if (opts.dragSelector == "")
                        opts.dragSelector = opts.tagName;
                    if (opts.placeHolderTemplate == "")
                        opts.placeHolderTemplate = "<" + opts.tagName + ">&nbsp;</" + opts.tagName + ">";

                    //listidx allows reference back to correct list variable instance
                    $(this.container).attr("data-listidx", i).bind("mousedown touchstart", this.grabItem).bind("dragsort-uninit", this.uninit);
                    this.styleDragHandlers(true);

                    this.swiper = $(menuId).data("settingsSwiper");
                    this.swiperWrapper = $(opts.scrollContainer).find(".swiper-wrapper");
                },

                uninit: function () {
                    var list = lists[$(this).attr("data-listidx")];
                    $(list.container).unbind("mousedown touchstart", list.grabItem).unbind("dragsort-uninit");
                    list.styleDragHandlers(false);
                },

                getItems: function () {
                    return $(this.container).children(opts.itemSelector);
                },

                styleDragHandlers: function (cursor) {
                    this.getItems().map(function () { return $(this).is(opts.dragSelector) ? this : $(this).find(opts.dragSelector).get(); }).css("cursor", cursor ? "pointer" : "");
                },

                grabItem: function (e) {
                    var list = lists[$(this).attr("data-listidx")];
                    var item = $(e.target).closest("[data-listidx] > " + opts.tagName).get(0);
                    var insideMoveableItem = list.getItems().filter(function () { return this == item; }).size() > 0;

                    //if not left click or if clicked on excluded element (e.g. text box) or not a moveable list item return
                    if ((e.which != 1 && e.type != "touchstart") || $(e.target).is(opts.dragSelectorExclude) || $(e.target).closest(opts.dragSelectorExclude).size() > 0 || !insideMoveableItem) {
                        return;
                    }

                    //prevents selection, stops issue on Fx where dragging hyperlink doesn't work and on IE where it triggers mousemove even though mouse hasn't moved,
                    //does also stop being able to click text boxes hence dragging on text boxes by default is disabled in dragSelectorExclude
                    if ($(e.target).is(opts.dragSelector)) {
                        e.preventDefault();
                    }

                    //change cursor to move while dragging
                    var dragHandle = e.target;
                    while (!$(dragHandle).is(opts.dragSelector)) {
                        if (dragHandle == this) return;
                        dragHandle = dragHandle.parentNode;
                    }
                    $(dragHandle).attr("data-cursor", $(dragHandle).css("cursor"));
                    $(dragHandle).css("cursor", "move");

                    //on mousedown wait for movement of mouse before triggering dragsort script (dragStart) to allow clicking of hyperlinks to work
                    var listElem = this;
                    var trigger = function () {
                        list.dragStart.call(listElem, e);
                        $(list.container).unbind("mousemove touchmove", trigger);
                    };

                    var trigger2 = function () {
                        list.dragMove.call(listElem, e);
                    };

                    $(list.container).bind("mousemove touchmove", trigger).bind("mouseup touchend", function () { $(list.container).unbind("mousemove touchmove", trigger); $(dragHandle).css("cursor", $(dragHandle).attr("data-cursor")); });
                    $(list.container).bind("mousemove touchmove", trigger2).on("mouseup touchend", function () { $(list.container).unbind("mousemove touchmove", trigger2) });
                },

                dragMove: function (elem, e) {
                    if (list == null || list.draggedItem == null || list.draggedItem == undefined) {
                        return;
                    }
                    //var swiper = $(menuId).data("settingsSwiper");
                    //var wrapper = $(opts.scrollContainer).find(".swiper-wrapper");
                    var descriptionTextView = list.swiperWrapper.find(".settings-description-text-item");

                    var smoothScrollTo = function (to) {
                        //var style = list.swiperWrapper[0].style;  // Need the DOM object
                        //var matrix = new WebKitCSSMatrix(style.webkitTransform);

                        var maxScroll = list.swiperWrapper.height() - $(opts.scrollContainer).height();
                        var offset = list.swiper.getWrapperTranslate('y');

                        if (to == "up") {
                            if (offset + 60 < 0) {
                                list.swiper.setWrapperTranslate(0, offset + 60, 0);
                                list.swiper.setWrapperTransition(250);
                                return;
                            }
                            else {
                                list.swiper.setWrapperTranslate(0, 0, 0);
                                list.swiper.setWrapperTransition(250);
                            }
                        }
                        if (to == "down") {
                            if (Math.abs(offset) <= maxScroll) {
                                list.swiper.setWrapperTranslate(0, offset - 60, 0);
                                list.swiper.setWrapperTransition(250);

                                return;
                            }
                            else {
                                list.swiper.setWrapperTranslate(0, -Math.abs(maxScroll + 90), 0);
                                list.swiper.setWrapperTransition(250);
                                return;
                            }
                        }
                    };

                    //var style = list.swiperWrapper[0].style;  // Need the DOM object
                    //var matrix = new WebKitCSSMatrix(style.webkitTransform);
                    var offset = list.swiper.getWrapperTranslate('y');



                    var elementPos = parseFloat(offset) + parseFloat(list.draggedItem[0].style.top);

                    //console.log('offset= ' + offset + ' elemPos=' + elementPos);
                    if (elementPos <= 0 && offset <= 0) {
                        smoothScrollTo("up");
                        list.preparePositions();
                        return;
                    }

                    // 
                    if (elementPos + 90 >= parseInt($(opts.scrollContainer).height()) - 60) {
                        smoothScrollTo("down");
                        list.preparePositions();
                        return;
                    }
                },

                // read the new positions from the list items (left,top,right,bottom)
                preparePositions: function () {
                    $(lists).each(function (i, l) { l.createDropTargets(); l.buildPositionTable(); });
                    lastPos = list.draggedItem.offset();
                },

                dragStart: function (e) {
                    if (list != null && list.draggedItem != null)
                        list.dropItem();

                    list = lists[$(this).attr("data-listidx")];
                    list.draggedItem = $(e.target).closest("[data-listidx] > " + opts.tagName)
                    opts.dragStart.apply(list.draggedItem);

                    //record current position so on dragend we know if the dragged item changed position or not, not using getItems to allow dragsort to restore dragged item to original location in relation to fixed items
                    list.draggedItem.attr("data-origpos", $(this).attr("data-listidx") + "-" + $(list.container).children().index(list.draggedItem));

                    //calculate mouse offset relative to draggedItem
                    var mt = parseInt(list.draggedItem.css("marginTop"));
                    var ml = parseInt(list.draggedItem.css("marginLeft"));
                    list.offset = list.draggedItem.offset();



                    var pageX = 0;
                    var pageY = 0;

                    if (e.type == "mousedown") {
                        pageX = e.pageX;
                        pageY = e.pageY;
                    }
                    else
                        if (e.type == "touchstart") {
                            pageX = e.originalEvent.changedTouches[0].clientX;
                            pageY = e.originalEvent.changedTouches[0].clientY;
                        }

                    list.offset.top = pageY - list.offset.top + (isNaN(mt) ? 0 : mt) - 1;
                    list.offset.left = pageX - list.offset.left + (isNaN(ml) ? 0 : ml) - 1;

                    //calculate box the dragged item can't be dragged outside of
                    if (!opts.dragBetween) {
                        var containerHeight = $(list.container).outerHeight() == 0 ? Math.max(1, Math.round(0.5 + list.getItems().size() * list.draggedItem.outerWidth() / $(list.container).outerWidth())) * list.draggedItem.outerHeight() : $(list.container).outerHeight();
                        list.offsetLimit = $(list.container).offset();
                        list.offsetLimit.right = list.offsetLimit.left + $(list.container).outerWidth() - list.draggedItem.outerWidth();
                        list.offsetLimit.bottom = list.offsetLimit.top + containerHeight - list.draggedItem.outerHeight();
                    }

                    //create placeholder item
                    var h = list.draggedItem.height();
                    var w = list.draggedItem.width();
                    if (opts.tagName == "tr") {
                        list.draggedItem.children().each(function () { $(this).width($(this).width()); });
                        list.placeHolderItem = list.draggedItem.clone().attr("data-placeholder", true);
                        list.draggedItem.after(list.placeHolderItem);
                        list.placeHolderItem.children().each(function () { $(this).css({ borderWidth: 0, width: $(this).width() + 1, height: $(this).height() + 1 }).html("&nbsp;"); });
                    }
                    else {
                        list.draggedItem.after(opts.placeHolderTemplate);
                        list.placeHolderItem = list.draggedItem.next().css({ height: h, width: w }).attr("data-placeholder", true);
                    }

                    if (opts.tagName == "td") {
                        var listTable = list.draggedItem.closest("table").get(0);
                        $("<table id='" + listTable.id + "' style='border-width: 0px;' class='dragSortItem " + listTable.className + "'><tr></tr></table>").appendTo("body").children().append(list.draggedItem);
                    }

                    //style draggedItem while dragging
                    var orig = list.draggedItem.attr("style");
                    list.draggedItem.attr("data-origstyle", orig ? orig : "");
                    list.draggedItem.css({ position: "absolute", "z-index": 999, height: h, width: w - 4, left: 2, backgroundColor: "#F5F5F5", "box-shadow": "0px 3px 5px rgba(0, 0, 0, .35)" });

                    //auto-scroll setup
                    list.scroll = { moveX: 0, moveY: 0, maxX: $(document).width() - $(window).width(), maxY: $(document).height() - $(window).height() };

                    //misc
                    $(lists).each(function (i, l) { l.createDropTargets(); l.buildPositionTable(); });
                    list.setPos(pageX, pageY);
                    $(document).bind("mousemove touchmove", list.swapItems);
                    $(document).bind("mouseup touchend", list.dropItem);
                    //$(list).bind("mouseleave mousecancel touchcancel touchleave",list.dropItem);
                    if (opts.scrollContainer != window && e.type.indexOf("touch") == -1) // needs a mouse to bind wheel
                        $(window).bind("wheel", list.wheel);
                },

                //set position of draggedItem
                setPos: function (x, y) {

                    //remove mouse offset so mouse cursor remains in same place on draggedItem instead of top left corner
                    var saveY = y;
                    var top = y - this.offset.top;
                    var left = x - this.offset.left;

                    if (typeof opts.containment != "undefined") {
                        var containment = $(opts.containment);
                        var boundary = containment.offset();
                        boundary.bottom = boundary.top + containment.height() - this.draggedItem.height();
                        boundary.right = boundary.left + containment.width() - this.draggedItem.width();
                        top = Math.min(boundary.bottom, Math.max(top, boundary.top));
                        left = Math.min(boundary.right, Math.max(left, boundary.left));
                    }

                    //limit top, left to within box draggedItem can't be dragged outside of

                    /*	if (!opts.dragBetween) 
                        {
                            top = Math.min(this.offsetLimit.bottom, Math.max(top, this.offsetLimit.top));
                            left = Math.min(this.offsetLimit.right, Math.max(left, this.offsetLimit.left));
                        }
    */
                    //adjust top & left calculations to parent offset
                    var scrollOffset = this.swiper.getWrapperTranslate('y');
                    var parent = this.draggedItem.offsetParent().not("body").offset(); //offsetParent returns body even when it's static, if not static offset is only factoring margin
                    if (parent != null) {

                        top -= parent.top;
                        left -= parent.left;
                    }

                    //var wrapper = $(opts.scrollContainer).find(".swiper-wrapper");
                    //var style = this.swiperWrapper[0].style;  // Need the DOM object
                    //var matrix = new WebKitCSSMatrix(style.webkitTransform);


                    //set x or y auto-scroll amount

                    if (opts.scrollContainer == window) {
                        y -= $(window).scrollTop();
                        x -= $(window).scrollLeft();
                        y = Math.max(0, y - $(window).height() + 5) + Math.min(0, y - 5);
                        x = Math.max(0, x - $(window).width() + 5) + Math.min(0, x - 5);
                    }
                    else {
                        var cont = $(opts.scrollContainer);
                        //var swiper = $(menuId).data("settingsSwiper");



                        var offset = { top: scrollOffset, left: 0 };
                        y = Math.max(0, y - this.swiperWrapper.height() - offset.top) + Math.min(0, y - offset.top);
                        x = 0;
                    }

                    list.scroll.moveX = x == 0 ? 0 : x * opts.scrollSpeed / Math.abs(x);
                    list.scroll.moveY = y == 0 ? 0 : y * opts.scrollSpeed / Math.abs(y);

                    //move draggedItem to new mouse cursor location
                    // AB: fix drag over text field

                    var descriptionTextView = this.swiperWrapper.find(".settings-description-text-item");
                    if (descriptionTextView.length > 0) {

                        var textHeight = descriptionTextView.getMeasuredHeight();
                        if (top < textHeight) {
                            top = textHeight;
                            if (scrollOffset < 0) {
                                //var swiper = $(menuId).data("settingsSwiper");
                                this.swiper.setWrapperTranslate(0, 0, 0);
                            }
                        }
                    }

                    this.draggedItem.css({ top: top });
                },

                //if scroll container is a div allow mouse wheel to scroll div instead of window when mouse is hovering over
                wheel: function (e) {
                    if (list && opts.scrollContainer != window) {
                        var cont = $(opts.scrollContainer);
                        var offset = cont.offset();
                        e = e.originalEvent;
                        if (e.clientX > offset.left && e.clientX < offset.left + cont.width() && e.clientY > offset.top && e.clientY < offset.top + cont.height()) {
                            var deltaY = (e.deltaMode == 0 ? 1 : 10) * e.deltaY;
                            cont.scrollTop(cont.scrollTop() + deltaY);
                            e.preventDefault();
                        }
                    }
                },

                //build a table recording all the positions of the moveable list items
                buildPositionTable: function () {
                    var pos = [];
                    this.getItems().not([list.draggedItem[0], list.placeHolderItem[0]]).each(function (i) {
                        var loc = $(this).offset();
                        loc.right = loc.left + $(this).outerWidth();
                        loc.bottom = loc.top + $(this).outerHeight();
                        loc.elm = this;
                        pos[i] = loc;
                    });
                    this.pos = pos;
                },

                dropItem: function () {
                    if (list.draggedItem == null)
                        return;

                    //list.draggedItem.attr("style", "") doesn't work on IE8 and jQuery 1.5 or lower
                    //list.draggedItem.removeAttr("style") doesn't work on chrome and jQuery 1.6 (works jQuery 1.5 or lower)
                    var orig = list.draggedItem.attr("data-origstyle");
                    list.draggedItem.attr("style", orig);
                    if (orig == "")
                        list.draggedItem.removeAttr("style");
                    list.draggedItem.removeAttr("data-origstyle");

                    list.styleDragHandlers(true);

                    list.placeHolderItem.before(list.draggedItem);
                    list.placeHolderItem.remove();

                    $("[data-droptarget], .dragSortItem").remove();

                    window.clearInterval(list.scroll.scrollY);
                    window.clearInterval(list.scroll.scrollX);

                    //if position changed call dragEnd
                    if (list.draggedItem.attr("data-origpos") != $(lists).index(list) + "-" + $(list.container).children().index(list.draggedItem))
                        if (opts.dragEnd.apply(list.draggedItem) == false) { //if dragEnd returns false revert order
                            var pos = list.draggedItem.attr("data-origpos").split('-');
                            var nextItem = $(lists[pos[0]].container).children().not(list.draggedItem).eq(pos[1]);
                            if (nextItem.size() > 0)
                                nextItem.before(list.draggedItem);
                            else if (pos[1] == 0) //was the only item in list
                                $(lists[pos[0]].container).prepend(list.draggedItem);
                            else //was the last item in list
                                $(lists[pos[0]].container).append(list.draggedItem);
                        }
                    list.draggedItem.removeAttr("data-origpos");
                    list.draggedItem.css("opacity", 0);
                    list.draggedItem.animate({ "opacity": 1 }, 250);

                    list.draggedItem = null;
                    $(document).unbind("mousemove touchmove", list.swapItems);
                    $(document).unbind("mouseup touchend", list.dropItem);
                    if (opts.scrollContainer != window)
                        $(window).unbind("wheel", list.wheel);
                    return false;
                },

                positionTopOfLastItem: function () {
                    if (list.pos.length == 0)
                        return list.NON_VALID;
                    var offs = list.pos[list.pos.length - 1];
                    return offs.top;
                },

                positionTopOfFirstItem: function () {
                    if (list.pos.length == 0)
                        return list.NON_VALID;
                    var offs = list.pos[0];
                    return offs.top;
                },

                positionTopOfPlaceHolder: function () {
                    if (list.placeHolderItem == null)
                        return list.NON_VALID;
                    var offs = list.placeHolderItem.offset();
                    return offs.top;
                },

                positionTopOfDraggedItem: function () {

                    if (list.draggedItem == null)
                        return list.NON_VALID;

                    var offs = list.draggedItem.offset();
                    return offs.top;
                },



                getPlaceHolderPosition: function () {
                    var pos = -1;
                    var k = list.getItems().not([list.draggedItem[0]]).each(function (i) {
                        if (this == list.placeHolderItem[0])
                            pos = i;
                    });
                    return pos;
                },


                //swap the draggedItem (represented visually by placeholder) with the list item the it has been dragged on top of
                swapItems: function (e)
                {
                    if (list.draggedItem == null)
                    {
                        return false;
                    }

                    var pageX = 0;
                    var pageY = 0;
                    if (e.type == "mousemove")
                    {
                        pageX = e.pageX;
                        pageY = e.pageY;
                    }
                    else
                        if (e.type == "touchmove")
                        {
                            pageX = e.originalEvent.changedTouches[0].clientX;
                            pageY = e.originalEvent.changedTouches[0].clientY;
                        }


                    var posPlaceHolder = list.positionTopOfPlaceHolder();
                    var posDragged = list.positionTopOfDraggedItem();
                    var posLast = list.positionTopOfLastItem();
                    var posFirst = list.positionTopOfFirstItem();


                    //move draggedItem to mouse location
                    // console.log(' first ' + posFirst + ' dragged = ' + list.draggedItem.offset().top ); 
                    if (posLast != list.NON_VALID && posFirst != list.NON_VALID)
                    {

                        list.dragMove(null, null);
                        if (posLast + 90 >= pageY)
                            list.setPos(pageX, pageY);

                    }

                    if (posFirst != list.NON_VALID && posFirst >= list.draggedItem.offset().top)
                    {
                        list.lastPos = null;
                        ei = 0;
                    }
                    list.dragMove(null, null);
                    //  list.setPos(pageX, pageY);	
                    //retrieve list and item position mouse cursor is over
                    var ei = list.findPos(pageX, pageY);
                    var nlist = list;
                    for (var i = 0; ei == -1 && opts.dragBetween && i < lists.length; i++)
                    {
                        ei = lists[i].findPos(pageX, pageY);
                        nlist = lists[i];
                    }



                    //if not over another moveable list item return
                    if (ei == -1)
                    {
                        // check the distance from the placeHolder to the dragged item

                        if (posPlaceHolder != list.NON_VALID && posDragged != list.NON_VALID && posPlaceHolder + 30 < posDragged)
                        {

                            ei = list.getPlaceHolderPosition();
                            if (ei != -1 && ei + 1 < list.pos.length)
                                ei++;
                            else
                                ei = -1;
                        }
                        else
                            if (posPlaceHolder != list.NON_VALID && posDragged != list.NON_VALID && posPlaceHolder > posDragged)
                            {
                                ei = list.getPlaceHolderPosition();
                                if (ei != -1 && 0 <= (ei - 1))
                                    ei--;
                                else
                                    ei = -1;
                            }


                        if (ei == -1)
                            return false;


                    }

                    if (list.lastPos == null || list.lastPos.top > list.draggedItem.offset().top || list.lastPos.left > list.draggedItem.offset().left)
                        $(nlist.pos[ei].elm).before(list.placeHolderItem);
                    else
                        $(nlist.pos[ei].elm).after(list.placeHolderItem);

                    //misc
                    $(lists).each(function (i, l) { l.createDropTargets(); l.buildPositionTable(); });
                    list.lastPos = list.draggedItem.offset();
                    return false;
                },



                //returns the index of the list item the mouse is over
                findPos: function (x, y) {
                    for (var i = 0; i < this.pos.length; i++) {
                        if (this.pos[i].left < x && this.pos[i].right > x && this.pos[i].top < y && this.pos[i].bottom > y)
                            return i;
                    }
                    return -1;
                },

                //create drop targets which are placeholders at the end of other lists to allow dragging straight to the last position
                createDropTargets: function () {
                    if (!opts.dragBetween)
                        return;

                    $(lists).each(function () {
                        var ph = $(this.container).find("[data-placeholder]");
                        var dt = $(this.container).find("[data-droptarget]");
                        if (ph.size() > 0 && dt.size() > 0)
                            dt.remove();
                        else if (ph.size() == 0 && dt.size() == 0) {
                            if (opts.tagName == "td")
                                $(opts.placeHolderTemplate).attr("data-droptarget", true).appendTo(this.container);
                            else
                                //list.placeHolderItem.clone().removeAttr("data-placeholder") crashes in IE7 and jquery 1.5.1 (doesn't in jquery 1.4.2 or IE8)
                                $(this.container).append(list.placeHolderItem.removeAttr("data-placeholder").clone().attr("data-droptarget", true));

                            list.placeHolderItem.attr("data-placeholder", true);
                        }
                    });
                }
            };

            newList.init();
            lists.push(newList);
        });

        return this;
    };

    $.fn.dragsort.defaults = {
        itemSelector: "",
        dragSelector: "",
        dragSelectorExclude: "input, textarea",
        dragEnd: function () { },
        dragStart: function () { },
        dragBetween: false,
        placeHolderTemplate: "",
        scrollContainer: window,
        scrollSpeed: 5
    };

})(jQuery);