/*global ko*/
/*jslint browser: true*/
window.Gira.Settings = window.Gira.Settings || {};

(function (ns) {
    "use strict";
    function SystemCommands(device, fsm, i18n) {

        function openConfirmation(message, callback) {
            fsm.OpenConfirmation(message,
                function () {
                    return callback();
                },
                // cancel button: close popup
                function () {
                    fsm.CloseConfirmation();
                });
        }

        function executeFactoryReset() {
            openConfirmation(i18n.menuConfigFactoryResetQuestion, function () {
                device.resetDevice();
            });
        }

        function executeRestart() {
            openConfirmation(i18n.menuConfigRestartQuestion, function () {
                device.rebootDevice();
            });
        }

        return {
            factoryReset: {
                label: i18n.menuConfigFactoryReset,
                execute: executeFactoryReset
            },
            restart: {
                label: i18n.menuConfigRestart,
                execute: executeRestart
            }

        };
    }

    ns.SystemCommands = SystemCommands;
}(window.Gira.Settings));