/*global window, document, Image, $, _ */
(function (ns) {
    "use strict";
    function ColorPicker(domElement) {
        var self = this,
            element = domElement,
            throttledSendToHue,
            canvas,
            hueCoefficientsRgb = [
                [0.664511, 0.15432, 0.162028],
                [0.283881, 0.668433, 0.047685],
                [0.000088, 0.072310, 0.98603]
            ],
            rgbToXy = function (r, g, b, coefficients) {
                var X, Y, Z, x, y;
                r = r / 255;
                g = g / 255;
                b = b / 255;
                r = (r > 0.04045) ? Math.pow((r + 0.055) / (1.0 + 0.055), 2.4) : (r / 12.92);
                g = (g > 0.04045) ? Math.pow((g + 0.055) / (1.0 + 0.055), 2.4) : (g / 12.92);
                b = (b > 0.04045) ? Math.pow((b + 0.055) / (1.0 + 0.055), 2.4) : (b / 12.92);
                X = r * coefficients[0][0] + g * coefficients[0][1] + b * coefficients[0][2];
                Y = r * coefficients[1][0] + g * coefficients[1][1] + b * coefficients[1][2];
                Z = r * coefficients[2][0] + g * coefficients[2][1] + b * coefficients[2][2];
                x = X / (X + Y + Z);
                y = Y / (X + Y + Z);
                return {x: x, y: y};
            };

        function choosePosition(x, y) {
            var ctx = canvas.getContext('2d'),
                canvasColor = ctx.getImageData(x, y, 1, 1),
                pixels = canvasColor.data,
                r = pixels[0],
                g = pixels[1],
                b = pixels[2],
                xY = rgbToXy(r, g, b, hueCoefficientsRgb);
            throttledSendToHue(xY);
        }

        function movePointer(e) {
            var touches,
                left,
                top;
            if (e.touches !== undefined) {
                touches = e.touches[0];
                left = touches.pageX;
                top = touches.pageY;
            } else {
                left = e.pageX;
                top = e.pageY;
            }
            left -= 25;
            top -= 310;
            if ((top > -5) && (top < 430)) {
                document.getElementById("color-id-pointer").style.top = top;
            }

            if ((left > -5) && (left < 436)) {
                document.getElementById("color-id-pointer").style.left = left;
            }


            choosePosition(left, top);
        }

        function sendToHui(xY) {
            $.ajax({
                url: 'http://192.168.137.136/api/SChPEDhtxIj6bJaIs9XPy9TNhndnL-qQexJD2Nic/lights/1/state',
                data: JSON.stringify({xy: [xY.x, xY.y], transitiontime: 0}),
                contentType: 'application/json',
                type: 'PUT'
            });
        }

        function init() {
            var tmpCanvas = document.createElement('canvas'),
                ctx = tmpCanvas.getContext('2d'),
                imageObj = new Image();

            tmpCanvas.style.position = "absolute";
            tmpCanvas.style.top = "0px";

            tmpCanvas.height = 444;
            tmpCanvas.width = 444;

            element.appendChild(tmpCanvas);

            imageObj.src = "img/color-picker.png";

            imageObj.onload = function () {
                ctx.drawImage(this, 0, 0, 470, 444);
            };

            canvas = tmpCanvas;

            tmpCanvas.addEventListener("mousemove", movePointer);
            tmpCanvas.addEventListener("touchmove", movePointer);

        }

        throttledSendToHue = _.throttle(sendToHui, 250);

        self.init = init;
    }

    ns.ColorPicker = ColorPicker;

}(window.Gira));