/*global ko, $*/
/*jslint browser: true*/

(function (ns) {
    'use strict';

    function PinSettingsViewmodel() {
        var setPinCode,
            getPinCode,
            localStorageKey = 'pin',
            clearPinValues,
            pinsAreEmptyOrNull,
            pinValue,
            init,
            pinConfirmationValue,
            validateValues,
            enableOk;

        validateValues = function () {
            return pinValue() === pinConfirmationValue();
        };

        clearPinValues = function () {
            pinValue('');
            pinConfirmationValue('');
        };

        setPinCode = function () {
            localStorage.setItem(localStorageKey, pinValue());
        };

        getPinCode = function () {
            return localStorage.getItem(localStorageKey);
        };

        pinsAreEmptyOrNull = function (val, confirm) {
            //if there is a key in the local-storag
            if ((val === null || val === '') && (confirm === null || confirm === '')) {
                if (localStorage.getItem(localStorageKey) !== null) {
                    localStorage.removeItem(localStorageKey);
                }
                return true;
            }
        };

        init = function () {
            if (getPinCode() !== null) {
                pinValue(getPinCode());
                pinConfirmationValue(getPinCode());
            } else {
                pinValue('');
                pinConfirmationValue('');
            }
        };

        function ok() {
            if (pinsAreEmptyOrNull(pinValue(), pinConfirmationValue())) {
                return true;
            }
            setPinCode(pinValue());
            return true;
        }

        function cancel() {
            pinValue(getPinCode());
            pinConfirmationValue(getPinCode());
        }

        pinValue = ko.observable(getPinCode());
        pinConfirmationValue = ko.observable(getPinCode());
        enableOk = ko.computed(validateValues);

        return {
            init: init,
            ok: ok,
            cancel: cancel,
            clearPinValues: clearPinValues,
            isValid: enableOk,
            pinValue: pinValue,
            pinConfirmationValue: pinConfirmationValue,
            label: window.Gira.appLang.appI18nTexts.menuConfigPINSchutz
        };
    }

    ns.PinSettingsViewmodel = PinSettingsViewmodel;

}(window.Gira));