/*global ko, $*/
/*jslint browser: true*/

(function (ns) {
    'use strict';

    function PinSecurityViewmodel() {
        var isProtected,
            isValid,
            pin = ko.observable(),
            getPinFromLocalStorage,
            pinExistsInLocalStorage;

        getPinFromLocalStorage = function () {
            return localStorage.getItem('pin') === pin();
        };

        pinExistsInLocalStorage = function () {
            var currentPin = localStorage.getItem('pin');
            return currentPin !== null && currentPin !== "";
        };

        function ok() {
            // need to check, because to be really sure its the right pin
            return getPinFromLocalStorage();
        }

        function cancel() {
            pin('');
            return undefined;
        }

        function init() {
            pin('');
            isProtected(pinExistsInLocalStorage());
        }

        isProtected = ko.observable(pinExistsInLocalStorage());
        isValid = ko.computed(getPinFromLocalStorage);

        return {
            init: init,
            isProtected: isProtected,
            isValid: isValid,
            pin: pin,
            _ok: ok,
            _cancel: cancel
        };
    }

    ns.PinSecurityViewmodel = PinSecurityViewmodel;

}(window.Gira));