/*global window, $, gds$, ko*/
(function (ns) {
    "use strict";

    function init() {
        ns.ModuleLoader.init();
        window.Gira.I18n.init(ns.appLang.appI18nTexts, 'app');
        ns.dateTimeFormatsModel = new ns.DateTimeFormats(ns.appLang.appI18nTexts, gds$, $.ajax({
            url: "js/gira.dateTimeFormats.json",
            async: false
        }).responseText);

        ns.pinSettingsViewmodel = new ns.PinSettingsViewmodel();
        ns.settingsSecurity = new ns.PinSecurityViewmodel();

        ns.deviceConfig = new ns.DeviceConfigurationInterface(gds$);
        ns.deviceConfig.init();
        ns.systemCommands = new ns.Settings.SystemCommands(ns.deviceConfig, window.fsm.API.SystemMessage, ns.appLang.appI18nTexts);
        ns.networkModel = new ns.NetworkModel(ns.deviceConfig, window.Gira.appLang.appI18nTexts, window.fsm.API.SystemMessage);
        ns.networkRealibleModel = new ns.KnxReliableModel(ns.deviceConfig, window.Gira.appLang.appI18nTexts, window.fsm.API.SystemMessage);
    }

    function Bootstrapper() {
        return {
            init: init
        };
    }

    ns.Bootstrapper = Bootstrapper;
}(window.Gira));