/*global $, tsx, ko, gds$, openSettingsElement, eventsOnSettingsEntry*/
/*jslint browser: true*/

/**
 * This modules handles wifi connection handling + dialogs.
 */
tsx.WifiConnectionSettings = (function () {
    var module = {},
        I18nTexts = window.Gira.appLang.appI18nTexts,
        wifiClickToConnect = false;
    module.overlayTimeout = 1000 * 120;

    /**
    * STANDARD WIFI Protection
    */
    var WifiProtection = {
        NONE: { id: 0, name: I18nTexts.wifiConnectionSettingsProtectionNo },
        WEP: { id: 1, name: "WEP" },
        WPA: { id: 2, name: "WPA" },
        WPA2: { id: 3, name: "WPA2" },

        // convert name to ID
        stringToID: function (name) {
            if (name === this.WPA.name)
                return this.WPA.id;
            if (name === this.WPA2.name)
                return this.WPA2.id;
            if (name === this.WEP.name)
                return this.WEP.id;
            if (name === "none")
                this.NONE.id;

            return this.NONE.id;
        },

        // convert ID to name
        idToString: function(id) {
            if (id === this.WPA.id)
                return this.WPA.name;
            if (id === this.WPA2.id)
                return this.WPA2.name;
            if (id === this.WEP.id)
                return this.WEP.name;
            return this.NONE.name;
        },

        // standard id of protection
        defaultID: function() {
            return this.WPA2.id;
        },
        // standard name of protection
        defaultName: function() {
            return this.WPA2.name;
        },
        //check: is protection enabled
        isProtect: function(name) {
            if (name === this.WEP.name ||
                name === this.WPA.name ||
                name === this.WPA2.name) {
                return true;
            }                
            return false;
        }
    };

    module.initManualWifiSettings = function() {

        wifiClickToConnect = false;
        var security = localStorage['security'];

        if (!WifiProtection.isProtect(security))
            security = WifiProtection.defaultName();

        $(".settings-row-select > .sub-menu-text").text(security);

        SettingsElements['WLAN_SSID'] = $("#inputWithLabelN").attr('id');
        SettingsElements['WLAN_SSID_PASSWORD'] = $("#inputWithLabelCheckboxN").attr('id');

        $('#' + SettingsElements['WLAN_SSID']).bind("input", tsx.WifiConnectionSettings.isWifiSettingsComplete);
        $('#' + SettingsElements['WLAN_SSID_PASSWORD']).bind("input", tsx.WifiConnectionSettings.isWifiSettingsComplete);

        // SSID ....max. 32 Chars min. 1 Char
        $("#inputWithLabelN").attr("required", "required");
        $("#inputWithLabelN").attr("pattern", ".{1,32}");

        wifiSecurityChanged();

    };

    /**
     * start the overlay in the wifi section, we work with callback's, beforeCallback and timeoutCallback with param
     */
    function startWifiOverlay(timeOut, cancelButton, beforeStartCallback, timeoutCallback, callbackParam) {

        var wifiAfterJS = function(cancelPressed) {

            if (timeoutCallback != undefined)
                timeoutCallback(cancelPressed, callbackParam);
        };


        var wifiBeforeCallback = function() {
            // set the callback timeout function 
            tsx.Overlay.tos = timeOut;

            if (beforeStartCallback != undefined)
                beforeStartCallback(callbackParam);
        };

        var wifiBeforeJS = {
            returnValue: null
        };

        tsx.Overlay.addCallbackTimeout(wifiAfterJS);
        fsm.API.Overlay.Open(I18nTexts.wifiConnectionSettingsOverlayTitle, I18nTexts.wifiConnectionSettingsOverlayText, true, cancelButton, wifiBeforeCallback, wifiBeforeJS);

        return wifiBeforeJS.returnValue;
    }


    /**
     * set the pattern for the input fields WEB/5,13 WPA/8,63
     */
    function wifiSecurityChanged() {

        var pattern = '';
        var required = '';
        var key = localStorage['security'];
        if (key === undefined)
            key = WifiProtection.defaultName();

        if (key === WifiProtection.WEP.name) {
            required = "required";
            pattern = ".{5,13}";
        } else if (key === WifiProtection.WPA.name || key === WifiProtection.WPA2.name) {
            required = "required";
            pattern = ".{8,63}";

        }

        var passwordField = $('#' + SettingsElements['WLAN_SSID_PASSWORD']);
        passwordField.attr("required", required);
        passwordField.attr("pattern", pattern);

        module.isWifiSettingsComplete();
    }

    module.checkWifiSettings = function() {
        wifiSecurityChanged();
    };

    // if previous wifi connection is active disconnect from it
    // it otherwise disconnect from last sucessfuly connected network
    // disconnect is used to "remove" old connection from connman favorite list
    function disconnectOldWiFiConnecton () {
        var oldWifiIdentifier = '';
        if(tsx.WifiSettings.connectedWifi.identifier !== '') {
            oldWifiIdentifier = tsx.WifiSettings.connectedWifi.identifier;
        } else if (localStorage['WLAN_IDENTIFIER'] && localStorage['WLAN_IDENTIFIER'].length > 0) {
            oldWifiIdentifier = localStorage['WLAN_IDENTIFIER'];
        }

        if (oldWifiIdentifier.length > 0) {
            var oldConnJson = {};
            var OldConnPrefix = "NetworkServices_" + oldWifiIdentifier + "_"; // old connection
            var OldConnectedKey = OldConnPrefix + "Connected";

            oldConnJson[OldConnectedKey] = "false";
            // disconnect from previous connection
            gds$.setDeviceConfigurationValue(true, oldConnJson);
        }
    }

    /**
     * enable/disable the OK Button 
     */
    module.isWifiSettingsComplete = function() {
        var ssid = $('#' + SettingsElements['WLAN_SSID']);
        var pass = $('#' + SettingsElements['WLAN_SSID_PASSWORD']);
        var key = localStorage['security'];
        if (key === undefined) {
            key = WifiProtection.defaultName();
        }

        // no protection
        if (!WifiProtection.isProtect(key)) {
            if (ssid[0].validity.valid)
                $('div#ok').removeClass('disabled');
            else
                $('div#ok').addClass('disabled');
        } else {
            if (pass[0].validity.valid && ssid[0].validity.valid)
                $('div#ok').removeClass('disabled');
            else
                $('div#ok').addClass('disabled');
        }
    };


    /**
     * WEP
     * ASCII requests an input of 5 characters for a 64-bit key and 13 characters for a 128-bit key.
     * For Hexade1cimal, enter 10 characters for a 64-bit key or 26 characters for a 128-bit key in hexadecimal notation. 
     * WPA-PSK: 
     * In the Passphrase mode, the input must be 8 to 63 characters. In the Hexadecimal mode, enter 64 characters.
     */
    module.setManualWifiSettings = function() {
        // remove backup data
        if (!wifiClickToConnect)
            localStorage.removeItem('security_backup');

        var security = localStorage['security'];
        if (wifiClickToConnect && $('.settings-row.big').is(':visible'))
            security = $(".settings-row-select > .sub-menu-text").attr('value');


        var ssid = $('#' + SettingsElements['WLAN_SSID']).val();
        var passwd = $('#' + SettingsElements['WLAN_SSID_PASSWORD']).val();
        var identifier = $('#' + SettingsElements['WLAN_SSID']).data("id");


        var overlayUid = false;
        var errorMessage = I18nTexts.wifiConnectionSettingsManualErrorMessage;
        var intervalId;

        var beforeOverlayFunc = function(parm) {
            // set the cancel button - style 
            var cancelButton = $("#overlay").find('.cancelbutton');
            registerEventsForSwipeableElement(cancelButton,
                function() {
                    // style down
                    cancelButton.removeClass("primary-button");
                    cancelButton.addClass("primary-button-down");
                },
                function() {
                    // style default
                    cancelButton.addClass("primary-button");
                    cancelButton.removeClass("primary-button-down");
                },
                function() {}
            );

            // if setup was coming from list entry, we dont have known protection
            var json = {};
            var jsonClearError = {};

            var prefix = "NetworkServices_" + identifier + "_";
            var connectedKey = prefix + "Connected";
            var errorKey = prefix + "ConnectionError";
            var modeKey = prefix + "Mode";
            var passwordKey = prefix + "Passphrase";
            var initiatedConnection = false;

            json[connectedKey] = "true";
            json[errorKey] = "false";
            json[modeKey] = "dhcp";
            json[passwordKey] = passwd;
            jsonClearError[errorKey] = "false";

            disconnectOldWiFiConnecton();

            // Poll for connection status and connect when old network is disconnected
            intervalId = setInterval(function() {
                gds$.updateDeviceConfiguration(true, function(deviceConfig) {
                    if(!initiatedConnection && deviceConfig['NetworkTechnologies_wifi_Connected'] === 'false') {
                        //initiate connection
                        gds$.setDeviceConfigurationValue(true, json);
                        initiatedConnection= true;
                    }
                    else if (initiatedConnection && (deviceConfig['NetworkTechnologies_wifi_Connected'] === 'true' || deviceConfig[connectedKey] === 'true')) {
                        fsm.API.Overlay.Close(overlayUid);
                        NavbarController.getInstance().back();
                        clearInterval(intervalId);
                    }
                    else if (deviceConfig[errorKey] === 'true') {
                        gds$.setDeviceConfigurationValue(true, jsonClearError);
                        fsm.API.Overlay.Close(overlayUid);
                        fsm.API.SystemMessage.OpenWarning(errorMessage);
                        clearInterval(intervalId);
                    }
                });
            }, 2000);


        };

        var afterOverlayFunc = function() {
            // save ssid and passwd in the localStorage
            localStorage['WLAN_SSID'] = ssid;
            localStorage['WLAN_SSID_PASSWORD'] = passwd;
            localStorage['WLAN_IDENTIFIER'] = identifier;
            clearInterval(intervalId);
        };

        overlayUid = startWifiOverlay(module.overlayTimeout, true, beforeOverlayFunc, afterOverlayFunc, null);
    };

    module.cancelManualWifiSettings = function() {
        // restore previous security
        if (localStorage['security_backup'])
            localStorage['security'] = localStorage['security_backup'];
    };

    /**
     * Intitializes the security selection formular
     */
    module.initSecuritySelection = function() {
        var security = localStorage['security'];
        if (!security) security = WifiProtection.defaultName();

        // backup security value if voew gets canceled
        localStorage['security_backup'] = security;
        $('input[name="securitySelection"][value="' + security + '"]').prop("checked", true);

    };

    /**
     * Stores the security selection
     */
    module.setSecurity = function() {
        localStorage['security'] = $('input[name=securitySelection]:radio:checked').val();
    };


    /**
     * a double click on the wifi entry
     */
    module.onWifiEntryClick = function(network) {
        initWifiConnection(I18nTexts.wifiConnectionSettingsEntryClickText, network);
    };

    /**
     * Inits the wifi connection / automatic
     */
    function initWifiConnection(caption, network) {
        wifiClickToConnect = true;
        var required = '';
        var pattern = '';
        var securityId;
        $(menuId + ' .settings-description-row-text .settings-title').text(caption);

        switch (network.networkSecurity) {
        case "none":
            securityId = 0;
            break;
        default:
            securityId = 1;
            required = "required";
            pattern = ".{8,63}";
            break;
        }
        // console.log(securityId);

        // set the new ssid value / ignore the localStorage values
        $('#inputWithLabelN').val(network.ssid);

        // disable ssid row and input field
        enableDisableSettingsRow($('.settings-row[settingid=SSID]').attr('id'), false);
        enableDisableProtection(false);

        // enable password field
        if (securityId === 0) {
            togglePasswordInputField(false);
        }

        SettingsElements['WLAN_SSID'] = $("#inputWithLabelN").attr('id');
        SettingsElements['WLAN_SSID_PASSWORD'] = $("#inputWithLabelCheckboxN").attr('id');
        $('#' + SettingsElements['WLAN_SSID']).data("id", network.identifier);

        //clear password
        $('#' + SettingsElements['WLAN_SSID_PASSWORD']).attr('value', '');    

        var passwordField = $('#' + SettingsElements['WLAN_SSID_PASSWORD']);
        passwordField.on('input', function () { setOkButtonState(securityId); });
        passwordField.attr("required", required);
        passwordField.attr("pattern", pattern);

        setOkButtonState(securityId);
    }

    function setOkButtonState(securityId) {
        if (securityId != 0) {
            var pass = $('#' + SettingsElements['WLAN_SSID_PASSWORD']);

            if (pass[0].validity.valid)
                $('div#ok').removeClass('disabled');
            else
                $('div#ok').addClass('disabled');
        } else {
            $('div#ok').removeClass('disabled');
        }
    }

    /**
     * enabled/disabled the WIFI - Protection
     */
    function enableDisableProtection(enabled) {
        if (enabled) {
            $('.settings-row.big').show();
        } else {
            $('.settings-row.big').hide();
        }
    }

    module.openWifiOverlay = function (network) {
        var errorMessage = I18nTexts.wifiConnectionSettingsOverlayErrorMessage;
        var message1 = I18nTexts.wifiConnectionSettingsOverlayMessage1;
        var message2 = I18nTexts.wifiConnectionSettingsOverlayMessage2Part1 + network.name + I18nTexts.wifiConnectionSettingsOverlayMessage2Part2;
        var connected = false;
        var intervalId;

        var json = {};

        var prefix = "NetworkServices_" + network.identifier + "_";
        var connectedKey = prefix + "Connected";
        var errorKey = prefix + "ConnectionError";
        var modeKey = prefix + "Mode";
        var triggerWps = prefix + "TriggerWps";

        var pollForConnectionStatus = function () {
            intervalId = setInterval(function () {
                gds$.updateDeviceConfiguration(true, function (deviceConfig) {
                    if (deviceConfig[connectedKey] === 'true') {
                        connected = true;
                        fsm.API.Overlay.Close(wifiOverlayUid);
                        NavbarController.getInstance().back();
                    }
                    if (deviceConfig[errorKey] === 'true') {
                        fsm.API.Overlay.Close(wifiOverlayUid);
                    }
                });
            }, 2000);
        };

        json[connectedKey] = "true";
        json[errorKey] = "false";
        json[modeKey] = "dhcp";
        json[triggerWps] = "true";

        // disconnect from old network before connect to another one
        disconnectOldWiFiConnecton();
        setTimeout(function() {
                gds$.setDeviceConfigurationValue(true, json);
                pollForConnectionStatus();
        }, 3000);

        var wifiCallback = function () {
            tsx.Overlay.tos = module.overlayTimeout;
            var cancelButton = $("#overlay").find('.cancelbutton');
            registerEventsForSwipeableElement(cancelButton,
                function () {
                    cancelButton.removeClass("primary-button");
                    cancelButton.addClass("primary-button-down");
                },
                function () {
                    cancelButton.addClass("primary-button");
                    cancelButton.removeClass("primary-button-down");
                },
                function () {
                    fsm.API.Overlay.Close(wifiOverlayUid);
                }
            );
        };

        var wifiJavascript = {
            returnValue: null
        };

        var closeCallback = function () {
            if (!connected) {
                fsm.API.SystemMessage.OpenWarning(errorMessage);
            } else {
                localStorage['WLAN_SSID'] = network.name;
                localStorage['WLAN_SSID_PASSWORD'] = undefined;
                localStorage['WLAN_IDENTIFIER'] = network.identifier;
            }
            clearInterval(intervalId);
        };
        tsx.Overlay.addCallbackTimeout(closeCallback);
        fsm.API.Overlay.Open(message1, message2, true, false, wifiCallback, wifiJavascript, true);
        var wifiOverlayUid = wifiJavascript.returnValue;
    };


    module.initWifiSettings = function () {
        var settingsEntryJQuery = $($(menuId).find(".settings-row")[1]);
        eventsOnSettingsEntry(settingsEntryJQuery);

    };

    function togglePasswordInputField(enabled) {
        if (enabled) {
            $('.settings-row.inputField.bigger').removeClass("inactive");
            $('.settings-row.inputField.bigger .t3lgg').addClass("t3lsg");
            $('.settings-row.inputField.bigger .t3lsg').removeClass("t3lgg");
            $('.settings-row.inputField.bigger .checkbox-with-label').removeAttr('style', 'pointer-events: none');
            $('.settings-row.inputField.bigger .input').removeAttr('disabled');
        } else {
            $('.settings-row.inputField.bigger').addClass("inactive");
            $('.settings-row.inputField.bigger .t3lsg').addClass("t3lgg");
            $('.settings-row.inputField.bigger .t3lgg').removeClass("t3lsg");
            $('.settings-row.inputField.bigger .checkbox-with-label').attr('style', 'pointer-events: none');
            $('.settings-row.inputField.bigger .input').attr('disabled', 'true');
        }
    }

    return module;
})();
