/*global $, NavbarController*/
/*jslint browser: true*/

/**
* create a horizontal swiper for detail views
*/
function createSwiperH(viewId, swiperContainerClass, bulletActive, bulletInactive, viewType) {

    function updateDescriptionRowHTML() {
        var next = $('#content ' + viewId + ' .swiper-slide-visible + .swiper-slide #description-row').html(),
            prev = $('#content ' + viewId + ' .swiper-slide-prev #description-row').html(),
            curr = $('#content ' + viewId + ' .swiper-slide-visible #description-row').html();

        $('#pageContent .description-row-container #description-row-next').html(next).css('opacity', 0);
        $('#pageContent .description-row-container #description-row-prev').html(prev).css('opacity', 0);
        $('#pageContent .description-row-container #description-row').html(curr).css('opacity', 1);
    }

    function onCreate(swiper) {
        for (var i in swiper.slides) {
			$(swiper.slides[i])
				.addClass('absolute')
				.css('left', i * $(swiper.slides[i]).width());
		}

		var slideId = swiper.activeIndex;
		if (NavbarController.getInstance().isHomescreenSlideShown(viewId, slideId)) {
		    NavbarController.getInstance()._disableHomeButton();
		}
	}
	
	function onSlideChangeStart(swiper) {
		var slideId = swiper.activeIndex;
		var bullets = $(viewId + ' .container > .bulletbar > .bullets');
		bullets.removeClass('active').removeClass(bulletActive).addClass(bulletInactive);
		$(bullets[slideId]).addClass('active').removeClass(bulletInactive).addClass(bulletActive);
		$(viewId).data('wasSwiped',true);
	}
	
	function onTouchMove(swiper) {
		var touchXRel = (swiper.touches.currentX - swiper.touches.current)/(swiper.width/2);

		if (touchXRel > 0 && touchXRel < 1) {
		    $('#description-row').css('opacity', (1 * (1-touchXRel)));
		    $('#description-row-next').css('opacity', 0);
		}
		if (touchXRel > 1) {
		    $('#description-row').css('opacity', 0);
		    $('#description-row-next').css('opacity', (-1 * (1 - Math.abs(touchXRel))));
		}
		if (touchXRel < 0 && touchXRel > -1) {
		    $('#description-row').css('opacity', (1 - Math.abs(touchXRel)));
		    $('#description-row-prev').css('opacity', 0);
		}
		if (touchXRel < -1) {
		    $('#description-row-prev').css('opacity', (-1 * (1 - Math.abs(touchXRel))));
			$('#description-row').css('opacity', 0);
		}
	}
	
    function onSlideChangeEnd(swiper) {
        var slideId = swiper.activeIndex;
        if (NavbarController.getInstance().isHomescreenSlideShown(viewId, slideId)) {
            NavbarController.getInstance()._disableHomeButton();
        } else {
            NavbarController.getInstance()._enableHomeButton();
        }
    }

	function onTouchEnd() {
		updateDescriptionRowHTML();

		$('#description-row').css('opacity', '');
		$('#description-row-next').css('opacity', '');
		$('#description-row-prev').css('opacity', '');
	}

	var emulateTouch = !(("ontouchstart" in document.documentElement) || navigator.userAgent === 'Selenium');

    //initialize swiper container
    var __swiper = undefined;
	switch (viewType) {
    case viewTypes.DETAIL:
        __swiper = $(viewId + ' .container > ' + swiperContainerClass).swiper({
            useCSS3Transforms: false,
            speed: 300,
            mode: 'horizontal',
            moveStartThreshold: '10',
            noSwiping: true,
            noSwipingClass: 'noSwipingH',
            simulateTouch: emulateTouch,
            slidePrevClass: 'swiper-slide-prev',
            onSwiperCreated: onCreate,
            onTouchEnd: onTouchEnd,
            onTouchMove: onTouchMove,
            onSlideChangeStart: onSlideChangeStart,
            onSlideMoveStart: function () {
                $(viewId + ' .detail').trigger('touchcancel').trigger('mouseleave');
            },
            onSlideChangeEnd: function () { updateDescriptionRowHTML();
                onSlideChangeEnd(__swiper);
            },
            queueEndCallbacks: true,
            viewId: viewId
        });
        break;
	    case viewTypes.TILE:
	        __swiper = $(viewId + ' .container > ' + swiperContainerClass).swiper({
	            useCSS3Transforms: false,
	            speed: 300,
	            mode: 'horizontal',
	            moveStartThreshold: '10',
	            noSwiping: true,
	            noSwipingClass: 'noSwipingH',
	            simulateTouch: emulateTouch,
	            slidePrevClass: 'swiper-slide-prev',
	            onSwiperCreated: onCreate,
	            onSlideChangeStart: onSlideChangeStart,
	            onSlideChangeEnd: onSlideChangeEnd,
	            onSlideMoveStart: function () {
	                $(viewId + ' .tile').trigger('touchcancel').trigger('mouseleave');
	            },
	            viewId: viewId
	        });
	    break;
	default:
	    console.error('Invalid view type for swiper initialisation: ' + viewType);
    }
	
	//set bullet 1 as active
	var firstBullet = $(viewId + ' .container > .bulletbar > .bullets').first();
	firstBullet.removeClass('inactive').removeClass(bulletInactive).addClass('active').addClass(bulletActive);

	$(viewId).on('loadView', function () {
	    //save swiper (required for back functionality)	
	    NavbarController.getInstance()._swiper = __swiper;
		updateDescriptionRowHTML();			   
	});

	$(viewId).data("swiper", __swiper);
	
    return __swiper;

}

function createMenuSwiperV(container, scrollbar, menuId, touchCancelSelector) {

    var swiper = $(container).swiper({
        useCSS3Transforms: false,
        mode: 'vertical',
        loop: false,
        freeMode: true,
        scrollContainer: true,
        momentumBounce: false,
        calculateHeight: true,
        shortSwipes: false,
        noSwiping: true,
        noSwipingClass: 'noSwipingV',
        grabCursor: true,
        moveStartThreshold: '10',
        simulateTouch: !(("ontouchstart" in document.documentElement) || navigator.userAgent === 'Selenium'),
        mousewheelControl: true,
        scrollbar: {
            container: scrollbar,
            draggable: true,
            hide: true,
            snapOnRelease: true
        },
        onSlideMoveStart: function() {
            $(touchCancelSelector, container).trigger('touchcancel').trigger('mouseleave');
        }
    });

    $(menuId).data("settingsSwiper", swiper);
}