﻿/*global $, rtc*/
/*jslint browser: true*/

var RtcUi = (function () {

    var my = {};
    my.iconMinus = null;
    my.iconPlus = null;
    my.arrowRight = null;

    my.init = function (iconMinus, iconPlus, arrowRight) {
        my.iconMinus = iconMinus;
        my.iconPlus = iconPlus;
        my.arrowRight = arrowRight;
    };

    /*
    * Helper function to set a button to inactive state (using CSS classes)
    */
    my.deactivateButton = function ($button, icon) {
        var $div = $button.find('div[class]');
        $div.removeClass(icon);
        if (!$div.hasClass(icon + "_inactive")) {
            $div.addClass(icon + "_inactive");
        }
        $div.removeClass(icon + "_pushed");
        $button.removeClass("down");
        $button.attr('disabled', true);
    };

    /*
    * Helper function to set a button to active state (using CSS classes)
    */
    my.activateButton = function ($button, icon) {
        var $div = $button.find('div[class]');
        $div.removeClass(icon + "_inactive");
        if (!$div.hasClass(icon) && !$div.hasClass(icon + "_pushed")) {
            $div.addClass(icon);
        }
        $button.removeAttr('disabled');
    };

    /*
    * Helper function to show / hide the timer button
    */
    my.setTimerState = function (isVisible) {
        var timerIcon = $('#rtc > .timer-icon');
        if (isVisible) {
            timerIcon.show();
        } else {
            timerIcon.hide();
        }
    };

    /*
    * Sets the state of the knob slider: if isActivated == true, the
    * slider is active and can be changed by the user; if false, the slider 
    * value is not changeable
    */
    my.setSliderState = function (isActivated) {
        var slider = $('.rtc-controller > .knob-container > div > canvas');
        if (isActivated) {
            slider.removeClass("rtr-stop-knob-input");
        } else {
            slider.addClass("rtr-stop-knob-input");
        }
    };

    /*
    * Sets the visibility of the mode extension / presence buttons
    */
    my.setModeExtensionVisibility = function (isVisible) {
        var visibility = "visible";
        if (!isVisible) {
            visibility = "hidden";
        }
        $('#rtc-mode-extension-container-comfort').css("visibility", visibility);
        $('#rtc-mode-extension-container-presence').css("visibility", visibility);
    };

    /*
     * Sets the visibility of the mode extension / presence buttons based on presence status
     * if presence is activated: then we should not hide button, even if it is set in comfort mode,
     * user should be able to to revert comfort to previous state with this button in this case
     */
    my.setModeExVisibilityByPresenceState = function (isVisible) {
        var buttonPresence = $('#rtc-mode-extension-container-presence .rtc-mode-extension-button'),
            isPresenceActive = false;
        if (buttonPresence) {
            isPresenceActive = buttonPresence.hasClass('active');
        }
        my.setModeExtensionVisibility(isPresenceActive || isVisible);
    };

    my.setModeButtonState = function (enabled) {
        var modeButton = $('.rtc-controller > .footer > .btn.modes');
        var modeButtonArrow = $('.rtc-controller > .footer > .btn.modes > .arrow-right');
        if (enabled) {
            modeButton.removeClass("rtr-stop-knob-input");
            modeButton.removeClass("t2lgg");
            modeButtonArrow.removeClass(my.arrowRight + "_inactive");
            modeButtonArrow.addClass(my.arrowRight);

        } else {
            modeButton.addClass("rtr-stop-knob-input");
            modeButton.addClass("t2lgg");
            modeButtonArrow.removeClass(my.arrowRight);
            modeButtonArrow.addClass(my.arrowRight + "_inactive");
        }
    };

    /*
    * Sets the state of the +/- buttons of the RTC depending on the current value
    */
    my.updateIncDecButtons = function ($container, temp) {
        var plusButton = $container.find('.inc');
        var minusButton = $container.find('.dec');
        var optsMinTemp = rtc.getOptsMinTemp();
        var optsMaxTemp = rtc.getOptsMaxTemp();

        //is thermal protection is active, all buttons are disabled
        if (!rtc.isThermalProtectionActive()) {
            if (optsMinTemp >= temp) {
                my.deactivateButton(minusButton, my.iconMinus);
                my.activateButton(plusButton, my.iconPlus);
                rtc.releaseLongPress();
            }
            if (optsMaxTemp <= temp) {
                my.deactivateButton(plusButton, my.iconPlus);
                my.activateButton(minusButton, my.iconMinus);
                rtc.releaseLongPress();
            }
            if (optsMinTemp < temp) {
                my.activateButton(minusButton, my.iconMinus);
            }
            if (optsMaxTemp > temp) {
                my.activateButton(plusButton, my.iconPlus);
            }
        }
    };

    /*
* Sets the state of the +/- buttons of the RTC depending on the current value
*/
    my.setIncDecButtonState = function (enabled) {
        var $container = $("#rtc");
        var plusButton = $container.find('.inc');
        var minusButton = $container.find('.dec');
        if (enabled) {
            my.activateButton(minusButton, my.iconMinus);
            my.activateButton(plusButton, my.iconPlus);
        } else {
            my.deactivateButton(minusButton, my.iconMinus);
            my.deactivateButton(plusButton, my.iconPlus);
        }
    };

    /*
    * Draws the slider marks for frost-/heat protection areas; the user can't set the 
    * slider value below / above the limit marks
    * @param{object} knob the knob slider instance
    * @param{String} the image to be used for the marks
    */
    my.drawMinMaxLimits = function (knob, image) {
        var valueMin = rtc.getOptsMinTemp();
        var valueMax = rtc.getOptsMaxTemp();
        valueMin = valueMin < 100 ? 100 : valueMin;
        valueMax = valueMax > 300 ? 300 : valueMax;

        var angleMin = knob.startAngle + knob.angle(valueMin);
        var angleMax = knob.startAngle + knob.angle(valueMax);
        var size = $('#rtr-hatch').width();
        var canvas = document.getElementById("rtr-hatch-canvas");
        var ctx = canvas.getContext("2d");

        canvas.width = size;
        canvas.height = size;
        ctx.lineWidth = 60;
        ctx.beginPath();
        ctx.strokeStyle = 'red';
        ctx.arc(size / 2, size / 2, size / 2, angleMin, angleMax, true);
        ctx.stroke();
        ctx.globalCompositeOperation = 'source-in';
        ctx.drawImage(image, 0, 0);
    };

    my.setModeButtonArrowDown = function (rtcModesButton, downStateActive) {
        if (downStateActive) {
            rtcModesButton.find('.arrow-right').addClass(my.arrowRight + "_down");
            rtcModesButton.find('.arrow-right').removeClass(my.arrowRight);
        } else {
            rtcModesButton.find('.arrow-right').removeClass(my.arrowRight + "_down");
            rtcModesButton.find('.arrow-right').addClass(my.arrowRight);
        }
    };

    /*
    * Helper function to lock the RTC (via datapoint);
    * lockvalue == 0: RTC is unlocked
    * lockvalue == 1: RTC is locked
    */
    my.setLockMode = function (lockValue) {
        var $cont = $("#rtc");
        var lockElement = $("#rtc .rtc-lockmode-img");
        var plusButton = $cont.find('.inc');
        var minusButton = $cont.find('.dec');
        var lock = rtc.getLockFlag();

        if (lockValue === 0) {
            lockElement.hide();

            RtcUi.activateButton(minusButton, my.iconMinus);
            RtcUi.activateButton(plusButton, my.iconPlus);
            RtcUi.setModeButtonState(true);
            RtcUi.setSliderState(true);
            RtcUi.setTimerState(true);
            RtcUi.setModeExtensionVisibility(true, my.arrowRight);
            rtc.setLockFlag(false);
        } else if (lockValue === 1) {
            lockElement.show();

            RtcUi.deactivateButton(minusButton, my.iconMinus);
            RtcUi.deactivateButton(plusButton, my.iconPlus);
            RtcUi.setModeButtonState(false);
            RtcUi.setSliderState(false);
            RtcUi.setTimerState(false);
            RtcUi.setModeExtensionVisibility(false, my.arrowRight);

            //fip back and go to home
            var coverFlipContainer = $(".coverflip-container");
            if (!lock && coverFlipContainer.hasClass("flip-animation")) {
                NavbarController.getInstance().openFirstFunction();
            }
            rtc.setLockFlag(true);
        }
    };


    return my;

}());