﻿/*global $, rtc, registerEventsForPressButton*/
/*jslint browser: true*/

var RtcModes = (function () {
    var my = {},
        I18nTexts = window.Gira.appLang.appI18nTexts;
    my.heatingCoolingMode = "";
    my.opts = {};
    my.operationModes = {};
    my.operationModeTag = undefined;
    my.tagValue2OpMode = { 1: 'comfort', 2: 'standby', 3: 'economy', 4: 'thermalprotection' };
    my.statesEnum = { 'SWITCH_MODE': 0, 'EDIT_MODE_ARROW': 1, 'EDIT_MODE_DETAIL': 2 };
    my.state = my.statesEnum.SWITCH_MODE;
    my.currentDetailModeTag = 'comfort';
    my.rtcId = "";

    my.init = function (operationModes, operationModeTag, rtcId) {
        my.rtcId = rtcId;
        my.operationModes = operationModes;
        my.operationModeTag = operationModeTag;
    };

    my.buildModes = function () {
        $(".icon.hot").hide();
        $(".temp-hot").hide();
        $(".icon.cold").hide();
        $(".temp-cold").hide();
        $(".icon.seperator").hide();

        switch (my.heatingCoolingMode) {
        case "HeatingAndCooling":
            $(".icon.seperator").show();
            $(".icon.hot").show();
            $(".temp-hot").show();
            $(".icon.cold").show();
            $(".temp-cold").show();
            break;
        case "Heating":
            $(".icon.hot").show();
            $(".temp-hot").show();
            break;
        case "Cooling":
            $(".icon.cold").css("left", $(".icon.hot").css("left"));
            $(".temp-cold").css("left", $(".temp-hot").css("left"));
            $(".icon.cold").show();
            $(".temp-cold").show();
            break;
        }

        for (var i in my.opts.modes) {
            var mode = my.opts.modes[i];
            var ul = $('#rtc-modes ul');
            for (var j = 0; j < ul.children().length; j++) {
                var childId = ul.children().eq(j).attr('id');
                var child = ul.children().eq(j);
                if (childId === "rtr-" + i) {
                    bindModeEvents(child, mode.tagValue);
                    switch (childId) {
                        case "rtr-comfort":
                            if (!isNaN(my.opts.modes.comfort.hot) && my.heatingCoolingMode != "Cooling") {
                                $("#rtr-comfort > .temp-hot").text(my.opts.modes.comfort.hot + " °C");
                            }
                            if (!isNaN(my.opts.modes.comfort.cold) && my.heatingCoolingMode != "Heating") {
                                $("#rtr-comfort > .temp-cold").text(my.opts.modes.comfort.cold + " °C");
                            }
                            break;
                        case "rtr-standby":
                            if (!isNaN(my.opts.modes.standby.hot) && my.heatingCoolingMode != "Cooling") {
                                $("#rtr-standby > .temp-hot").text(my.opts.modes.standby.hot + " °C");
                            }
                            if (!isNaN(my.opts.modes.standby.cold) && my.heatingCoolingMode != "Heating") {
                                $("#rtr-standby > .temp-cold").text(my.opts.modes.standby.cold + " °C");
                            }
                            break;
                        case "rtr-economy":
                            if (!isNaN(my.opts.modes.economy.hot) && my.heatingCoolingMode != "Cooling") {
                                $("#rtr-economy > .temp-hot").text(my.opts.modes.economy.hot + " °C");
                            }
                            if (!isNaN(my.opts.modes.economy.cold) && my.heatingCoolingMode != "Heating") {
                                $("#rtr-economy > .temp-cold").text(my.opts.modes.economy.cold + " °C");
                            }
                            break;
                        case "rtr-thermalprotection":
                            if (!isNaN(my.opts.modes.thermalprotection.hot) && my.heatingCoolingMode != "Cooling") {
                                $("#rtr-thermalprotection > .temp-hot").text(my.opts.modes.thermalprotection.hot + " °C");
                            }
                            if (!isNaN(my.opts.modes.thermalprotection.cold) && my.heatingCoolingMode != "Heating") {
                                $("#rtr-thermalprotection > .temp-cold").text(my.opts.modes.thermalprotection.cold + " °C");
                            }
                            break;
                    }
                    if (mode.active) {
                        child.addClass('active');
                        child.find('.radio').addClass('active');
                    }
                }
            }
        }
    };

    function bindModeEvents(element, tagValue) {
        var $rtcModes = $('#rtc-modes');
        var $liAndRadios = $rtcModes.find('li, .radio');
        var $rtcModeEditView = $('#rtc-mode-edit-view');

        registerEventsForPressButton(element,
           function () {
               my.onModiEntry(element, spriteDown);
           }, function () {
               my.onModiEntry(element, spriteUp);
           }, function () {
               switch (my.state) {
                   case my.statesEnum.SWITCH_MODE:
                       $liAndRadios.removeClass('active');
                       element.find('.radio').andSelf().addClass('active');
                       my.setModeActive(tagValue);
                       break;
                   case my.statesEnum.EDIT_MODE_ARROW:
                       if (my.operationModes[my.tagValue2OpMode[tagValue]].isEditable) {
                           var left = parseInt($rtcModeEditView.css('left'));
                           $rtcModes.animate({ left: -left }, 500, function () { });
                           $rtcModeEditView.find('.header div[id]').hide().filter('#' + my.operationModes[my.tagValue2OpMode[tagValue]].editId).show();
                           my.state = my.statesEnum.EDIT_MODE_DETAIL;
                           my.currentDetailModeTag = my.tagValue2OpMode[tagValue];
                           my.scrollRtcModesSpinningWheel();
                           $('.rtcModeEdit').data('swiper').setWrapperTranslate(0, 0, 0);
                           $rtcModeEditView.show().animate({ left: 0 }, 500, function () { });
                           $rtcModeEditView.find('.rtcModeEdit').data('swiper').reInit();
                           NavbarController.getInstance().addBackFunction(function () {
                               my.toggle(my.statesEnum.EDIT_MODE_ARROW);
                               $rtcModes.animate({ left: 0 }, 500, function () { });
                               $rtcModeEditView.animate({ left: left }, 500, function () { $rtcModeEditView.hide(); });
                           });
                       }
                       break;
                   default:
                       console.log('find out why ' + my.state);
                       break;
               }
           });
    }

    my.onModiEntry = function (modiEntry, sprite) {
        if (!modiEntry.hasClass('disabled') &&
        ((!modiEntry.hasClass('down') && sprite == spriteDown) ||
        (modiEntry.hasClass('down') && sprite == spriteUp))) {
            modiEntry.toggleClass('down');
            var $span = modiEntry.find('span');
            $span.filter('.label').toggleClass('t1sg').toggleClass('t1ws');
            $span.filter('.temp-hot, .temp-cold').toggleClass('t2sg').toggleClass('t2ws');

            try {
                sprite($span.filter('.icon')[0]);
                sprite($span.filter('.icon.hot')[0]);
                sprite($span.filter('.icon.cold')[0]);
                sprite($span.filter('.icon.arrow-right')[0]);
            } catch (e) {

            }
        }
    };

    my.setModeActive = function (modeTagValue) {
        if (isNaN(modeTagValue)) {
            modeTagValue = 1;
        }
        var modeObjectName = "";
        var mode;
        for (var i in my.opts.modes) {
            my.opts.modes[i].active = false;

            if (my.opts.modes[i].tagValue === modeTagValue) {
                modeObjectName = i;
                mode = my.opts.modes[i];
            }
        }
        mode.active = true;
        mode.clicked = true;

        var ul = $('#rtc-modes ul');
        for (var j = 0; j < ul.children().length; j++) {
            var childId = ul.children().eq(j).attr('id');
            var child = ul.children().eq(j);
            if (childId === "rtr-" + modeObjectName) {
                if (mode.active) {
                    child.addClass('active');
                    child.find('.radio').addClass('active');
                }
            }
        }
    };

    my.resetClickState = function () {
        for (var i in my.opts.modes) {
            my.opts.modes[i].clicked = false;
        }
    };

    my.getActiveMode = function () {
        for (var i in my.opts.modes) {
            if (my.opts.modes[i].active) {
                return my.opts.modes[i];
            }
        }
        return null;
    };

    my.getActiveLiElement = function () {
        var ul = $('#rtc-modes ul');
        for (var j = 0; j < ul.children().length; j++) {
            var childId = ul.children().eq(j).attr('id');
            var childActive = ul.children().eq(j).hasClass("active");
            var child = ul.children().eq(j);
            if (childActive) {
                return child;
            }
        }
        return null;
    };

    function sendActiveModeToGds(operationModeTag) {
        var activeMode = my.getActiveMode();
        ComClient.sendTagValue(operationModeTag, activeMode.tagValue);
    }

    /*
     * setModeExtVisibility will set visibility for "presence button" in case when user sets the same "operation mode"
     * which is already on GDS, in this case temporary case set will not fire callback where we are setting visibility
     * for this button and we need to handle it here
     */
    function setModeExtVisibility () {
        var activeModeObj = my.getActiveMode(),
            currentGdsOperationMode = ComClient.getTagValue(rtc.operationModeStatusTag),
            activeModeDesc ;
        if (activeModeObj) {
            activeModeDesc =  my.tagValue2OpMode[activeModeObj.tagValue];
            if((currentGdsOperationMode == activeModeObj.tagValue) && activeModeDesc) {
                RtcUi.setModeExtensionVisibility(activeModeDesc != "comfort");
            }
        }
    }

    my.updateActiveMode = function (operationModeTag) {
        setModeExtVisibility();
        sendActiveModeToGds(operationModeTag);
        my.resetClickState();
    };

    /**
 * Registers the case sets for operation mode status & icons
 * 
 * @param {int} operationModeStatus Datapoint id for actual operation mode
 */
    my.registerRtcOperationModeStatusCaseSets = function (operationModeStatus) {
        var $operationModeLabel = $("#rtc .operation-mode-text");
        var $operationModeSymbol = $("#rtc .operation-mode-symbol");
        var $editBtn = $('#rtcEditBtn');
        // Heating status case set
        temporaryCaseSets.push(new CaseSet(operationModeStatus, CaseSetType.CONTENT)
            .addCase(new Case().setExpectedValue(1).setNewValue("comfort"))
            .addCase(new Case().setExpectedValue(2).setNewValue("standby"))
            .addCase(new Case().setExpectedValue(3).setNewValue("economy"))
            .addCase(new Case().setExpectedValue(4).setNewValue("thermalprotection"))
            .setOnValueFunction(function (value) {
                if (value) {
                    var cName = $operationModeSymbol[0].className;
                    var sprite = '' + cName.match(/sprite_\w*-\w*_detail/i);
                    var isModeExtensionVisible = (value != "comfort");
                    $operationModeLabel.html(my.operationModes[value].label);
                    $operationModeSymbol.removeClass(sprite).addClass(my.operationModes[value].icon);
                    // set visibility for presence button on UI based on presence state
                    RtcUi.setModeExVisibilityByPresenceState(isModeExtensionVisible);
                    if (value == "thermalprotection") {
                        RtcUi.setIncDecButtonState(false);
                        RtcUi.setSliderState(false);
                        rtc.setThermalProtectionActive(true);
                    } else {
                        RtcUi.setSliderState(true);
                        rtc.setThermalProtectionActive(false);
                    }
                }
            })
        );
    };

    my.initRtcModesEvents = function () {
        var $rtcModes = $('#rtc-modes');
        var $buttons = $rtcModes.find('.buttons .btn');
        var $endBtn = $buttons.filter('.btnEnd');
        var $okBtn = $buttons.filter('.btnOk');
        var $editBtn = $buttons.filter('.btnEdit');
        var $header = $rtcModes.find('.header div');
        var $headerSwitchMode = $header.filter('.switch_mode');
        var $headerEditMode = $header.filter('.edit_mode');

        var $rtcModeEditButtons = $('#rtc-mode-edit-view .buttons .btn');
        var $editSaveBtn = $rtcModeEditButtons.filter('.btnEditSave');
        var $editCancelBtn = $rtcModeEditButtons.filter('.btnEditCancel');

        my.toggle = function (state) {
            my.state = state;
            if (state === my.statesEnum.SWITCH_MODE) {
                $headerEditMode.hide();
                $headerSwitchMode.show();
                $okBtn.hide();
                $endBtn.show();
                $editBtn.removeClass('timerFadeOut');
                $editBtn.addClass('timerFadeIn');
            } else if(state=== my.statesEnum.EDIT_MODE_ARROW){
                $headerSwitchMode.hide();
                $headerEditMode.show();
                $endBtn.hide();
                $okBtn.show();
                $editBtn.removeClass('timerFadeIn');
                $editBtn.addClass('timerFadeOut');
            }

            $rtcModes.find('>ul li').each(function () {
                var $this = $(this);
                var $radios = $this.find('.radio');
                var $rightArrows = $this.find('.arrow-right');
                var isEditable = my.operationModes[this.id.substr("rtr-".length)].isEditable;
                if (state === my.statesEnum.SWITCH_MODE) {
                    $radios.removeClass('timerFadeOut');
                    $radios.addClass('timerFadeIn');
                    if (isEditable) {
                        $rightArrows.removeClass('timerFadeIn');
                        $rightArrows.addClass('timerFadeOut');
                    } else {
                        switchLiAndIcons($this, true);
                    }
                } else if (state === my.statesEnum.EDIT_MODE_ARROW) {
                    $radios.removeClass('timerFadeIn');
                    $radios.addClass('timerFadeOut');
                    if (isEditable) {
                        $rightArrows.removeClass('timerFadeOut');
                        $rightArrows.addClass('timerFadeIn');
                    } else {
                        switchLiAndIcons($this, false);
                    }
                }
            });
        };

        function switchLiAndIcons($li, isActive) {
            $li.find('span.sprites').each(function () {
                var $sprite = $(this);
                var spriteClass = $sprite.attr('class');
                var cName = spriteClass.match(/\bsprite_\S*/i);
                if (isActive) {
                    if (cName != null && cName[0].match("_inactive") != null) {
                        $sprite.removeClass(cName[0]);
                        $li.removeClass('disabled');
                        $sprite.addClass(spriteClass.replace(cName[0], cName[0].substring(0, cName[0].indexOf("_inactive"))));
                    }
                } else {
                    if (cName != null && cName[0].match("_inactive") == null) {
                        $sprite.removeClass(cName[0]);
                        $li.addClass('disabled');
                        $sprite.addClass(spriteClass.replace(cName[0], cName[0] + "_inactive"));
                    }
                }
            });
        }

        registerEventsForPressButton($endBtn,
            function () {
                $endBtn.addClass('down');
            }, function () {
                $endBtn.removeClass('down');
            }, function () {
                my.updateActiveMode(my.operationModeTag);
                NavbarController.getInstance().back();
            });

        registerEventsForPressButton($editBtn,
            function () {
                $editBtn.addClass('down');
            }, function () {
                $editBtn.removeClass('down');
            }, function() { my.toggle(my.statesEnum.EDIT_MODE_ARROW); });

        registerEventsForPressButton($okBtn,
            function () {
                $okBtn.addClass('down');
            }, function () {
                $okBtn.removeClass('down');
            }, function () { my.toggle(my.statesEnum.SWITCH_MODE); });

        registerEventsForPressButton($editSaveBtn,
            function () {
                $editSaveBtn.addClass('down');
            }, function () {
                $editSaveBtn.removeClass('down');
            }, function () {
                my.setModeEditTemperature();
                NavbarController.getInstance().back();
            });

        registerEventsForPressButton($editCancelBtn,
            function () {
                $editCancelBtn.addClass('down');
            }, function () {
                $editCancelBtn.removeClass('down');
            }, function() {
                NavbarController.getInstance().back();
            });
        my.toggle(my.statesEnum.SWITCH_MODE);
    };
    
    my.initRtcModesSpinningWheel = function (spinnWheelId, stepWide) {
        var arrayLength = parseInt(my.opts.modes.thermalprotection.cold) - parseInt(my.opts.modes.thermalprotection.hot) + 1;
        var intWheel = Array.apply(null, Array(arrayLength)).map(function (_, i) {
            var current = i + parseInt(my.opts.modes.thermalprotection.hot);
            return ('0' + current).slice(-2);
        });
        var decWheel;
        switch (stepWide) {
            case 0.1:
                decWheel = Array.apply(null, Array(10)).map(function (_, i) { return ('' + i); });
                break;
            case 0.5:
                decWheel = ['0', '5'];
                break;
            case 1:
            case 1.0:
            default:
                decWheel = ['0'];
                break;
        }

        var wheels = [{ 'degrees': intWheel, 'defaultValue': '10' }, { 'degrees': decWheel, 'defaultValue': '0' }];

        var spinnWheel = SpinningWheel.create({ 'spinnWheelId': spinnWheelId, 'isFloat': true, 'wheels': wheels });
        
    };
    
    my.scrollRtcModesSpinningWheel = function () {
        var hotTempWheel = SpinningWheel.getById('rtr-edit-hot-slotmachine');
        var coldTempWheel = SpinningWheel.getById('rtr-edit-cold-slotmachine');
        
        if (my.heatingCoolingMode == "Heating" || my.heatingCoolingMode == "HeatingAndCooling") {
            var defaultHotValue;
            switch (my.currentDetailModeTag) {
                case 'comfort':
                    defaultHotValue = my.opts.modes.comfort.hot;
                    break;
                case 'standby':
                    defaultHotValue = my.opts.modes.standby.hot;
                    break;
                case 'economy':
                    defaultHotValue = my.opts.modes.economy.hot;
                    break;
                default:
                    defaultHotValue = '10.0';
                    break;
            }
            if (!isNaN(defaultHotValue)) {
                defaultHotValue = defaultHotValue.split('.');
                defaultHotValue[1] = defaultHotValue[1].substring(0, 1);
                hotTempWheel.scrollToValue(0, defaultHotValue[0]);
                hotTempWheel.scrollToValue(1, defaultHotValue[1]);
            }
        }
        
        if (my.heatingCoolingMode == "Cooling" || my.heatingCoolingMode == "HeatingAndCooling") {
            var defaultColdValue;
            switch (my.currentDetailModeTag) {
                case 'comfort':
                    defaultColdValue = my.opts.modes.comfort.cold;
                    break;
                case 'standby':
                    defaultColdValue = my.opts.modes.standby.cold;
                    break;
                case 'economy':
                    defaultColdValue = my.opts.modes.economy.cold;
                    break;
                default:
                    defaultColdValue = '10.0';
                    break;
            }
            if (!isNaN(defaultColdValue)) {
                defaultColdValue = defaultColdValue.split('.');
                defaultColdValue[1] = defaultColdValue[1].substring(0, 1);
                coldTempWheel.scrollToValue(0, defaultColdValue[0]);
                coldTempWheel.scrollToValue(1, defaultColdValue[1]);
            }
        }
    };
    
    /**
    *set the new min/max temperature Value to the GDS
    */
    my.setModeEditTemperature = function () {
        var hotTempWheelId = 'rtr-edit-hot-slotmachine';
        var coldTempWheelId = 'rtr-edit-cold-slotmachine';
        var hotValue = '';
        var coldValue = '';

        if (my.heatingCoolingMode == "Heating" || my.heatingCoolingMode == "HeatingAndCooling") {
            var currentHotSpinValue = SpinningWheel.getCurrentValueById(hotTempWheelId);
            if (currentHotSpinValue != null) {
                if (currentHotSpinValue.length == 2) {
                    hotValue = currentHotSpinValue[0].value + '.' + currentHotSpinValue[1].value;
                } else {
                    hotValue = Number(currentHotSpinValue[0].value);
                }
            }
            switch (my.currentDetailModeTag) {
                case 'comfort':
                    my.opts.modes.comfort.hot = hotValue;
                    $("#rtr-comfort > .temp-hot").text(hotValue + " °C");
                    tsxGdsUtility$.setTemperatureSetPoint(my.rtcId, "ComfortHeatTemperatureLimit", hotValue);
                    break;
                case 'standby':
                    my.opts.modes.standby.hot = hotValue;
                    $("#rtr-standby > .temp-hot").text(hotValue + " °C");
                    tsxGdsUtility$.setTemperatureSetPoint(my.rtcId, "StandbyHeatTemperatureLimit", hotValue);
                    break;
                case 'economy':
                    my.opts.modes.economy.hot = hotValue;
                    $("#rtr-economy > .temp-hot").text(hotValue + " °C");
                    tsxGdsUtility$.setTemperatureSetPoint(my.rtcId, "EconomyHeatTemperatureLimit", hotValue);
                    break;
                default:
                    break;
            }
        }

        if (my.heatingCoolingMode == "Cooling" || my.heatingCoolingMode == "HeatingAndCooling") {
            var currentSpinValue = SpinningWheel.getCurrentValueById(coldTempWheelId);
            if (currentSpinValue != null) {
                if (currentSpinValue.length == 2) {
                    coldValue = currentSpinValue[0].value + '.' + currentSpinValue[1].value;
                } else {
                    coldValue = Number(currentSpinValue[0].value);
                }
            }
            switch (my.currentDetailModeTag) {
                case 'comfort':
                    my.opts.modes.comfort.cold = coldValue;
                    $("#rtr-comfort > .temp-cold").text(coldValue + " °C");
                    tsxGdsUtility$.setTemperatureSetPoint(my.rtcId, "ComfortCoolTemperatureLimit", coldValue);
                    break;
                case 'standby':
                    my.opts.modes.standby.cold = coldValue;
                    $("#rtr-standby > .temp-cold").text(coldValue + " °C");
                    tsxGdsUtility$.setTemperatureSetPoint(my.rtcId, "StandbyCoolTemperatureLimit", coldValue);
                    break;
                case 'economy':
                    my.opts.modes.economy.cold = coldValue;
                    $("#rtr-economy > .temp-cold").text(coldValue + " °C");
                    tsxGdsUtility$.setTemperatureSetPoint(my.rtcId, "EconomyCoolTemperatureLimit", coldValue);
                    break;
                default:
                    break;
            }
        }
    }

    return my;

}());


